/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.organizations.model.HandshakeResourceType;
import software.amazon.awssdk.services.organizations.model.HandshakeResourcesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HandshakeResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HandshakeResource> {
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HandshakeResource.getter(HandshakeResource::value)).setter(HandshakeResource.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HandshakeResource.getter(HandshakeResource::typeAsString)).setter(HandshakeResource.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<List<HandshakeResource>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(HandshakeResource.getter(HandshakeResource::resources)).setter(HandshakeResource.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HandshakeResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, TYPE_FIELD, RESOURCES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String value;
    private final String type;
    private final List<HandshakeResource> resources;

    private HandshakeResource(BuilderImpl builder) {
        this.value = builder.value;
        this.type = builder.type;
        this.resources = builder.resources;
    }

    public String value() {
        return this.value;
    }

    public HandshakeResourceType type() {
        return HandshakeResourceType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public List<HandshakeResource> resources() {
        return this.resources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resources());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HandshakeResource)) {
            return false;
        }
        HandshakeResource other = (HandshakeResource)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.resources(), other.resources());
    }

    public String toString() {
        return ToString.builder((String)"HandshakeResource").add("Value", (Object)(this.value() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)this.typeAsString()).add("Resources", this.resources()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HandshakeResource, T> g) {
        return obj -> g.apply((HandshakeResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String value;
        private String type;
        private List<HandshakeResource> resources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HandshakeResource model) {
            this.value(model.value);
            this.type(model.type);
            this.resources(model.resources);
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(HandshakeResourceType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Collection<Builder> getResources() {
            return this.resources != null ? (Collection)this.resources.stream().map(HandshakeResource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resources(Collection<HandshakeResource> resources) {
            this.resources = HandshakeResourcesCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(HandshakeResource ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<Builder> ... resources) {
            this.resources(Stream.of(resources).map(c -> (HandshakeResource)((Builder)HandshakeResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResources(Collection<BuilderImpl> resources) {
            this.resources = HandshakeResourcesCopier.copyFromBuilder(resources);
        }

        public HandshakeResource build() {
            return new HandshakeResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HandshakeResource> {
        public Builder value(String var1);

        public Builder type(String var1);

        public Builder type(HandshakeResourceType var1);

        public Builder resources(Collection<HandshakeResource> var1);

        public Builder resources(HandshakeResource ... var1);

        public Builder resources(Consumer<Builder> ... var1);
    }
}

