/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.organizations.model.CreateAccountState;
import software.amazon.awssdk.services.organizations.model.CreateAccountStatesCopier;
import software.amazon.awssdk.services.organizations.model.OrganizationsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCreateAccountStatusRequest
extends OrganizationsRequest
implements ToCopyableBuilder<Builder, ListCreateAccountStatusRequest> {
    private static final SdkField<List<String>> STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListCreateAccountStatusRequest.getter(ListCreateAccountStatusRequest::statesAsStrings)).setter(ListCreateAccountStatusRequest.setter(Builder::statesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("States").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListCreateAccountStatusRequest.getter(ListCreateAccountStatusRequest::nextToken)).setter(ListCreateAccountStatusRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListCreateAccountStatusRequest.getter(ListCreateAccountStatusRequest::maxResults)).setter(ListCreateAccountStatusRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATES_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final List<String> states;
    private final String nextToken;
    private final Integer maxResults;

    private ListCreateAccountStatusRequest(BuilderImpl builder) {
        super(builder);
        this.states = builder.states;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public List<CreateAccountState> states() {
        return CreateAccountStatesCopier.copyStringToEnum(this.states);
    }

    public List<String> statesAsStrings() {
        return this.states;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCreateAccountStatusRequest)) {
            return false;
        }
        ListCreateAccountStatusRequest other = (ListCreateAccountStatusRequest)((Object)obj);
        return Objects.equals(this.statesAsStrings(), other.statesAsStrings()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"ListCreateAccountStatusRequest").add("States", this.statesAsStrings()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "States": {
                return Optional.ofNullable(clazz.cast(this.statesAsStrings()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCreateAccountStatusRequest, T> g) {
        return obj -> g.apply((ListCreateAccountStatusRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OrganizationsRequest.BuilderImpl
    implements Builder {
        private List<String> states = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCreateAccountStatusRequest model) {
            super(model);
            this.statesWithStrings(model.states);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Collection<String> getStatesAsStrings() {
            return this.states;
        }

        @Override
        public final Builder statesWithStrings(Collection<String> states) {
            this.states = CreateAccountStatesCopier.copy(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statesWithStrings(String ... states) {
            this.statesWithStrings(Arrays.asList(states));
            return this;
        }

        @Override
        public final Builder states(Collection<CreateAccountState> states) {
            this.states = CreateAccountStatesCopier.copyEnumToString(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder states(CreateAccountState ... states) {
            this.states(Arrays.asList(states));
            return this;
        }

        public final void setStatesWithStrings(Collection<String> states) {
            this.states = CreateAccountStatesCopier.copy(states);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCreateAccountStatusRequest build() {
            return new ListCreateAccountStatusRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OrganizationsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCreateAccountStatusRequest> {
        public Builder statesWithStrings(Collection<String> var1);

        public Builder statesWithStrings(String ... var1);

        public Builder states(Collection<CreateAccountState> var1);

        public Builder states(CreateAccountState ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

