/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.organizations.OrganizationsAsyncClient;
import software.amazon.awssdk.services.organizations.model.AcceptHandshakeRequest;
import software.amazon.awssdk.services.organizations.model.AcceptHandshakeResponse;
import software.amazon.awssdk.services.organizations.model.AccessDeniedException;
import software.amazon.awssdk.services.organizations.model.AccessDeniedForDependencyException;
import software.amazon.awssdk.services.organizations.model.AccountNotFoundException;
import software.amazon.awssdk.services.organizations.model.AccountOwnerNotVerifiedException;
import software.amazon.awssdk.services.organizations.model.AlreadyInOrganizationException;
import software.amazon.awssdk.services.organizations.model.AttachPolicyRequest;
import software.amazon.awssdk.services.organizations.model.AttachPolicyResponse;
import software.amazon.awssdk.services.organizations.model.AwsOrganizationsNotInUseException;
import software.amazon.awssdk.services.organizations.model.CancelHandshakeRequest;
import software.amazon.awssdk.services.organizations.model.CancelHandshakeResponse;
import software.amazon.awssdk.services.organizations.model.ChildNotFoundException;
import software.amazon.awssdk.services.organizations.model.ConcurrentModificationException;
import software.amazon.awssdk.services.organizations.model.ConstraintViolationException;
import software.amazon.awssdk.services.organizations.model.CreateAccountRequest;
import software.amazon.awssdk.services.organizations.model.CreateAccountResponse;
import software.amazon.awssdk.services.organizations.model.CreateAccountStatusNotFoundException;
import software.amazon.awssdk.services.organizations.model.CreateOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.CreateOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.CreateOrganizationalUnitRequest;
import software.amazon.awssdk.services.organizations.model.CreateOrganizationalUnitResponse;
import software.amazon.awssdk.services.organizations.model.CreatePolicyRequest;
import software.amazon.awssdk.services.organizations.model.CreatePolicyResponse;
import software.amazon.awssdk.services.organizations.model.DeclineHandshakeRequest;
import software.amazon.awssdk.services.organizations.model.DeclineHandshakeResponse;
import software.amazon.awssdk.services.organizations.model.DeleteOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.DeleteOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.DeleteOrganizationalUnitRequest;
import software.amazon.awssdk.services.organizations.model.DeleteOrganizationalUnitResponse;
import software.amazon.awssdk.services.organizations.model.DeletePolicyRequest;
import software.amazon.awssdk.services.organizations.model.DeletePolicyResponse;
import software.amazon.awssdk.services.organizations.model.DescribeAccountRequest;
import software.amazon.awssdk.services.organizations.model.DescribeAccountResponse;
import software.amazon.awssdk.services.organizations.model.DescribeCreateAccountStatusRequest;
import software.amazon.awssdk.services.organizations.model.DescribeCreateAccountStatusResponse;
import software.amazon.awssdk.services.organizations.model.DescribeHandshakeRequest;
import software.amazon.awssdk.services.organizations.model.DescribeHandshakeResponse;
import software.amazon.awssdk.services.organizations.model.DescribeOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.DescribeOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.DescribeOrganizationalUnitRequest;
import software.amazon.awssdk.services.organizations.model.DescribeOrganizationalUnitResponse;
import software.amazon.awssdk.services.organizations.model.DescribePolicyRequest;
import software.amazon.awssdk.services.organizations.model.DescribePolicyResponse;
import software.amazon.awssdk.services.organizations.model.DestinationParentNotFoundException;
import software.amazon.awssdk.services.organizations.model.DetachPolicyRequest;
import software.amazon.awssdk.services.organizations.model.DetachPolicyResponse;
import software.amazon.awssdk.services.organizations.model.DisableAWSServiceAccessResponse;
import software.amazon.awssdk.services.organizations.model.DisableAwsServiceAccessRequest;
import software.amazon.awssdk.services.organizations.model.DisablePolicyTypeRequest;
import software.amazon.awssdk.services.organizations.model.DisablePolicyTypeResponse;
import software.amazon.awssdk.services.organizations.model.DuplicateAccountException;
import software.amazon.awssdk.services.organizations.model.DuplicateHandshakeException;
import software.amazon.awssdk.services.organizations.model.DuplicateOrganizationalUnitException;
import software.amazon.awssdk.services.organizations.model.DuplicatePolicyAttachmentException;
import software.amazon.awssdk.services.organizations.model.DuplicatePolicyException;
import software.amazon.awssdk.services.organizations.model.EnableAWSServiceAccessResponse;
import software.amazon.awssdk.services.organizations.model.EnableAllFeaturesRequest;
import software.amazon.awssdk.services.organizations.model.EnableAllFeaturesResponse;
import software.amazon.awssdk.services.organizations.model.EnableAwsServiceAccessRequest;
import software.amazon.awssdk.services.organizations.model.EnablePolicyTypeRequest;
import software.amazon.awssdk.services.organizations.model.EnablePolicyTypeResponse;
import software.amazon.awssdk.services.organizations.model.FinalizingOrganizationException;
import software.amazon.awssdk.services.organizations.model.HandshakeAlreadyInStateException;
import software.amazon.awssdk.services.organizations.model.HandshakeConstraintViolationException;
import software.amazon.awssdk.services.organizations.model.HandshakeNotFoundException;
import software.amazon.awssdk.services.organizations.model.InvalidHandshakeTransitionException;
import software.amazon.awssdk.services.organizations.model.InvalidInputException;
import software.amazon.awssdk.services.organizations.model.InviteAccountToOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.InviteAccountToOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.LeaveOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.LeaveOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.ListAccountsForParentRequest;
import software.amazon.awssdk.services.organizations.model.ListAccountsForParentResponse;
import software.amazon.awssdk.services.organizations.model.ListAccountsRequest;
import software.amazon.awssdk.services.organizations.model.ListAccountsResponse;
import software.amazon.awssdk.services.organizations.model.ListAwsServiceAccessForOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.ListAwsServiceAccessForOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.ListChildrenRequest;
import software.amazon.awssdk.services.organizations.model.ListChildrenResponse;
import software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusRequest;
import software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusResponse;
import software.amazon.awssdk.services.organizations.model.ListHandshakesForAccountRequest;
import software.amazon.awssdk.services.organizations.model.ListHandshakesForAccountResponse;
import software.amazon.awssdk.services.organizations.model.ListHandshakesForOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.ListHandshakesForOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentRequest;
import software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentResponse;
import software.amazon.awssdk.services.organizations.model.ListParentsRequest;
import software.amazon.awssdk.services.organizations.model.ListParentsResponse;
import software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetRequest;
import software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetResponse;
import software.amazon.awssdk.services.organizations.model.ListPoliciesRequest;
import software.amazon.awssdk.services.organizations.model.ListPoliciesResponse;
import software.amazon.awssdk.services.organizations.model.ListRootsRequest;
import software.amazon.awssdk.services.organizations.model.ListRootsResponse;
import software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyRequest;
import software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyResponse;
import software.amazon.awssdk.services.organizations.model.MalformedPolicyDocumentException;
import software.amazon.awssdk.services.organizations.model.MasterCannotLeaveOrganizationException;
import software.amazon.awssdk.services.organizations.model.MoveAccountRequest;
import software.amazon.awssdk.services.organizations.model.MoveAccountResponse;
import software.amazon.awssdk.services.organizations.model.OrganizationNotEmptyException;
import software.amazon.awssdk.services.organizations.model.OrganizationalUnitNotEmptyException;
import software.amazon.awssdk.services.organizations.model.OrganizationalUnitNotFoundException;
import software.amazon.awssdk.services.organizations.model.OrganizationsException;
import software.amazon.awssdk.services.organizations.model.OrganizationsRequest;
import software.amazon.awssdk.services.organizations.model.ParentNotFoundException;
import software.amazon.awssdk.services.organizations.model.PolicyInUseException;
import software.amazon.awssdk.services.organizations.model.PolicyNotAttachedException;
import software.amazon.awssdk.services.organizations.model.PolicyNotFoundException;
import software.amazon.awssdk.services.organizations.model.PolicyTypeAlreadyEnabledException;
import software.amazon.awssdk.services.organizations.model.PolicyTypeNotAvailableForOrganizationException;
import software.amazon.awssdk.services.organizations.model.PolicyTypeNotEnabledException;
import software.amazon.awssdk.services.organizations.model.RemoveAccountFromOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.RemoveAccountFromOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.RootNotFoundException;
import software.amazon.awssdk.services.organizations.model.ServiceException;
import software.amazon.awssdk.services.organizations.model.SourceParentNotFoundException;
import software.amazon.awssdk.services.organizations.model.TargetNotFoundException;
import software.amazon.awssdk.services.organizations.model.TooManyRequestsException;
import software.amazon.awssdk.services.organizations.model.UpdateOrganizationalUnitRequest;
import software.amazon.awssdk.services.organizations.model.UpdateOrganizationalUnitResponse;
import software.amazon.awssdk.services.organizations.model.UpdatePolicyRequest;
import software.amazon.awssdk.services.organizations.model.UpdatePolicyResponse;
import software.amazon.awssdk.services.organizations.paginators.ListAWSServiceAccessForOrganizationPublisher;
import software.amazon.awssdk.services.organizations.paginators.ListAccountsForParentPublisher;
import software.amazon.awssdk.services.organizations.paginators.ListAccountsPublisher;
import software.amazon.awssdk.services.organizations.paginators.ListChildrenPublisher;
import software.amazon.awssdk.services.organizations.paginators.ListCreateAccountStatusPublisher;
import software.amazon.awssdk.services.organizations.paginators.ListHandshakesForAccountPublisher;
import software.amazon.awssdk.services.organizations.paginators.ListHandshakesForOrganizationPublisher;
import software.amazon.awssdk.services.organizations.paginators.ListOrganizationalUnitsForParentPublisher;
import software.amazon.awssdk.services.organizations.paginators.ListParentsPublisher;
import software.amazon.awssdk.services.organizations.paginators.ListPoliciesForTargetPublisher;
import software.amazon.awssdk.services.organizations.paginators.ListPoliciesPublisher;
import software.amazon.awssdk.services.organizations.paginators.ListRootsPublisher;
import software.amazon.awssdk.services.organizations.paginators.ListTargetsForPolicyPublisher;
import software.amazon.awssdk.services.organizations.transform.AcceptHandshakeRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.AttachPolicyRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.CancelHandshakeRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.CreateAccountRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.CreateOrganizationRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.CreateOrganizationalUnitRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.CreatePolicyRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DeclineHandshakeRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DeleteOrganizationRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DeleteOrganizationalUnitRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DeletePolicyRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DescribeAccountRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DescribeCreateAccountStatusRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DescribeHandshakeRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DescribeOrganizationRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DescribeOrganizationalUnitRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DescribePolicyRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DetachPolicyRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DisableAwsServiceAccessRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DisablePolicyTypeRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.EnableAllFeaturesRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.EnableAwsServiceAccessRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.EnablePolicyTypeRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.InviteAccountToOrganizationRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.LeaveOrganizationRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListAccountsForParentRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListAccountsRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListAwsServiceAccessForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListChildrenRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListCreateAccountStatusRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListHandshakesForAccountRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListHandshakesForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListOrganizationalUnitsForParentRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListParentsRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListPoliciesForTargetRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListPoliciesRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListRootsRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListTargetsForPolicyRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.MoveAccountRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.RemoveAccountFromOrganizationRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.UpdateOrganizationalUnitRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.UpdatePolicyRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultOrganizationsAsyncClient
implements OrganizationsAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultOrganizationsAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultOrganizationsAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "organizations";
    }

    @Override
    public CompletableFuture<AcceptHandshakeResponse> acceptHandshake(AcceptHandshakeRequest acceptHandshakeRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AcceptHandshakeResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcceptHandshake").withMarshaller((Marshaller)new AcceptHandshakeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)acceptHandshakeRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AttachPolicyResponse> attachPolicy(AttachPolicyRequest attachPolicyRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AttachPolicyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachPolicy").withMarshaller((Marshaller)new AttachPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)attachPolicyRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CancelHandshakeResponse> cancelHandshake(CancelHandshakeRequest cancelHandshakeRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelHandshakeResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelHandshake").withMarshaller((Marshaller)new CancelHandshakeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelHandshakeRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateAccountResponse> createAccount(CreateAccountRequest createAccountRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAccountResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAccount").withMarshaller((Marshaller)new CreateAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAccountRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateOrganizationResponse> createOrganization(CreateOrganizationRequest createOrganizationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateOrganizationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateOrganization").withMarshaller((Marshaller)new CreateOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createOrganizationRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateOrganizationalUnitResponse> createOrganizationalUnit(CreateOrganizationalUnitRequest createOrganizationalUnitRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateOrganizationalUnitResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateOrganizationalUnit").withMarshaller((Marshaller)new CreateOrganizationalUnitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createOrganizationalUnitRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreatePolicyResponse> createPolicy(CreatePolicyRequest createPolicyRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePolicyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePolicy").withMarshaller((Marshaller)new CreatePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPolicyRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeclineHandshakeResponse> declineHandshake(DeclineHandshakeRequest declineHandshakeRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeclineHandshakeResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeclineHandshake").withMarshaller((Marshaller)new DeclineHandshakeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)declineHandshakeRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteOrganizationResponse> deleteOrganization(DeleteOrganizationRequest deleteOrganizationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteOrganizationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteOrganization").withMarshaller((Marshaller)new DeleteOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteOrganizationRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteOrganizationalUnitResponse> deleteOrganizationalUnit(DeleteOrganizationalUnitRequest deleteOrganizationalUnitRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteOrganizationalUnitResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteOrganizationalUnit").withMarshaller((Marshaller)new DeleteOrganizationalUnitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteOrganizationalUnitRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeletePolicyResponse> deletePolicy(DeletePolicyRequest deletePolicyRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePolicyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePolicy").withMarshaller((Marshaller)new DeletePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePolicyRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAccountResponse> describeAccount(DescribeAccountRequest describeAccountRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAccountResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccount").withMarshaller((Marshaller)new DescribeAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAccountRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeCreateAccountStatusResponse> describeCreateAccountStatus(DescribeCreateAccountStatusRequest describeCreateAccountStatusRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCreateAccountStatusResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCreateAccountStatus").withMarshaller((Marshaller)new DescribeCreateAccountStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCreateAccountStatusRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeHandshakeResponse> describeHandshake(DescribeHandshakeRequest describeHandshakeRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeHandshakeResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeHandshake").withMarshaller((Marshaller)new DescribeHandshakeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeHandshakeRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeOrganizationResponse> describeOrganization(DescribeOrganizationRequest describeOrganizationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeOrganizationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOrganization").withMarshaller((Marshaller)new DescribeOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeOrganizationRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeOrganizationalUnitResponse> describeOrganizationalUnit(DescribeOrganizationalUnitRequest describeOrganizationalUnitRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeOrganizationalUnitResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOrganizationalUnit").withMarshaller((Marshaller)new DescribeOrganizationalUnitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeOrganizationalUnitRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribePolicyResponse> describePolicy(DescribePolicyRequest describePolicyRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePolicyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePolicy").withMarshaller((Marshaller)new DescribePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describePolicyRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DetachPolicyResponse> detachPolicy(DetachPolicyRequest detachPolicyRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetachPolicyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachPolicy").withMarshaller((Marshaller)new DetachPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detachPolicyRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisableAWSServiceAccessResponse> disableAWSServiceAccess(DisableAwsServiceAccessRequest disableAwsServiceAccessRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableAWSServiceAccessResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableAWSServiceAccess").withMarshaller((Marshaller)new DisableAwsServiceAccessRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableAwsServiceAccessRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisablePolicyTypeResponse> disablePolicyType(DisablePolicyTypeRequest disablePolicyTypeRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisablePolicyTypeResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisablePolicyType").withMarshaller((Marshaller)new DisablePolicyTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disablePolicyTypeRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnableAWSServiceAccessResponse> enableAWSServiceAccess(EnableAwsServiceAccessRequest enableAwsServiceAccessRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableAWSServiceAccessResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableAWSServiceAccess").withMarshaller((Marshaller)new EnableAwsServiceAccessRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableAwsServiceAccessRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnableAllFeaturesResponse> enableAllFeatures(EnableAllFeaturesRequest enableAllFeaturesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableAllFeaturesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableAllFeatures").withMarshaller((Marshaller)new EnableAllFeaturesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableAllFeaturesRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnablePolicyTypeResponse> enablePolicyType(EnablePolicyTypeRequest enablePolicyTypeRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnablePolicyTypeResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnablePolicyType").withMarshaller((Marshaller)new EnablePolicyTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enablePolicyTypeRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<InviteAccountToOrganizationResponse> inviteAccountToOrganization(InviteAccountToOrganizationRequest inviteAccountToOrganizationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, InviteAccountToOrganizationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("InviteAccountToOrganization").withMarshaller((Marshaller)new InviteAccountToOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)inviteAccountToOrganizationRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<LeaveOrganizationResponse> leaveOrganization(LeaveOrganizationRequest leaveOrganizationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, LeaveOrganizationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("LeaveOrganization").withMarshaller((Marshaller)new LeaveOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)leaveOrganizationRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListAwsServiceAccessForOrganizationResponse> listAWSServiceAccessForOrganization(ListAwsServiceAccessForOrganizationRequest listAwsServiceAccessForOrganizationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAwsServiceAccessForOrganizationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAWSServiceAccessForOrganization").withMarshaller((Marshaller)new ListAwsServiceAccessForOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAwsServiceAccessForOrganizationRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListAWSServiceAccessForOrganizationPublisher listAWSServiceAccessForOrganizationPaginator(ListAwsServiceAccessForOrganizationRequest listAwsServiceAccessForOrganizationRequest) {
        return new ListAWSServiceAccessForOrganizationPublisher(this, this.applyPaginatorUserAgent(listAwsServiceAccessForOrganizationRequest));
    }

    @Override
    public CompletableFuture<ListAccountsResponse> listAccounts(ListAccountsRequest listAccountsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAccountsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAccounts").withMarshaller((Marshaller)new ListAccountsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAccountsRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListAccountsForParentResponse> listAccountsForParent(ListAccountsForParentRequest listAccountsForParentRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAccountsForParentResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAccountsForParent").withMarshaller((Marshaller)new ListAccountsForParentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAccountsForParentRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListAccountsForParentPublisher listAccountsForParentPaginator(ListAccountsForParentRequest listAccountsForParentRequest) {
        return new ListAccountsForParentPublisher(this, this.applyPaginatorUserAgent(listAccountsForParentRequest));
    }

    @Override
    public ListAccountsPublisher listAccountsPaginator(ListAccountsRequest listAccountsRequest) {
        return new ListAccountsPublisher(this, this.applyPaginatorUserAgent(listAccountsRequest));
    }

    @Override
    public CompletableFuture<ListChildrenResponse> listChildren(ListChildrenRequest listChildrenRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListChildrenResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListChildren").withMarshaller((Marshaller)new ListChildrenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listChildrenRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListChildrenPublisher listChildrenPaginator(ListChildrenRequest listChildrenRequest) {
        return new ListChildrenPublisher(this, this.applyPaginatorUserAgent(listChildrenRequest));
    }

    @Override
    public CompletableFuture<ListCreateAccountStatusResponse> listCreateAccountStatus(ListCreateAccountStatusRequest listCreateAccountStatusRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCreateAccountStatusResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCreateAccountStatus").withMarshaller((Marshaller)new ListCreateAccountStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCreateAccountStatusRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListCreateAccountStatusPublisher listCreateAccountStatusPaginator(ListCreateAccountStatusRequest listCreateAccountStatusRequest) {
        return new ListCreateAccountStatusPublisher(this, this.applyPaginatorUserAgent(listCreateAccountStatusRequest));
    }

    @Override
    public CompletableFuture<ListHandshakesForAccountResponse> listHandshakesForAccount(ListHandshakesForAccountRequest listHandshakesForAccountRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListHandshakesForAccountResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListHandshakesForAccount").withMarshaller((Marshaller)new ListHandshakesForAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listHandshakesForAccountRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListHandshakesForAccountPublisher listHandshakesForAccountPaginator(ListHandshakesForAccountRequest listHandshakesForAccountRequest) {
        return new ListHandshakesForAccountPublisher(this, this.applyPaginatorUserAgent(listHandshakesForAccountRequest));
    }

    @Override
    public CompletableFuture<ListHandshakesForOrganizationResponse> listHandshakesForOrganization(ListHandshakesForOrganizationRequest listHandshakesForOrganizationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListHandshakesForOrganizationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListHandshakesForOrganization").withMarshaller((Marshaller)new ListHandshakesForOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listHandshakesForOrganizationRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListHandshakesForOrganizationPublisher listHandshakesForOrganizationPaginator(ListHandshakesForOrganizationRequest listHandshakesForOrganizationRequest) {
        return new ListHandshakesForOrganizationPublisher(this, this.applyPaginatorUserAgent(listHandshakesForOrganizationRequest));
    }

    @Override
    public CompletableFuture<ListOrganizationalUnitsForParentResponse> listOrganizationalUnitsForParent(ListOrganizationalUnitsForParentRequest listOrganizationalUnitsForParentRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListOrganizationalUnitsForParentResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListOrganizationalUnitsForParent").withMarshaller((Marshaller)new ListOrganizationalUnitsForParentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listOrganizationalUnitsForParentRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListOrganizationalUnitsForParentPublisher listOrganizationalUnitsForParentPaginator(ListOrganizationalUnitsForParentRequest listOrganizationalUnitsForParentRequest) {
        return new ListOrganizationalUnitsForParentPublisher(this, this.applyPaginatorUserAgent(listOrganizationalUnitsForParentRequest));
    }

    @Override
    public CompletableFuture<ListParentsResponse> listParents(ListParentsRequest listParentsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListParentsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListParents").withMarshaller((Marshaller)new ListParentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listParentsRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListParentsPublisher listParentsPaginator(ListParentsRequest listParentsRequest) {
        return new ListParentsPublisher(this, this.applyPaginatorUserAgent(listParentsRequest));
    }

    @Override
    public CompletableFuture<ListPoliciesResponse> listPolicies(ListPoliciesRequest listPoliciesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPoliciesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPolicies").withMarshaller((Marshaller)new ListPoliciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPoliciesRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListPoliciesForTargetResponse> listPoliciesForTarget(ListPoliciesForTargetRequest listPoliciesForTargetRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPoliciesForTargetResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPoliciesForTarget").withMarshaller((Marshaller)new ListPoliciesForTargetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPoliciesForTargetRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListPoliciesForTargetPublisher listPoliciesForTargetPaginator(ListPoliciesForTargetRequest listPoliciesForTargetRequest) {
        return new ListPoliciesForTargetPublisher(this, this.applyPaginatorUserAgent(listPoliciesForTargetRequest));
    }

    @Override
    public ListPoliciesPublisher listPoliciesPaginator(ListPoliciesRequest listPoliciesRequest) {
        return new ListPoliciesPublisher(this, this.applyPaginatorUserAgent(listPoliciesRequest));
    }

    @Override
    public CompletableFuture<ListRootsResponse> listRoots(ListRootsRequest listRootsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRootsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRoots").withMarshaller((Marshaller)new ListRootsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRootsRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListRootsPublisher listRootsPaginator(ListRootsRequest listRootsRequest) {
        return new ListRootsPublisher(this, this.applyPaginatorUserAgent(listRootsRequest));
    }

    @Override
    public CompletableFuture<ListTargetsForPolicyResponse> listTargetsForPolicy(ListTargetsForPolicyRequest listTargetsForPolicyRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTargetsForPolicyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTargetsForPolicy").withMarshaller((Marshaller)new ListTargetsForPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTargetsForPolicyRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListTargetsForPolicyPublisher listTargetsForPolicyPaginator(ListTargetsForPolicyRequest listTargetsForPolicyRequest) {
        return new ListTargetsForPolicyPublisher(this, this.applyPaginatorUserAgent(listTargetsForPolicyRequest));
    }

    @Override
    public CompletableFuture<MoveAccountResponse> moveAccount(MoveAccountRequest moveAccountRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, MoveAccountResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("MoveAccount").withMarshaller((Marshaller)new MoveAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)moveAccountRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RemoveAccountFromOrganizationResponse> removeAccountFromOrganization(RemoveAccountFromOrganizationRequest removeAccountFromOrganizationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveAccountFromOrganizationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveAccountFromOrganization").withMarshaller((Marshaller)new RemoveAccountFromOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeAccountFromOrganizationRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateOrganizationalUnitResponse> updateOrganizationalUnit(UpdateOrganizationalUnitRequest updateOrganizationalUnitRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateOrganizationalUnitResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateOrganizationalUnit").withMarshaller((Marshaller)new UpdateOrganizationalUnitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateOrganizationalUnitRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdatePolicyResponse> updatePolicy(UpdatePolicyRequest updatePolicyRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePolicyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePolicy").withMarshaller((Marshaller)new UpdatePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updatePolicyRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(OrganizationsException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PolicyTypeNotAvailableForOrganizationException").exceptionBuilderSupplier(PolicyTypeNotAvailableForOrganizationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HandshakeNotFoundException").exceptionBuilderSupplier(HandshakeNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateAccountException").exceptionBuilderSupplier(DuplicateAccountException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateHandshakeException").exceptionBuilderSupplier(DuplicateHandshakeException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicatePolicyException").exceptionBuilderSupplier(DuplicatePolicyException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HandshakeAlreadyInStateException").exceptionBuilderSupplier(HandshakeAlreadyInStateException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ChildNotFoundException").exceptionBuilderSupplier(ChildNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccountOwnerNotVerifiedException").exceptionBuilderSupplier(AccountOwnerNotVerifiedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceException").exceptionBuilderSupplier(ServiceException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RootNotFoundException").exceptionBuilderSupplier(RootNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OrganizationNotEmptyException").exceptionBuilderSupplier(OrganizationNotEmptyException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OrganizationalUnitNotFoundException").exceptionBuilderSupplier(OrganizationalUnitNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").exceptionBuilderSupplier(PolicyNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PolicyTypeAlreadyEnabledException").exceptionBuilderSupplier(PolicyTypeAlreadyEnabledException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedForDependencyException").exceptionBuilderSupplier(AccessDeniedForDependencyException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicatePolicyAttachmentException").exceptionBuilderSupplier(DuplicatePolicyAttachmentException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MasterCannotLeaveOrganizationException").exceptionBuilderSupplier(MasterCannotLeaveOrganizationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DestinationParentNotFoundException").exceptionBuilderSupplier(DestinationParentNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PolicyTypeNotEnabledException").exceptionBuilderSupplier(PolicyTypeNotEnabledException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConstraintViolationException").exceptionBuilderSupplier(ConstraintViolationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidInputException").exceptionBuilderSupplier(InvalidInputException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TargetNotFoundException").exceptionBuilderSupplier(TargetNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AWSOrganizationsNotInUseException").exceptionBuilderSupplier(AwsOrganizationsNotInUseException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CreateAccountStatusNotFoundException").exceptionBuilderSupplier(CreateAccountStatusNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PolicyNotAttachedException").exceptionBuilderSupplier(PolicyNotAttachedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AlreadyInOrganizationException").exceptionBuilderSupplier(AlreadyInOrganizationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccountNotFoundException").exceptionBuilderSupplier(AccountNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SourceParentNotFoundException").exceptionBuilderSupplier(SourceParentNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ParentNotFoundException").exceptionBuilderSupplier(ParentNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateOrganizationalUnitException").exceptionBuilderSupplier(DuplicateOrganizationalUnitException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidHandshakeTransitionException").exceptionBuilderSupplier(InvalidHandshakeTransitionException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HandshakeConstraintViolationException").exceptionBuilderSupplier(HandshakeConstraintViolationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRequestsException").exceptionBuilderSupplier(TooManyRequestsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PolicyInUseException").exceptionBuilderSupplier(PolicyInUseException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FinalizingOrganizationException").exceptionBuilderSupplier(FinalizingOrganizationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OrganizationalUnitNotEmptyException").exceptionBuilderSupplier(OrganizationalUnitNotEmptyException::builder).build());
    }

    private <T extends OrganizationsRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.5.24").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((OrganizationsRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}

