/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.organizations.model.EffectivePolicyType;
import software.amazon.awssdk.services.organizations.model.EffectivePolicyValidationError;
import software.amazon.awssdk.services.organizations.model.EffectivePolicyValidationErrorsCopier;
import software.amazon.awssdk.services.organizations.model.OrganizationsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEffectivePolicyValidationErrorsResponse
extends OrganizationsResponse
implements ToCopyableBuilder<Builder, ListEffectivePolicyValidationErrorsResponse> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(ListEffectivePolicyValidationErrorsResponse.getter(ListEffectivePolicyValidationErrorsResponse::accountId)).setter(ListEffectivePolicyValidationErrorsResponse.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyType").getter(ListEffectivePolicyValidationErrorsResponse.getter(ListEffectivePolicyValidationErrorsResponse::policyTypeAsString)).setter(ListEffectivePolicyValidationErrorsResponse.setter(Builder::policyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Path").getter(ListEffectivePolicyValidationErrorsResponse.getter(ListEffectivePolicyValidationErrorsResponse::path)).setter(ListEffectivePolicyValidationErrorsResponse.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()}).build();
    private static final SdkField<Instant> EVALUATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EvaluationTimestamp").getter(ListEffectivePolicyValidationErrorsResponse.getter(ListEffectivePolicyValidationErrorsResponse::evaluationTimestamp)).setter(ListEffectivePolicyValidationErrorsResponse.setter(Builder::evaluationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationTimestamp").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEffectivePolicyValidationErrorsResponse.getter(ListEffectivePolicyValidationErrorsResponse::nextToken)).setter(ListEffectivePolicyValidationErrorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<EffectivePolicyValidationError>> EFFECTIVE_POLICY_VALIDATION_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EffectivePolicyValidationErrors").getter(ListEffectivePolicyValidationErrorsResponse.getter(ListEffectivePolicyValidationErrorsResponse::effectivePolicyValidationErrors)).setter(ListEffectivePolicyValidationErrorsResponse.setter(Builder::effectivePolicyValidationErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectivePolicyValidationErrors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EffectivePolicyValidationError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, POLICY_TYPE_FIELD, PATH_FIELD, EVALUATION_TIMESTAMP_FIELD, NEXT_TOKEN_FIELD, EFFECTIVE_POLICY_VALIDATION_ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEffectivePolicyValidationErrorsResponse.memberNameToFieldInitializer();
    private final String accountId;
    private final String policyType;
    private final String path;
    private final Instant evaluationTimestamp;
    private final String nextToken;
    private final List<EffectivePolicyValidationError> effectivePolicyValidationErrors;

    private ListEffectivePolicyValidationErrorsResponse(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.policyType = builder.policyType;
        this.path = builder.path;
        this.evaluationTimestamp = builder.evaluationTimestamp;
        this.nextToken = builder.nextToken;
        this.effectivePolicyValidationErrors = builder.effectivePolicyValidationErrors;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final EffectivePolicyType policyType() {
        return EffectivePolicyType.fromValue(this.policyType);
    }

    public final String policyTypeAsString() {
        return this.policyType;
    }

    public final String path() {
        return this.path;
    }

    public final Instant evaluationTimestamp() {
        return this.evaluationTimestamp;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasEffectivePolicyValidationErrors() {
        return this.effectivePolicyValidationErrors != null && !(this.effectivePolicyValidationErrors instanceof SdkAutoConstructList);
    }

    public final List<EffectivePolicyValidationError> effectivePolicyValidationErrors() {
        return this.effectivePolicyValidationErrors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEffectivePolicyValidationErrors() ? this.effectivePolicyValidationErrors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEffectivePolicyValidationErrorsResponse)) {
            return false;
        }
        ListEffectivePolicyValidationErrorsResponse other = (ListEffectivePolicyValidationErrorsResponse)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.policyTypeAsString(), other.policyTypeAsString()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.evaluationTimestamp(), other.evaluationTimestamp()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasEffectivePolicyValidationErrors() == other.hasEffectivePolicyValidationErrors() && Objects.equals(this.effectivePolicyValidationErrors(), other.effectivePolicyValidationErrors());
    }

    public final String toString() {
        return ToString.builder((String)"ListEffectivePolicyValidationErrorsResponse").add("AccountId", (Object)this.accountId()).add("PolicyType", (Object)this.policyTypeAsString()).add("Path", (Object)this.path()).add("EvaluationTimestamp", (Object)this.evaluationTimestamp()).add("NextToken", (Object)this.nextToken()).add("EffectivePolicyValidationErrors", this.hasEffectivePolicyValidationErrors() ? this.effectivePolicyValidationErrors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "PolicyType": {
                return Optional.ofNullable(clazz.cast(this.policyTypeAsString()));
            }
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "EvaluationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.evaluationTimestamp()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "EffectivePolicyValidationErrors": {
                return Optional.ofNullable(clazz.cast(this.effectivePolicyValidationErrors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("PolicyType", POLICY_TYPE_FIELD);
        map.put("Path", PATH_FIELD);
        map.put("EvaluationTimestamp", EVALUATION_TIMESTAMP_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("EffectivePolicyValidationErrors", EFFECTIVE_POLICY_VALIDATION_ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEffectivePolicyValidationErrorsResponse, T> g) {
        return obj -> g.apply((ListEffectivePolicyValidationErrorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OrganizationsResponse.BuilderImpl
    implements Builder {
        private String accountId;
        private String policyType;
        private String path;
        private Instant evaluationTimestamp;
        private String nextToken;
        private List<EffectivePolicyValidationError> effectivePolicyValidationErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEffectivePolicyValidationErrorsResponse model) {
            super(model);
            this.accountId(model.accountId);
            this.policyType(model.policyType);
            this.path(model.path);
            this.evaluationTimestamp(model.evaluationTimestamp);
            this.nextToken(model.nextToken);
            this.effectivePolicyValidationErrors(model.effectivePolicyValidationErrors);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getPolicyType() {
            return this.policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(EffectivePolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final Instant getEvaluationTimestamp() {
            return this.evaluationTimestamp;
        }

        public final void setEvaluationTimestamp(Instant evaluationTimestamp) {
            this.evaluationTimestamp = evaluationTimestamp;
        }

        @Override
        public final Builder evaluationTimestamp(Instant evaluationTimestamp) {
            this.evaluationTimestamp = evaluationTimestamp;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<EffectivePolicyValidationError.Builder> getEffectivePolicyValidationErrors() {
            List<EffectivePolicyValidationError.Builder> result = EffectivePolicyValidationErrorsCopier.copyToBuilder(this.effectivePolicyValidationErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEffectivePolicyValidationErrors(Collection<EffectivePolicyValidationError.BuilderImpl> effectivePolicyValidationErrors) {
            this.effectivePolicyValidationErrors = EffectivePolicyValidationErrorsCopier.copyFromBuilder(effectivePolicyValidationErrors);
        }

        @Override
        public final Builder effectivePolicyValidationErrors(Collection<EffectivePolicyValidationError> effectivePolicyValidationErrors) {
            this.effectivePolicyValidationErrors = EffectivePolicyValidationErrorsCopier.copy(effectivePolicyValidationErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder effectivePolicyValidationErrors(EffectivePolicyValidationError ... effectivePolicyValidationErrors) {
            this.effectivePolicyValidationErrors(Arrays.asList(effectivePolicyValidationErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder effectivePolicyValidationErrors(Consumer<EffectivePolicyValidationError.Builder> ... effectivePolicyValidationErrors) {
            this.effectivePolicyValidationErrors(Stream.of(effectivePolicyValidationErrors).map(c -> (EffectivePolicyValidationError)((EffectivePolicyValidationError.Builder)EffectivePolicyValidationError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListEffectivePolicyValidationErrorsResponse build() {
            return new ListEffectivePolicyValidationErrorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OrganizationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEffectivePolicyValidationErrorsResponse> {
        public Builder accountId(String var1);

        public Builder policyType(String var1);

        public Builder policyType(EffectivePolicyType var1);

        public Builder path(String var1);

        public Builder evaluationTimestamp(Instant var1);

        public Builder nextToken(String var1);

        public Builder effectivePolicyValidationErrors(Collection<EffectivePolicyValidationError> var1);

        public Builder effectivePolicyValidationErrors(EffectivePolicyValidationError ... var1);

        public Builder effectivePolicyValidationErrors(Consumer<EffectivePolicyValidationError.Builder> ... var1);
    }
}

