/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.model.ListHandshakesForOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.ListHandshakesForOrganizationResponse;

public class ListHandshakesForOrganizationIterable
implements SdkIterable<ListHandshakesForOrganizationResponse> {
    private final OrganizationsClient client;
    private final ListHandshakesForOrganizationRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListHandshakesForOrganizationIterable(OrganizationsClient client, ListHandshakesForOrganizationRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListHandshakesForOrganizationResponseFetcher();
    }

    public Iterator<ListHandshakesForOrganizationResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListHandshakesForOrganizationIterable resume(ListHandshakesForOrganizationResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListHandshakesForOrganizationIterable(this.client, (ListHandshakesForOrganizationRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListHandshakesForOrganizationIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListHandshakesForOrganizationResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListHandshakesForOrganizationResponseFetcher
    implements SyncPageFetcher<ListHandshakesForOrganizationResponse> {
        private ListHandshakesForOrganizationResponseFetcher() {
        }

        public boolean hasNextPage(ListHandshakesForOrganizationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListHandshakesForOrganizationResponse nextPage(ListHandshakesForOrganizationResponse previousPage) {
            if (previousPage == null) {
                return ListHandshakesForOrganizationIterable.this.client.listHandshakesForOrganization(ListHandshakesForOrganizationIterable.this.firstRequest);
            }
            return ListHandshakesForOrganizationIterable.this.client.listHandshakesForOrganization((ListHandshakesForOrganizationRequest)((Object)ListHandshakesForOrganizationIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

