/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.organizations.model.EffectivePolicyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EffectivePolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EffectivePolicy> {
    private static final SdkField<String> POLICY_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyContent").getter(EffectivePolicy.getter(EffectivePolicy::policyContent)).setter(EffectivePolicy.setter(Builder::policyContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyContent").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTimestamp").getter(EffectivePolicy.getter(EffectivePolicy::lastUpdatedTimestamp)).setter(EffectivePolicy.setter(Builder::lastUpdatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build()}).build();
    private static final SdkField<String> TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetId").getter(EffectivePolicy.getter(EffectivePolicy::targetId)).setter(EffectivePolicy.setter(Builder::targetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetId").build()}).build();
    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyType").getter(EffectivePolicy.getter(EffectivePolicy::policyTypeAsString)).setter(EffectivePolicy.setter(Builder::policyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_CONTENT_FIELD, LAST_UPDATED_TIMESTAMP_FIELD, TARGET_ID_FIELD, POLICY_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EffectivePolicy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String policyContent;
    private final Instant lastUpdatedTimestamp;
    private final String targetId;
    private final String policyType;

    private EffectivePolicy(BuilderImpl builder) {
        this.policyContent = builder.policyContent;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.targetId = builder.targetId;
        this.policyType = builder.policyType;
    }

    public final String policyContent() {
        return this.policyContent;
    }

    public final Instant lastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public final String targetId() {
        return this.targetId;
    }

    public final EffectivePolicyType policyType() {
        return EffectivePolicyType.fromValue(this.policyType);
    }

    public final String policyTypeAsString() {
        return this.policyType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EffectivePolicy)) {
            return false;
        }
        EffectivePolicy other = (EffectivePolicy)obj;
        return Objects.equals(this.policyContent(), other.policyContent()) && Objects.equals(this.lastUpdatedTimestamp(), other.lastUpdatedTimestamp()) && Objects.equals(this.targetId(), other.targetId()) && Objects.equals(this.policyTypeAsString(), other.policyTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EffectivePolicy").add("PolicyContent", (Object)this.policyContent()).add("LastUpdatedTimestamp", (Object)this.lastUpdatedTimestamp()).add("TargetId", (Object)this.targetId()).add("PolicyType", (Object)this.policyTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyContent": {
                return Optional.ofNullable(clazz.cast(this.policyContent()));
            }
            case "LastUpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTimestamp()));
            }
            case "TargetId": {
                return Optional.ofNullable(clazz.cast(this.targetId()));
            }
            case "PolicyType": {
                return Optional.ofNullable(clazz.cast(this.policyTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PolicyContent", POLICY_CONTENT_FIELD);
        map.put("LastUpdatedTimestamp", LAST_UPDATED_TIMESTAMP_FIELD);
        map.put("TargetId", TARGET_ID_FIELD);
        map.put("PolicyType", POLICY_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EffectivePolicy, T> g) {
        return obj -> g.apply((EffectivePolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyContent;
        private Instant lastUpdatedTimestamp;
        private String targetId;
        private String policyType;

        private BuilderImpl() {
        }

        private BuilderImpl(EffectivePolicy model) {
            this.policyContent(model.policyContent);
            this.lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            this.targetId(model.targetId);
            this.policyType(model.policyType);
        }

        public final String getPolicyContent() {
            return this.policyContent;
        }

        public final void setPolicyContent(String policyContent) {
            this.policyContent = policyContent;
        }

        @Override
        public final Builder policyContent(String policyContent) {
            this.policyContent = policyContent;
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return this.lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final String getTargetId() {
            return this.targetId;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final String getPolicyType() {
            return this.policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(EffectivePolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public EffectivePolicy build() {
            return new EffectivePolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EffectivePolicy> {
        public Builder policyContent(String var1);

        public Builder lastUpdatedTimestamp(Instant var1);

        public Builder targetId(String var1);

        public Builder policyType(String var1);

        public Builder policyType(EffectivePolicyType var1);
    }
}

