/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.endpoints.internal;

import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.organizations.endpoints.OrganizationsEndpointParams;
import software.amazon.awssdk.services.organizations.endpoints.OrganizationsEndpointProvider;
import software.amazon.awssdk.services.organizations.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.organizations.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.organizations.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultOrganizationsEndpointProvider
implements OrganizationsEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(OrganizationsEndpointParams params) {
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            RuleResult result = DefaultOrganizationsEndpointProvider.endpointRule0(params, new LocalState(params.region()));
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(OrganizationsEndpointParams params, LocalState locals) {
        RuleResult result = DefaultOrganizationsEndpointProvider.endpointRule1(params, locals);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultOrganizationsEndpointProvider.endpointRule5(params, locals);
        if (result.isResolved()) {
            return result;
        }
        return DefaultOrganizationsEndpointProvider.endpointRule26(params, locals);
    }

    private static RuleResult endpointRule1(OrganizationsEndpointParams params, LocalState locals) {
        if (params.endpoint() != null) {
            RuleResult result = DefaultOrganizationsEndpointProvider.endpointRule2(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultOrganizationsEndpointProvider.endpointRule3(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultOrganizationsEndpointProvider.endpointRule4(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule2(OrganizationsEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(OrganizationsEndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule4(OrganizationsEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
    }

    private static RuleResult endpointRule5(OrganizationsEndpointParams params, LocalState locals) {
        if (locals.region() != null) {
            return DefaultOrganizationsEndpointProvider.endpointRule6(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule6(OrganizationsEndpointParams params, LocalState locals) {
        RulePartition partitionResult = null;
        partitionResult = RulesFunctions.awsPartition(locals.region());
        if (partitionResult != null) {
            RuleResult result = DefaultOrganizationsEndpointProvider.endpointRule7(params, locals = locals.toBuilder().partitionResult(partitionResult).build());
            if (result.isResolved()) {
                return result;
            }
            result = DefaultOrganizationsEndpointProvider.endpointRule8(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultOrganizationsEndpointProvider.endpointRule9(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultOrganizationsEndpointProvider.endpointRule10(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultOrganizationsEndpointProvider.endpointRule11(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultOrganizationsEndpointProvider.endpointRule12(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultOrganizationsEndpointProvider.endpointRule13(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultOrganizationsEndpointProvider.endpointRule17(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultOrganizationsEndpointProvider.endpointRule21(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultOrganizationsEndpointProvider.endpointRule25(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule7(OrganizationsEndpointParams params, LocalState locals) {
        if ("aws".equals(locals.partitionResult().name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://organizations.us-east-1.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("organizations").signingRegion("us-east-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule8(OrganizationsEndpointParams params, LocalState locals) {
        if ("aws".equals(locals.partitionResult().name()) && params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://organizations-fips.us-east-1.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("organizations").signingRegion("us-east-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule9(OrganizationsEndpointParams params, LocalState locals) {
        if ("aws-cn".equals(locals.partitionResult().name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://organizations.cn-northwest-1.amazonaws.com.cn")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("organizations").signingRegion("cn-northwest-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule10(OrganizationsEndpointParams params, LocalState locals) {
        if ("aws-us-gov".equals(locals.partitionResult().name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://organizations.us-gov-west-1.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("organizations").signingRegion("us-gov-west-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule11(OrganizationsEndpointParams params, LocalState locals) {
        if ("aws-us-gov".equals(locals.partitionResult().name()) && params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://organizations.us-gov-west-1.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("organizations").signingRegion("us-gov-west-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule12(OrganizationsEndpointParams params, LocalState locals) {
        if ("aws-iso".equals(locals.partitionResult().name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://organizations.us-iso-east-1.c2s.ic.gov")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("organizations").signingRegion("us-iso-east-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule13(OrganizationsEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultOrganizationsEndpointProvider.endpointRule14(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultOrganizationsEndpointProvider.endpointRule16(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule14(OrganizationsEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS() && locals.partitionResult().supportsDualStack()) {
            return DefaultOrganizationsEndpointProvider.endpointRule15(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule15(OrganizationsEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://organizations-fips." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule16(OrganizationsEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static RuleResult endpointRule17(OrganizationsEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultOrganizationsEndpointProvider.endpointRule18(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultOrganizationsEndpointProvider.endpointRule20(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule18(OrganizationsEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS()) {
            return DefaultOrganizationsEndpointProvider.endpointRule19(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule19(OrganizationsEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://organizations-fips." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
    }

    private static RuleResult endpointRule20(OrganizationsEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
    }

    private static RuleResult endpointRule21(OrganizationsEndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultOrganizationsEndpointProvider.endpointRule22(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultOrganizationsEndpointProvider.endpointRule24(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule22(OrganizationsEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsDualStack()) {
            return DefaultOrganizationsEndpointProvider.endpointRule23(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule23(OrganizationsEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://organizations." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule24(OrganizationsEndpointParams params, LocalState locals) {
        return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
    }

    private static RuleResult endpointRule25(OrganizationsEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://organizations." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
    }

    private static RuleResult endpointRule26(OrganizationsEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private static final class LocalStateBuilder {
        private String region;
        private RulePartition partitionResult;

        LocalStateBuilder() {
            this.region = null;
            this.partitionResult = null;
        }

        LocalStateBuilder(LocalState locals) {
            this.region = locals.region;
            this.partitionResult = locals.partitionResult;
        }

        public LocalStateBuilder region(String value) {
            this.region = value;
            return this;
        }

        public LocalStateBuilder partitionResult(RulePartition value) {
            this.partitionResult = value;
            return this;
        }

        LocalState build() {
            return new LocalState(this);
        }
    }

    private static final class LocalState {
        private final String region;
        private final RulePartition partitionResult;

        LocalState() {
            this.region = null;
            this.partitionResult = null;
        }

        LocalState(Region region) {
            this.region = region != null ? region.id() : null;
            this.partitionResult = null;
        }

        LocalState(LocalStateBuilder builder) {
            this.region = builder.region;
            this.partitionResult = builder.partitionResult;
        }

        public String region() {
            return this.region;
        }

        public RulePartition partitionResult() {
            return this.partitionResult;
        }

        public LocalStateBuilder toBuilder() {
            return new LocalStateBuilder(this);
        }
    }
}

