/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.endpoints.internal;

import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.services.organizations.endpoints.OrganizationsEndpointParams;
import software.amazon.awssdk.services.organizations.endpoints.OrganizationsEndpointProvider;
import software.amazon.awssdk.services.organizations.endpoints.internal.Condition;
import software.amazon.awssdk.services.organizations.endpoints.internal.DefaultEndpointAuthSchemeStrategyFactory;
import software.amazon.awssdk.services.organizations.endpoints.internal.DefaultRuleEngine;
import software.amazon.awssdk.services.organizations.endpoints.internal.EndpointAuthSchemeStrategy;
import software.amazon.awssdk.services.organizations.endpoints.internal.EndpointResult;
import software.amazon.awssdk.services.organizations.endpoints.internal.EndpointRuleset;
import software.amazon.awssdk.services.organizations.endpoints.internal.Expr;
import software.amazon.awssdk.services.organizations.endpoints.internal.FnNode;
import software.amazon.awssdk.services.organizations.endpoints.internal.Identifier;
import software.amazon.awssdk.services.organizations.endpoints.internal.Literal;
import software.amazon.awssdk.services.organizations.endpoints.internal.Parameter;
import software.amazon.awssdk.services.organizations.endpoints.internal.ParameterType;
import software.amazon.awssdk.services.organizations.endpoints.internal.Parameters;
import software.amazon.awssdk.services.organizations.endpoints.internal.Rule;
import software.amazon.awssdk.services.organizations.endpoints.internal.Value;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.MapUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultOrganizationsEndpointProvider
implements OrganizationsEndpointProvider {
    private static final Logger LOG = Logger.loggerFor(DefaultOrganizationsEndpointProvider.class);
    private static final EndpointRuleset ENDPOINT_RULE_SET = DefaultOrganizationsEndpointProvider.ruleSet();
    private final EndpointAuthSchemeStrategy endpointAuthSchemeStrategy;

    public DefaultOrganizationsEndpointProvider() {
        DefaultEndpointAuthSchemeStrategyFactory endpointAuthSchemeStrategyFactory = new DefaultEndpointAuthSchemeStrategyFactory();
        this.endpointAuthSchemeStrategy = endpointAuthSchemeStrategyFactory.endpointAuthSchemeStrategy();
    }

    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(OrganizationsEndpointParams endpointParams) {
        Validate.notNull((Object)endpointParams.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)endpointParams.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        Value res = new DefaultRuleEngine().evaluate(ENDPOINT_RULE_SET, DefaultOrganizationsEndpointProvider.toIdentifierValueMap(endpointParams));
        try {
            return CompletableFuture.completedFuture(this.valueAsEndpointOrThrow(res));
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static Map<Identifier, Value> toIdentifierValueMap(OrganizationsEndpointParams params) {
        HashMap<Identifier, Value> paramsMap = new HashMap<Identifier, Value>();
        if (params.region() != null) {
            paramsMap.put(Identifier.of("Region"), Value.fromStr(params.region().id()));
        }
        if (params.useDualStack() != null) {
            paramsMap.put(Identifier.of("UseDualStack"), Value.fromBool(params.useDualStack()));
        }
        if (params.useFips() != null) {
            paramsMap.put(Identifier.of("UseFIPS"), Value.fromBool(params.useFips()));
        }
        if (params.endpoint() != null) {
            paramsMap.put(Identifier.of("Endpoint"), Value.fromStr(params.endpoint()));
        }
        return paramsMap;
    }

    Endpoint valueAsEndpointOrThrow(Value value) {
        if (value instanceof Value.Endpoint) {
            Value.Endpoint endpoint = value.expectEndpoint();
            Endpoint.Builder builder = Endpoint.builder();
            builder.url(URI.create(endpoint.getUrl()));
            Map<String, List<String>> headers = endpoint.getHeaders();
            if (headers != null) {
                headers.forEach((name, values) -> values.forEach(v -> builder.putHeader(name, v)));
            }
            this.addKnownProperties(builder, endpoint.getProperties());
            return builder.build();
        }
        if (value instanceof Value.Str) {
            String errorMsg = value.expectString();
            if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
            }
            throw SdkClientException.create((String)errorMsg);
        }
        throw SdkClientException.create((String)("Rule engine return neither an endpoint result or error value. Returned value was: " + value));
    }

    private static Rule endpointRule_1() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).error("Invalid Configuration: FIPS and custom endpoint are not supported");
    }

    private static Rule endpointRule_2() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).error("Invalid Configuration: Dualstack and custom endpoint are not supported");
    }

    private static Rule endpointRule_3() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.ref(Identifier.of("Endpoint"))).build());
    }

    private static Rule endpointRule_0() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).treeRule(Arrays.asList(DefaultOrganizationsEndpointProvider.endpointRule_1(), DefaultOrganizationsEndpointProvider.endpointRule_2(), DefaultOrganizationsEndpointProvider.endpointRule_3()));
    }

    private static Rule endpointRule_6() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("name"))).build().validate(), Expr.of("aws"))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://organizations.us-east-1.amazonaws.com")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("organizations"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1")))))).build());
    }

    private static Rule endpointRule_7() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("name"))).build().validate(), Expr.of("aws"))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://organizations-fips.us-east-1.amazonaws.com")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("organizations"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1")))))).build());
    }

    private static Rule endpointRule_8() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("name"))).build().validate(), Expr.of("aws-cn"))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://organizations.cn-northwest-1.amazonaws.com.cn")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("organizations"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("cn-northwest-1")))))).build());
    }

    private static Rule endpointRule_9() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("name"))).build().validate(), Expr.of("aws-us-gov"))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://organizations.us-gov-west-1.amazonaws.com")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("organizations"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-gov-west-1")))))).build());
    }

    private static Rule endpointRule_10() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("name"))).build().validate(), Expr.of("aws-us-gov"))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://organizations.us-gov-west-1.amazonaws.com")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("organizations"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-gov-west-1")))))).build());
    }

    private static Rule endpointRule_13() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://organizations-fips.{Region}.{PartitionResult#dualStackDnsSuffix}")).build());
    }

    private static Rule endpointRule_12() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultOrganizationsEndpointProvider.endpointRule_13()));
    }

    private static Rule endpointRule_14() {
        return Rule.builder().error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static Rule endpointRule_11() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultOrganizationsEndpointProvider.endpointRule_12(), DefaultOrganizationsEndpointProvider.endpointRule_14()));
    }

    private static Rule endpointRule_17() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://organizations-fips.{Region}.{PartitionResult#dnsSuffix}")).build());
    }

    private static Rule endpointRule_16() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultOrganizationsEndpointProvider.endpointRule_17()));
    }

    private static Rule endpointRule_18() {
        return Rule.builder().error("FIPS is enabled but this partition does not support FIPS");
    }

    private static Rule endpointRule_15() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultOrganizationsEndpointProvider.endpointRule_16(), DefaultOrganizationsEndpointProvider.endpointRule_18()));
    }

    private static Rule endpointRule_21() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://organizations.{Region}.{PartitionResult#dualStackDnsSuffix}")).build());
    }

    private static Rule endpointRule_20() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultOrganizationsEndpointProvider.endpointRule_21()));
    }

    private static Rule endpointRule_22() {
        return Rule.builder().error("DualStack is enabled but this partition does not support DualStack");
    }

    private static Rule endpointRule_19() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultOrganizationsEndpointProvider.endpointRule_20(), DefaultOrganizationsEndpointProvider.endpointRule_22()));
    }

    private static Rule endpointRule_23() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://organizations.{Region}.{PartitionResult#dnsSuffix}")).build());
    }

    private static Rule endpointRule_5() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).result("PartitionResult").build()).treeRule(Arrays.asList(DefaultOrganizationsEndpointProvider.endpointRule_6(), DefaultOrganizationsEndpointProvider.endpointRule_7(), DefaultOrganizationsEndpointProvider.endpointRule_8(), DefaultOrganizationsEndpointProvider.endpointRule_9(), DefaultOrganizationsEndpointProvider.endpointRule_10(), DefaultOrganizationsEndpointProvider.endpointRule_11(), DefaultOrganizationsEndpointProvider.endpointRule_15(), DefaultOrganizationsEndpointProvider.endpointRule_19(), DefaultOrganizationsEndpointProvider.endpointRule_23()));
    }

    private static Rule endpointRule_4() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).build()).treeRule(Arrays.asList(DefaultOrganizationsEndpointProvider.endpointRule_5()));
    }

    private static Rule endpointRule_24() {
        return Rule.builder().error("Invalid Configuration: Missing Region");
    }

    private static EndpointRuleset ruleSet() {
        return EndpointRuleset.builder().version("1.0").serviceId(null).parameters(Parameters.builder().addParameter(Parameter.builder().name("Region").type(ParameterType.fromValue("String")).required(false).builtIn("AWS::Region").documentation("The AWS region used to dispatch the request.").build()).addParameter(Parameter.builder().name("UseDualStack").type(ParameterType.fromValue("Boolean")).required(true).builtIn("AWS::UseDualStack").documentation("When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.").defaultValue(Value.fromBool(false)).build()).addParameter(Parameter.builder().name("UseFIPS").type(ParameterType.fromValue("Boolean")).required(true).builtIn("AWS::UseFIPS").documentation("When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.").defaultValue(Value.fromBool(false)).build()).addParameter(Parameter.builder().name("Endpoint").type(ParameterType.fromValue("String")).required(false).builtIn("SDK::Endpoint").documentation("Override the endpoint used to send this request").build()).build()).addRule(DefaultOrganizationsEndpointProvider.endpointRule_0()).addRule(DefaultOrganizationsEndpointProvider.endpointRule_4()).addRule(DefaultOrganizationsEndpointProvider.endpointRule_24()).build();
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private void addKnownProperties(Endpoint.Builder builder, Map<String, Value> properties) {
        properties.forEach((n, v) -> {
            switch (n) {
                case "authSchemes": {
                    builder.putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, this.endpointAuthSchemeStrategy.createAuthSchemes((Value)v));
                    break;
                }
                default: {
                    LOG.debug(() -> "Ignoring unknown endpoint property: " + n);
                }
            }
        });
    }
}

