/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum PolicyType {
    SERVICE_CONTROL_POLICY("SERVICE_CONTROL_POLICY"),
    TAG_POLICY("TAG_POLICY"),
    BACKUP_POLICY("BACKUP_POLICY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private PolicyType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PolicyType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(PolicyType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PolicyType> knownValues() {
        return Stream.of(PolicyType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

