/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.organizations.model.IAMUserAccessToBilling;
import software.amazon.awssdk.services.organizations.model.OrganizationsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGovCloudAccountRequest
extends OrganizationsRequest
implements ToCopyableBuilder<Builder, CreateGovCloudAccountRequest> {
    private static final SdkField<String> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateGovCloudAccountRequest.getter(CreateGovCloudAccountRequest::email)).setter(CreateGovCloudAccountRequest.setter(Builder::email)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()}).build();
    private static final SdkField<String> ACCOUNT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateGovCloudAccountRequest.getter(CreateGovCloudAccountRequest::accountName)).setter(CreateGovCloudAccountRequest.setter(Builder::accountName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountName").build()}).build();
    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateGovCloudAccountRequest.getter(CreateGovCloudAccountRequest::roleName)).setter(CreateGovCloudAccountRequest.setter(Builder::roleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleName").build()}).build();
    private static final SdkField<String> IAM_USER_ACCESS_TO_BILLING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateGovCloudAccountRequest.getter(CreateGovCloudAccountRequest::iamUserAccessToBillingAsString)).setter(CreateGovCloudAccountRequest.setter(Builder::iamUserAccessToBilling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamUserAccessToBilling").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_FIELD, ACCOUNT_NAME_FIELD, ROLE_NAME_FIELD, IAM_USER_ACCESS_TO_BILLING_FIELD));
    private final String email;
    private final String accountName;
    private final String roleName;
    private final String iamUserAccessToBilling;

    private CreateGovCloudAccountRequest(BuilderImpl builder) {
        super(builder);
        this.email = builder.email;
        this.accountName = builder.accountName;
        this.roleName = builder.roleName;
        this.iamUserAccessToBilling = builder.iamUserAccessToBilling;
    }

    public String email() {
        return this.email;
    }

    public String accountName() {
        return this.accountName;
    }

    public String roleName() {
        return this.roleName;
    }

    public IAMUserAccessToBilling iamUserAccessToBilling() {
        return IAMUserAccessToBilling.fromValue(this.iamUserAccessToBilling);
    }

    public String iamUserAccessToBillingAsString() {
        return this.iamUserAccessToBilling;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamUserAccessToBillingAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGovCloudAccountRequest)) {
            return false;
        }
        CreateGovCloudAccountRequest other = (CreateGovCloudAccountRequest)((Object)obj);
        return Objects.equals(this.email(), other.email()) && Objects.equals(this.accountName(), other.accountName()) && Objects.equals(this.roleName(), other.roleName()) && Objects.equals(this.iamUserAccessToBillingAsString(), other.iamUserAccessToBillingAsString());
    }

    public String toString() {
        return ToString.builder((String)"CreateGovCloudAccountRequest").add("Email", (Object)(this.email() == null ? null : "*** Sensitive Data Redacted ***")).add("AccountName", (Object)(this.accountName() == null ? null : "*** Sensitive Data Redacted ***")).add("RoleName", (Object)this.roleName()).add("IamUserAccessToBilling", (Object)this.iamUserAccessToBillingAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
            case "AccountName": {
                return Optional.ofNullable(clazz.cast(this.accountName()));
            }
            case "RoleName": {
                return Optional.ofNullable(clazz.cast(this.roleName()));
            }
            case "IamUserAccessToBilling": {
                return Optional.ofNullable(clazz.cast(this.iamUserAccessToBillingAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGovCloudAccountRequest, T> g) {
        return obj -> g.apply((CreateGovCloudAccountRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OrganizationsRequest.BuilderImpl
    implements Builder {
        private String email;
        private String accountName;
        private String roleName;
        private String iamUserAccessToBilling;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGovCloudAccountRequest model) {
            super(model);
            this.email(model.email);
            this.accountName(model.accountName);
            this.roleName(model.roleName);
            this.iamUserAccessToBilling(model.iamUserAccessToBilling);
        }

        public final String getEmail() {
            return this.email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        public final String getAccountName() {
            return this.accountName;
        }

        @Override
        public final Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public final void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        public final String getRoleName() {
            return this.roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public final String getIamUserAccessToBilling() {
            return this.iamUserAccessToBilling;
        }

        @Override
        public final Builder iamUserAccessToBilling(String iamUserAccessToBilling) {
            this.iamUserAccessToBilling = iamUserAccessToBilling;
            return this;
        }

        @Override
        public final Builder iamUserAccessToBilling(IAMUserAccessToBilling iamUserAccessToBilling) {
            this.iamUserAccessToBilling(iamUserAccessToBilling == null ? null : iamUserAccessToBilling.toString());
            return this;
        }

        public final void setIamUserAccessToBilling(String iamUserAccessToBilling) {
            this.iamUserAccessToBilling = iamUserAccessToBilling;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGovCloudAccountRequest build() {
            return new CreateGovCloudAccountRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OrganizationsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGovCloudAccountRequest> {
        public Builder email(String var1);

        public Builder accountName(String var1);

        public Builder roleName(String var1);

        public Builder iamUserAccessToBilling(String var1);

        public Builder iamUserAccessToBilling(IAMUserAccessToBilling var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

