/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.organizations.model.Handshake;

@SdkInternalApi
public class HandshakeMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").build();
    private static final MarshallingInfo<List> PARTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parties").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<Instant> REQUESTEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequestedTimestamp").build();
    private static final MarshallingInfo<Instant> EXPIRATIONTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpirationTimestamp").build();
    private static final MarshallingInfo<String> ACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Action").build();
    private static final MarshallingInfo<List> RESOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Resources").build();
    private static final HandshakeMarshaller INSTANCE = new HandshakeMarshaller();

    public static HandshakeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Handshake handshake, ProtocolMarshaller protocolMarshaller) {
        if (handshake == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)handshake.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)handshake.arn(), ARN_BINDING);
            protocolMarshaller.marshall(handshake.parties(), PARTIES_BINDING);
            protocolMarshaller.marshall((Object)handshake.stateString(), STATE_BINDING);
            protocolMarshaller.marshall((Object)handshake.requestedTimestamp(), REQUESTEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)handshake.expirationTimestamp(), EXPIRATIONTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)handshake.actionString(), ACTION_BINDING);
            protocolMarshaller.marshall(handshake.resources(), RESOURCES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

