/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.model.ListParentsRequest;
import software.amazon.awssdk.services.organizations.model.ListParentsResponse;

public final class ListParentsPaginator
implements SdkIterable<ListParentsResponse> {
    private final OrganizationsClient client;
    private final ListParentsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListParentsPaginator(OrganizationsClient client, ListParentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListParentsResponseFetcher();
    }

    public Iterator<ListParentsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListParentsResponseFetcher
    implements NextPageFetcher<ListParentsResponse> {
        private ListParentsResponseFetcher() {
        }

        public boolean hasNextPage(ListParentsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListParentsResponse nextPage(ListParentsResponse previousPage) {
            if (previousPage == null) {
                return ListParentsPaginator.this.client.listParents(ListParentsPaginator.this.firstRequest);
            }
            return ListParentsPaginator.this.client.listParents((ListParentsRequest)((Object)ListParentsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

