/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusRequest;
import software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusResponse;

public final class ListCreateAccountStatusPaginator
implements SdkIterable<ListCreateAccountStatusResponse> {
    private final OrganizationsClient client;
    private final ListCreateAccountStatusRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListCreateAccountStatusPaginator(OrganizationsClient client, ListCreateAccountStatusRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCreateAccountStatusResponseFetcher();
    }

    public Iterator<ListCreateAccountStatusResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListCreateAccountStatusResponseFetcher
    implements NextPageFetcher<ListCreateAccountStatusResponse> {
        private ListCreateAccountStatusResponseFetcher() {
        }

        public boolean hasNextPage(ListCreateAccountStatusResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListCreateAccountStatusResponse nextPage(ListCreateAccountStatusResponse previousPage) {
            if (previousPage == null) {
                return ListCreateAccountStatusPaginator.this.client.listCreateAccountStatus(ListCreateAccountStatusPaginator.this.firstRequest);
            }
            return ListCreateAccountStatusPaginator.this.client.listCreateAccountStatus((ListCreateAccountStatusRequest)((Object)ListCreateAccountStatusPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

