/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.model.ListChildrenRequest;
import software.amazon.awssdk.services.organizations.model.ListChildrenResponse;

public final class ListChildrenPaginator
implements SdkIterable<ListChildrenResponse> {
    private final OrganizationsClient client;
    private final ListChildrenRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListChildrenPaginator(OrganizationsClient client, ListChildrenRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListChildrenResponseFetcher();
    }

    public Iterator<ListChildrenResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListChildrenResponseFetcher
    implements NextPageFetcher<ListChildrenResponse> {
        private ListChildrenResponseFetcher() {
        }

        public boolean hasNextPage(ListChildrenResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListChildrenResponse nextPage(ListChildrenResponse previousPage) {
            if (previousPage == null) {
                return ListChildrenPaginator.this.client.listChildren(ListChildrenPaginator.this.firstRequest);
            }
            return ListChildrenPaginator.this.client.listChildren((ListChildrenRequest)((Object)ListChildrenPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

