/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.organizations.model.OrganizationalUnit;
import software.amazon.awssdk.services.organizations.model.OrganizationalUnitsCopier;
import software.amazon.awssdk.services.organizations.model.OrganizationsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListOrganizationalUnitsForParentResponse
extends OrganizationsResponse
implements ToCopyableBuilder<Builder, ListOrganizationalUnitsForParentResponse> {
    private final List<OrganizationalUnit> organizationalUnits;
    private final String nextToken;

    private ListOrganizationalUnitsForParentResponse(BuilderImpl builder) {
        super(builder);
        this.organizationalUnits = builder.organizationalUnits;
        this.nextToken = builder.nextToken;
    }

    public List<OrganizationalUnit> organizationalUnits() {
        return this.organizationalUnits;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationalUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOrganizationalUnitsForParentResponse)) {
            return false;
        }
        ListOrganizationalUnitsForParentResponse other = (ListOrganizationalUnitsForParentResponse)((Object)obj);
        return Objects.equals(this.organizationalUnits(), other.organizationalUnits()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListOrganizationalUnitsForParentResponse").add("OrganizationalUnits", this.organizationalUnits()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationalUnits": {
                return Optional.of(clazz.cast(this.organizationalUnits()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OrganizationsResponse.BuilderImpl
    implements Builder {
        private List<OrganizationalUnit> organizationalUnits;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOrganizationalUnitsForParentResponse model) {
            this.organizationalUnits(model.organizationalUnits);
            this.nextToken(model.nextToken);
        }

        public final Collection<OrganizationalUnit.Builder> getOrganizationalUnits() {
            return this.organizationalUnits != null ? (Collection)this.organizationalUnits.stream().map(OrganizationalUnit::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder organizationalUnits(Collection<OrganizationalUnit> organizationalUnits) {
            this.organizationalUnits = OrganizationalUnitsCopier.copy(organizationalUnits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnits(OrganizationalUnit ... organizationalUnits) {
            this.organizationalUnits(Arrays.asList(organizationalUnits));
            return this;
        }

        public final void setOrganizationalUnits(Collection<OrganizationalUnit.BuilderImpl> organizationalUnits) {
            this.organizationalUnits = OrganizationalUnitsCopier.copyFromBuilder(organizationalUnits);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListOrganizationalUnitsForParentResponse build() {
            return new ListOrganizationalUnitsForParentResponse(this);
        }
    }

    public static interface Builder
    extends OrganizationsResponse.Builder,
    CopyableBuilder<Builder, ListOrganizationalUnitsForParentResponse> {
        public Builder organizationalUnits(Collection<OrganizationalUnit> var1);

        public Builder organizationalUnits(OrganizationalUnit ... var1);

        public Builder nextToken(String var1);
    }
}

