/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.organizations.model.AccountJoinedMethod;
import software.amazon.awssdk.services.organizations.model.AccountStatus;
import software.amazon.awssdk.services.organizations.transform.AccountMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Account
implements StructuredPojo,
ToCopyableBuilder<Builder, Account> {
    private final String id;
    private final String arn;
    private final String email;
    private final String name;
    private final String status;
    private final String joinedMethod;
    private final Instant joinedTimestamp;

    private Account(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.email = builder.email;
        this.name = builder.name;
        this.status = builder.status;
        this.joinedMethod = builder.joinedMethod;
        this.joinedTimestamp = builder.joinedTimestamp;
    }

    public String id() {
        return this.id;
    }

    public String arn() {
        return this.arn;
    }

    public String email() {
        return this.email;
    }

    public String name() {
        return this.name;
    }

    public AccountStatus status() {
        return AccountStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public AccountJoinedMethod joinedMethod() {
        return AccountJoinedMethod.fromValue(this.joinedMethod);
    }

    public String joinedMethodString() {
        return this.joinedMethod;
    }

    public Instant joinedTimestamp() {
        return this.joinedTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.joinedMethodString());
        hashCode = 31 * hashCode + Objects.hashCode(this.joinedTimestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Account)) {
            return false;
        }
        Account other = (Account)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.email(), other.email()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.joinedMethodString(), other.joinedMethodString()) && Objects.equals(this.joinedTimestamp(), other.joinedTimestamp());
    }

    public String toString() {
        return ToString.builder((String)"Account").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Email", (Object)this.email()).add("Name", (Object)this.name()).add("Status", (Object)this.statusString()).add("JoinedMethod", (Object)this.joinedMethodString()).add("JoinedTimestamp", (Object)this.joinedTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "Email": {
                return Optional.of(clazz.cast(this.email()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "JoinedMethod": {
                return Optional.of(clazz.cast(this.joinedMethodString()));
            }
            case "JoinedTimestamp": {
                return Optional.of(clazz.cast(this.joinedTimestamp()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AccountMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String email;
        private String name;
        private String status;
        private String joinedMethod;
        private Instant joinedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(Account model) {
            this.id(model.id);
            this.arn(model.arn);
            this.email(model.email);
            this.name(model.name);
            this.status(model.status);
            this.joinedMethod(model.joinedMethod);
            this.joinedTimestamp(model.joinedTimestamp);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getEmail() {
            return this.email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AccountStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getJoinedMethod() {
            return this.joinedMethod;
        }

        @Override
        public final Builder joinedMethod(String joinedMethod) {
            this.joinedMethod = joinedMethod;
            return this;
        }

        @Override
        public final Builder joinedMethod(AccountJoinedMethod joinedMethod) {
            this.joinedMethod(joinedMethod.toString());
            return this;
        }

        public final void setJoinedMethod(String joinedMethod) {
            this.joinedMethod = joinedMethod;
        }

        public final Instant getJoinedTimestamp() {
            return this.joinedTimestamp;
        }

        @Override
        public final Builder joinedTimestamp(Instant joinedTimestamp) {
            this.joinedTimestamp = joinedTimestamp;
            return this;
        }

        public final void setJoinedTimestamp(Instant joinedTimestamp) {
            this.joinedTimestamp = joinedTimestamp;
        }

        public Account build() {
            return new Account(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Account> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder email(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(AccountStatus var1);

        public Builder joinedMethod(String var1);

        public Builder joinedMethod(AccountJoinedMethod var1);

        public Builder joinedTimestamp(Instant var1);
    }
}

