/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.model.ListHandshakesForOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.ListHandshakesForOrganizationResponse;

public final class ListHandshakesForOrganizationPaginator
implements SdkIterable<ListHandshakesForOrganizationResponse> {
    private final OrganizationsClient client;
    private final ListHandshakesForOrganizationRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListHandshakesForOrganizationPaginator(OrganizationsClient client, ListHandshakesForOrganizationRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListHandshakesForOrganizationResponseFetcher();
    }

    public Iterator<ListHandshakesForOrganizationResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListHandshakesForOrganizationResponseFetcher
    implements NextPageFetcher<ListHandshakesForOrganizationResponse> {
        private ListHandshakesForOrganizationResponseFetcher() {
        }

        public boolean hasNextPage(ListHandshakesForOrganizationResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListHandshakesForOrganizationResponse nextPage(ListHandshakesForOrganizationResponse previousPage) {
            if (previousPage == null) {
                return ListHandshakesForOrganizationPaginator.this.client.listHandshakesForOrganization(ListHandshakesForOrganizationPaginator.this.firstRequest);
            }
            return ListHandshakesForOrganizationPaginator.this.client.listHandshakesForOrganization((ListHandshakesForOrganizationRequest)((Object)ListHandshakesForOrganizationPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

