/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyRequest;
import software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyResponse;

public final class ListTargetsForPolicyPaginator
implements SdkIterable<ListTargetsForPolicyResponse> {
    private final OrganizationsClient client;
    private final ListTargetsForPolicyRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListTargetsForPolicyPaginator(OrganizationsClient client, ListTargetsForPolicyRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTargetsForPolicyResponseFetcher();
    }

    public Iterator<ListTargetsForPolicyResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListTargetsForPolicyResponseFetcher
    implements NextPageFetcher<ListTargetsForPolicyResponse> {
        private ListTargetsForPolicyResponseFetcher() {
        }

        public boolean hasNextPage(ListTargetsForPolicyResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListTargetsForPolicyResponse nextPage(ListTargetsForPolicyResponse previousPage) {
            if (previousPage == null) {
                return ListTargetsForPolicyPaginator.this.client.listTargetsForPolicy(ListTargetsForPolicyPaginator.this.firstRequest);
            }
            return ListTargetsForPolicyPaginator.this.client.listTargetsForPolicy((ListTargetsForPolicyRequest)((Object)ListTargetsForPolicyPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

