/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetRequest;
import software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetResponse;

public final class ListPoliciesForTargetPaginator
implements SdkIterable<ListPoliciesForTargetResponse> {
    private final OrganizationsClient client;
    private final ListPoliciesForTargetRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListPoliciesForTargetPaginator(OrganizationsClient client, ListPoliciesForTargetRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPoliciesForTargetResponseFetcher();
    }

    public Iterator<ListPoliciesForTargetResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListPoliciesForTargetResponseFetcher
    implements NextPageFetcher<ListPoliciesForTargetResponse> {
        private ListPoliciesForTargetResponseFetcher() {
        }

        public boolean hasNextPage(ListPoliciesForTargetResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListPoliciesForTargetResponse nextPage(ListPoliciesForTargetResponse previousPage) {
            if (previousPage == null) {
                return ListPoliciesForTargetPaginator.this.client.listPoliciesForTarget(ListPoliciesForTargetPaginator.this.firstRequest);
            }
            return ListPoliciesForTargetPaginator.this.client.listPoliciesForTarget((ListPoliciesForTargetRequest)((Object)ListPoliciesForTargetPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

