/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.organizations.model.ActionType;
import software.amazon.awssdk.services.organizations.transform.HandshakeFilterMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HandshakeFilter
implements StructuredPojo,
ToCopyableBuilder<Builder, HandshakeFilter> {
    private final String actionType;
    private final String parentHandshakeId;

    private HandshakeFilter(BuilderImpl builder) {
        this.actionType = builder.actionType;
        this.parentHandshakeId = builder.parentHandshakeId;
    }

    public ActionType actionType() {
        return ActionType.fromValue(this.actionType);
    }

    public String actionTypeString() {
        return this.actionType;
    }

    public String parentHandshakeId() {
        return this.parentHandshakeId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentHandshakeId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HandshakeFilter)) {
            return false;
        }
        HandshakeFilter other = (HandshakeFilter)obj;
        return Objects.equals(this.actionTypeString(), other.actionTypeString()) && Objects.equals(this.parentHandshakeId(), other.parentHandshakeId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.actionTypeString() != null) {
            sb.append("ActionType: ").append(this.actionTypeString()).append(",");
        }
        if (this.parentHandshakeId() != null) {
            sb.append("ParentHandshakeId: ").append(this.parentHandshakeId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionType": {
                return Optional.of(clazz.cast(this.actionTypeString()));
            }
            case "ParentHandshakeId": {
                return Optional.of(clazz.cast(this.parentHandshakeId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HandshakeFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionType;
        private String parentHandshakeId;

        private BuilderImpl() {
        }

        private BuilderImpl(HandshakeFilter model) {
            this.actionType(model.actionType);
            this.parentHandshakeId(model.parentHandshakeId);
        }

        public final String getActionType() {
            return this.actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ActionType actionType) {
            this.actionType(actionType.toString());
            return this;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        public final String getParentHandshakeId() {
            return this.parentHandshakeId;
        }

        @Override
        public final Builder parentHandshakeId(String parentHandshakeId) {
            this.parentHandshakeId = parentHandshakeId;
            return this;
        }

        public final void setParentHandshakeId(String parentHandshakeId) {
            this.parentHandshakeId = parentHandshakeId;
        }

        public HandshakeFilter build() {
            return new HandshakeFilter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HandshakeFilter> {
        public Builder actionType(String var1);

        public Builder actionType(ActionType var1);

        public Builder parentHandshakeId(String var1);
    }
}

