/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.organizations.model.PolicyType;
import software.amazon.awssdk.services.organizations.model.PolicyTypeStatus;
import software.amazon.awssdk.services.organizations.transform.PolicyTypeSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PolicyTypeSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, PolicyTypeSummary> {
    private final String type;
    private final String status;

    private PolicyTypeSummary(BuilderImpl builder) {
        this.type = builder.type;
        this.status = builder.status;
    }

    public PolicyType type() {
        return PolicyType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public PolicyTypeStatus status() {
        return PolicyTypeStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.typeString() == null ? 0 : this.typeString().hashCode());
        hashCode = 31 * hashCode + (this.statusString() == null ? 0 : this.statusString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyTypeSummary)) {
            return false;
        }
        PolicyTypeSummary other = (PolicyTypeSummary)obj;
        if (other.typeString() == null ^ this.typeString() == null) {
            return false;
        }
        if (other.typeString() != null && !other.typeString().equals(this.typeString())) {
            return false;
        }
        if (other.statusString() == null ^ this.statusString() == null) {
            return false;
        }
        return other.statusString() == null || other.statusString().equals(this.statusString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PolicyTypeSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyTypeSummary model) {
            this.type(model.type);
            this.status(model.status);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PolicyType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PolicyTypeStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public PolicyTypeSummary build() {
            return new PolicyTypeSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PolicyTypeSummary> {
        public Builder type(String var1);

        public Builder type(PolicyType var1);

        public Builder status(String var1);

        public Builder status(PolicyTypeStatus var1);
    }
}

