/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.organizations.model.ChildType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListChildrenRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListChildrenRequest> {
    private final String parentId;
    private final String childType;
    private final String nextToken;
    private final Integer maxResults;

    private ListChildrenRequest(BuilderImpl builder) {
        this.parentId = builder.parentId;
        this.childType = builder.childType;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public String parentId() {
        return this.parentId;
    }

    public ChildType childType() {
        return ChildType.fromValue(this.childType);
    }

    public String childTypeString() {
        return this.childType;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.parentId() == null ? 0 : this.parentId().hashCode());
        hashCode = 31 * hashCode + (this.childTypeString() == null ? 0 : this.childTypeString().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChildrenRequest)) {
            return false;
        }
        ListChildrenRequest other = (ListChildrenRequest)((Object)obj);
        if (other.parentId() == null ^ this.parentId() == null) {
            return false;
        }
        if (other.parentId() != null && !other.parentId().equals(this.parentId())) {
            return false;
        }
        if (other.childTypeString() == null ^ this.childTypeString() == null) {
            return false;
        }
        if (other.childTypeString() != null && !other.childTypeString().equals(this.childTypeString())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        return other.maxResults() == null || other.maxResults().equals(this.maxResults());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.parentId() != null) {
            sb.append("ParentId: ").append(this.parentId()).append(",");
        }
        if (this.childTypeString() != null) {
            sb.append("ChildType: ").append(this.childTypeString()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParentId": {
                return Optional.of(clazz.cast(this.parentId()));
            }
            case "ChildType": {
                return Optional.of(clazz.cast(this.childTypeString()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String parentId;
        private String childType;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChildrenRequest model) {
            this.parentId(model.parentId);
            this.childType(model.childType);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getParentId() {
            return this.parentId;
        }

        @Override
        public final Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public final void setParentId(String parentId) {
            this.parentId = parentId;
        }

        public final String getChildType() {
            return this.childType;
        }

        @Override
        public final Builder childType(String childType) {
            this.childType = childType;
            return this;
        }

        @Override
        public final Builder childType(ChildType childType) {
            this.childType(childType.toString());
            return this;
        }

        public final void setChildType(String childType) {
            this.childType = childType;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public ListChildrenRequest build() {
            return new ListChildrenRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListChildrenRequest> {
        public Builder parentId(String var1);

        public Builder childType(String var1);

        public Builder childType(ChildType var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);
    }
}

