/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.organizations.model.OrganizationFeatureSet;
import software.amazon.awssdk.services.organizations.model.PolicyTypeSummary;
import software.amazon.awssdk.services.organizations.model.PolicyTypesCopier;
import software.amazon.awssdk.services.organizations.transform.OrganizationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Organization
implements StructuredPojo,
ToCopyableBuilder<Builder, Organization> {
    private final String id;
    private final String arn;
    private final String featureSet;
    private final String masterAccountArn;
    private final String masterAccountId;
    private final String masterAccountEmail;
    private final List<PolicyTypeSummary> availablePolicyTypes;

    private Organization(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.featureSet = builder.featureSet;
        this.masterAccountArn = builder.masterAccountArn;
        this.masterAccountId = builder.masterAccountId;
        this.masterAccountEmail = builder.masterAccountEmail;
        this.availablePolicyTypes = builder.availablePolicyTypes;
    }

    public String id() {
        return this.id;
    }

    public String arn() {
        return this.arn;
    }

    public String featureSet() {
        return this.featureSet;
    }

    public String masterAccountArn() {
        return this.masterAccountArn;
    }

    public String masterAccountId() {
        return this.masterAccountId;
    }

    public String masterAccountEmail() {
        return this.masterAccountEmail;
    }

    public List<PolicyTypeSummary> availablePolicyTypes() {
        return this.availablePolicyTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.featureSet() == null ? 0 : this.featureSet().hashCode());
        hashCode = 31 * hashCode + (this.masterAccountArn() == null ? 0 : this.masterAccountArn().hashCode());
        hashCode = 31 * hashCode + (this.masterAccountId() == null ? 0 : this.masterAccountId().hashCode());
        hashCode = 31 * hashCode + (this.masterAccountEmail() == null ? 0 : this.masterAccountEmail().hashCode());
        hashCode = 31 * hashCode + (this.availablePolicyTypes() == null ? 0 : this.availablePolicyTypes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Organization)) {
            return false;
        }
        Organization other = (Organization)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.featureSet() == null ^ this.featureSet() == null) {
            return false;
        }
        if (other.featureSet() != null && !other.featureSet().equals(this.featureSet())) {
            return false;
        }
        if (other.masterAccountArn() == null ^ this.masterAccountArn() == null) {
            return false;
        }
        if (other.masterAccountArn() != null && !other.masterAccountArn().equals(this.masterAccountArn())) {
            return false;
        }
        if (other.masterAccountId() == null ^ this.masterAccountId() == null) {
            return false;
        }
        if (other.masterAccountId() != null && !other.masterAccountId().equals(this.masterAccountId())) {
            return false;
        }
        if (other.masterAccountEmail() == null ^ this.masterAccountEmail() == null) {
            return false;
        }
        if (other.masterAccountEmail() != null && !other.masterAccountEmail().equals(this.masterAccountEmail())) {
            return false;
        }
        if (other.availablePolicyTypes() == null ^ this.availablePolicyTypes() == null) {
            return false;
        }
        return other.availablePolicyTypes() == null || other.availablePolicyTypes().equals(this.availablePolicyTypes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.featureSet() != null) {
            sb.append("FeatureSet: ").append(this.featureSet()).append(",");
        }
        if (this.masterAccountArn() != null) {
            sb.append("MasterAccountArn: ").append(this.masterAccountArn()).append(",");
        }
        if (this.masterAccountId() != null) {
            sb.append("MasterAccountId: ").append(this.masterAccountId()).append(",");
        }
        if (this.masterAccountEmail() != null) {
            sb.append("MasterAccountEmail: ").append(this.masterAccountEmail()).append(",");
        }
        if (this.availablePolicyTypes() != null) {
            sb.append("AvailablePolicyTypes: ").append(this.availablePolicyTypes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OrganizationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String featureSet;
        private String masterAccountArn;
        private String masterAccountId;
        private String masterAccountEmail;
        private List<PolicyTypeSummary> availablePolicyTypes;

        private BuilderImpl() {
        }

        private BuilderImpl(Organization model) {
            this.setId(model.id);
            this.setArn(model.arn);
            this.setFeatureSet(model.featureSet);
            this.setMasterAccountArn(model.masterAccountArn);
            this.setMasterAccountId(model.masterAccountId);
            this.setMasterAccountEmail(model.masterAccountEmail);
            this.setAvailablePolicyTypes(model.availablePolicyTypes);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getFeatureSet() {
            return this.featureSet;
        }

        @Override
        public final Builder featureSet(String featureSet) {
            this.featureSet = featureSet;
            return this;
        }

        @Override
        public final Builder featureSet(OrganizationFeatureSet featureSet) {
            this.featureSet(featureSet.toString());
            return this;
        }

        public final void setFeatureSet(String featureSet) {
            this.featureSet = featureSet;
        }

        public final String getMasterAccountArn() {
            return this.masterAccountArn;
        }

        @Override
        public final Builder masterAccountArn(String masterAccountArn) {
            this.masterAccountArn = masterAccountArn;
            return this;
        }

        public final void setMasterAccountArn(String masterAccountArn) {
            this.masterAccountArn = masterAccountArn;
        }

        public final String getMasterAccountId() {
            return this.masterAccountId;
        }

        @Override
        public final Builder masterAccountId(String masterAccountId) {
            this.masterAccountId = masterAccountId;
            return this;
        }

        public final void setMasterAccountId(String masterAccountId) {
            this.masterAccountId = masterAccountId;
        }

        public final String getMasterAccountEmail() {
            return this.masterAccountEmail;
        }

        @Override
        public final Builder masterAccountEmail(String masterAccountEmail) {
            this.masterAccountEmail = masterAccountEmail;
            return this;
        }

        public final void setMasterAccountEmail(String masterAccountEmail) {
            this.masterAccountEmail = masterAccountEmail;
        }

        public final Collection<PolicyTypeSummary> getAvailablePolicyTypes() {
            return this.availablePolicyTypes;
        }

        @Override
        public final Builder availablePolicyTypes(Collection<PolicyTypeSummary> availablePolicyTypes) {
            this.availablePolicyTypes = PolicyTypesCopier.copy(availablePolicyTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availablePolicyTypes(PolicyTypeSummary ... availablePolicyTypes) {
            this.availablePolicyTypes(Arrays.asList(availablePolicyTypes));
            return this;
        }

        public final void setAvailablePolicyTypes(Collection<PolicyTypeSummary> availablePolicyTypes) {
            this.availablePolicyTypes = PolicyTypesCopier.copy(availablePolicyTypes);
        }

        public Organization build() {
            return new Organization(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Organization> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder featureSet(String var1);

        public Builder featureSet(OrganizationFeatureSet var1);

        public Builder masterAccountArn(String var1);

        public Builder masterAccountId(String var1);

        public Builder masterAccountEmail(String var1);

        public Builder availablePolicyTypes(Collection<PolicyTypeSummary> var1);

        public Builder availablePolicyTypes(PolicyTypeSummary ... var1);
    }
}

