/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MoveAccountRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, MoveAccountRequest> {
    private final String accountId;
    private final String sourceParentId;
    private final String destinationParentId;

    private MoveAccountRequest(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.sourceParentId = builder.sourceParentId;
        this.destinationParentId = builder.destinationParentId;
    }

    public String accountId() {
        return this.accountId;
    }

    public String sourceParentId() {
        return this.sourceParentId;
    }

    public String destinationParentId() {
        return this.destinationParentId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.accountId() == null ? 0 : this.accountId().hashCode());
        hashCode = 31 * hashCode + (this.sourceParentId() == null ? 0 : this.sourceParentId().hashCode());
        hashCode = 31 * hashCode + (this.destinationParentId() == null ? 0 : this.destinationParentId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MoveAccountRequest)) {
            return false;
        }
        MoveAccountRequest other = (MoveAccountRequest)((Object)obj);
        if (other.accountId() == null ^ this.accountId() == null) {
            return false;
        }
        if (other.accountId() != null && !other.accountId().equals(this.accountId())) {
            return false;
        }
        if (other.sourceParentId() == null ^ this.sourceParentId() == null) {
            return false;
        }
        if (other.sourceParentId() != null && !other.sourceParentId().equals(this.sourceParentId())) {
            return false;
        }
        if (other.destinationParentId() == null ^ this.destinationParentId() == null) {
            return false;
        }
        return other.destinationParentId() == null || other.destinationParentId().equals(this.destinationParentId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.accountId() != null) {
            sb.append("AccountId: ").append(this.accountId()).append(",");
        }
        if (this.sourceParentId() != null) {
            sb.append("SourceParentId: ").append(this.sourceParentId()).append(",");
        }
        if (this.destinationParentId() != null) {
            sb.append("DestinationParentId: ").append(this.destinationParentId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String sourceParentId;
        private String destinationParentId;

        private BuilderImpl() {
        }

        private BuilderImpl(MoveAccountRequest model) {
            this.setAccountId(model.accountId);
            this.setSourceParentId(model.sourceParentId);
            this.setDestinationParentId(model.destinationParentId);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getSourceParentId() {
            return this.sourceParentId;
        }

        @Override
        public final Builder sourceParentId(String sourceParentId) {
            this.sourceParentId = sourceParentId;
            return this;
        }

        public final void setSourceParentId(String sourceParentId) {
            this.sourceParentId = sourceParentId;
        }

        public final String getDestinationParentId() {
            return this.destinationParentId;
        }

        @Override
        public final Builder destinationParentId(String destinationParentId) {
            this.destinationParentId = destinationParentId;
            return this;
        }

        public final void setDestinationParentId(String destinationParentId) {
            this.destinationParentId = destinationParentId;
        }

        public MoveAccountRequest build() {
            return new MoveAccountRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MoveAccountRequest> {
        public Builder accountId(String var1);

        public Builder sourceParentId(String var1);

        public Builder destinationParentId(String var1);
    }
}

