/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.organizations.model.Parent;
import software.amazon.awssdk.services.organizations.model.ParentsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListParentsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListParentsResponse> {
    private final List<Parent> parents;
    private final String nextToken;

    private ListParentsResponse(BuilderImpl builder) {
        this.parents = builder.parents;
        this.nextToken = builder.nextToken;
    }

    public List<Parent> parents() {
        return this.parents;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.parents() == null ? 0 : this.parents().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListParentsResponse)) {
            return false;
        }
        ListParentsResponse other = (ListParentsResponse)((Object)obj);
        if (other.parents() == null ^ this.parents() == null) {
            return false;
        }
        if (other.parents() != null && !other.parents().equals(this.parents())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.parents() != null) {
            sb.append("Parents: ").append(this.parents()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Parent> parents;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListParentsResponse model) {
            this.setParents(model.parents);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Parent> getParents() {
            return this.parents;
        }

        @Override
        public final Builder parents(Collection<Parent> parents) {
            this.parents = ParentsCopier.copy(parents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parents(Parent ... parents) {
            this.parents(Arrays.asList(parents));
            return this;
        }

        public final void setParents(Collection<Parent> parents) {
            this.parents = ParentsCopier.copy(parents);
        }

        @SafeVarargs
        public final void setParents(Parent ... parents) {
            this.parents(Arrays.asList(parents));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListParentsResponse build() {
            return new ListParentsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListParentsResponse> {
        public Builder parents(Collection<Parent> var1);

        public Builder parents(Parent ... var1);

        public Builder nextToken(String var1);
    }
}

