/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.organizations.model.OrganizationalUnit;
import software.amazon.awssdk.services.organizations.model.OrganizationalUnitsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListOrganizationalUnitsForParentResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListOrganizationalUnitsForParentResponse> {
    private final List<OrganizationalUnit> organizationalUnits;
    private final String nextToken;

    private ListOrganizationalUnitsForParentResponse(BuilderImpl builder) {
        this.organizationalUnits = builder.organizationalUnits;
        this.nextToken = builder.nextToken;
    }

    public List<OrganizationalUnit> organizationalUnits() {
        return this.organizationalUnits;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.organizationalUnits() == null ? 0 : this.organizationalUnits().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOrganizationalUnitsForParentResponse)) {
            return false;
        }
        ListOrganizationalUnitsForParentResponse other = (ListOrganizationalUnitsForParentResponse)((Object)obj);
        if (other.organizationalUnits() == null ^ this.organizationalUnits() == null) {
            return false;
        }
        if (other.organizationalUnits() != null && !other.organizationalUnits().equals(this.organizationalUnits())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.organizationalUnits() != null) {
            sb.append("OrganizationalUnits: ").append(this.organizationalUnits()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<OrganizationalUnit> organizationalUnits;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOrganizationalUnitsForParentResponse model) {
            this.setOrganizationalUnits(model.organizationalUnits);
            this.setNextToken(model.nextToken);
        }

        public final Collection<OrganizationalUnit> getOrganizationalUnits() {
            return this.organizationalUnits;
        }

        @Override
        public final Builder organizationalUnits(Collection<OrganizationalUnit> organizationalUnits) {
            this.organizationalUnits = OrganizationalUnitsCopier.copy(organizationalUnits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnits(OrganizationalUnit ... organizationalUnits) {
            this.organizationalUnits(Arrays.asList(organizationalUnits));
            return this;
        }

        public final void setOrganizationalUnits(Collection<OrganizationalUnit> organizationalUnits) {
            this.organizationalUnits = OrganizationalUnitsCopier.copy(organizationalUnits);
        }

        @SafeVarargs
        public final void setOrganizationalUnits(OrganizationalUnit ... organizationalUnits) {
            this.organizationalUnits(Arrays.asList(organizationalUnits));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListOrganizationalUnitsForParentResponse build() {
            return new ListOrganizationalUnitsForParentResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListOrganizationalUnitsForParentResponse> {
        public Builder organizationalUnits(Collection<OrganizationalUnit> var1);

        public Builder organizationalUnits(OrganizationalUnit ... var1);

        public Builder nextToken(String var1);
    }
}

