/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.organizations.model.Handshake;
import software.amazon.awssdk.services.organizations.model.HandshakesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListHandshakesForOrganizationResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListHandshakesForOrganizationResponse> {
    private final List<Handshake> handshakes;
    private final String nextToken;

    private ListHandshakesForOrganizationResponse(BuilderImpl builder) {
        this.handshakes = builder.handshakes;
        this.nextToken = builder.nextToken;
    }

    public List<Handshake> handshakes() {
        return this.handshakes;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.handshakes() == null ? 0 : this.handshakes().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHandshakesForOrganizationResponse)) {
            return false;
        }
        ListHandshakesForOrganizationResponse other = (ListHandshakesForOrganizationResponse)((Object)obj);
        if (other.handshakes() == null ^ this.handshakes() == null) {
            return false;
        }
        if (other.handshakes() != null && !other.handshakes().equals(this.handshakes())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.handshakes() != null) {
            sb.append("Handshakes: ").append(this.handshakes()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Handshake> handshakes;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHandshakesForOrganizationResponse model) {
            this.setHandshakes(model.handshakes);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Handshake> getHandshakes() {
            return this.handshakes;
        }

        @Override
        public final Builder handshakes(Collection<Handshake> handshakes) {
            this.handshakes = HandshakesCopier.copy(handshakes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder handshakes(Handshake ... handshakes) {
            this.handshakes(Arrays.asList(handshakes));
            return this;
        }

        public final void setHandshakes(Collection<Handshake> handshakes) {
            this.handshakes = HandshakesCopier.copy(handshakes);
        }

        @SafeVarargs
        public final void setHandshakes(Handshake ... handshakes) {
            this.handshakes(Arrays.asList(handshakes));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListHandshakesForOrganizationResponse build() {
            return new ListHandshakesForOrganizationResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListHandshakesForOrganizationResponse> {
        public Builder handshakes(Collection<Handshake> var1);

        public Builder handshakes(Handshake ... var1);

        public Builder nextToken(String var1);
    }
}

