/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.organizations.model.PolicySummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PolicySummaryMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<Boolean> AWSMANAGED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AwsManaged").isBinary(false).build();
    private static final PolicySummaryMarshaller INSTANCE = new PolicySummaryMarshaller();

    private PolicySummaryMarshaller() {
    }

    public static PolicySummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PolicySummary policySummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)policySummary, (String)"policySummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)policySummary.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)policySummary.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)policySummary.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)policySummary.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)policySummary.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)policySummary.awsManaged(), AWSMANAGED_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

