/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.organizations.model.MoveAccountRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MoveAccountRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountId").isBinary(false).build();
    private static final MarshallingInfo<String> SOURCEPARENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceParentId").isBinary(false).build();
    private static final MarshallingInfo<String> DESTINATIONPARENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationParentId").isBinary(false).build();
    private static final MoveAccountRequestModelMarshaller INSTANCE = new MoveAccountRequestModelMarshaller();

    private MoveAccountRequestModelMarshaller() {
    }

    public static MoveAccountRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MoveAccountRequest moveAccountRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)moveAccountRequest), (String)"moveAccountRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)moveAccountRequest.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)moveAccountRequest.sourceParentId(), SOURCEPARENTID_BINDING);
            protocolMarshaller.marshall((Object)moveAccountRequest.destinationParentId(), DESTINATIONPARENTID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

