/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.organizations.model.CreateAccountStatus;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateAccountStatusMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> ACCOUNTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountName").isBinary(false).build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").isBinary(false).build();
    private static final MarshallingInfo<Instant> REQUESTEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequestedTimestamp").isBinary(false).build();
    private static final MarshallingInfo<Instant> COMPLETEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompletedTimestamp").isBinary(false).build();
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountId").isBinary(false).build();
    private static final MarshallingInfo<String> FAILUREREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailureReason").isBinary(false).build();
    private static final CreateAccountStatusMarshaller INSTANCE = new CreateAccountStatusMarshaller();

    private CreateAccountStatusMarshaller() {
    }

    public static CreateAccountStatusMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateAccountStatus createAccountStatus, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)createAccountStatus, (String)"createAccountStatus");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createAccountStatus.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)createAccountStatus.accountName(), ACCOUNTNAME_BINDING);
            protocolMarshaller.marshall((Object)createAccountStatus.stateAsString(), STATE_BINDING);
            protocolMarshaller.marshall((Object)createAccountStatus.requestedTimestamp(), REQUESTEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)createAccountStatus.completedTimestamp(), COMPLETEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)createAccountStatus.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)createAccountStatus.failureReasonAsString(), FAILUREREASON_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

