/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.organizations.model.CreateAccountRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateAccountRequestModelMarshaller {
    private static final MarshallingInfo<String> EMAIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Email").isBinary(false).build();
    private static final MarshallingInfo<String> ACCOUNTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountName").isBinary(false).build();
    private static final MarshallingInfo<String> ROLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleName").isBinary(false).build();
    private static final MarshallingInfo<String> IAMUSERACCESSTOBILLING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IamUserAccessToBilling").isBinary(false).build();
    private static final CreateAccountRequestModelMarshaller INSTANCE = new CreateAccountRequestModelMarshaller();

    private CreateAccountRequestModelMarshaller() {
    }

    public static CreateAccountRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateAccountRequest createAccountRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createAccountRequest), (String)"createAccountRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createAccountRequest.email(), EMAIL_BINDING);
            protocolMarshaller.marshall((Object)createAccountRequest.accountName(), ACCOUNTNAME_BINDING);
            protocolMarshaller.marshall((Object)createAccountRequest.roleName(), ROLENAME_BINDING);
            protocolMarshaller.marshall((Object)createAccountRequest.iamUserAccessToBillingAsString(), IAMUSERACCESSTOBILLING_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

