/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.organizations.model.PolicyTypeSummary;
import software.amazon.awssdk.services.organizations.model.PolicyTypesCopier;
import software.amazon.awssdk.services.organizations.transform.RootMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Root
implements StructuredPojo,
ToCopyableBuilder<Builder, Root> {
    private final String id;
    private final String arn;
    private final String name;
    private final List<PolicyTypeSummary> policyTypes;

    private Root(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.policyTypes = builder.policyTypes;
    }

    public String id() {
        return this.id;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public List<PolicyTypeSummary> policyTypes() {
        return this.policyTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Root)) {
            return false;
        }
        Root other = (Root)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.policyTypes(), other.policyTypes());
    }

    public String toString() {
        return ToString.builder((String)"Root").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("PolicyTypes", this.policyTypes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "PolicyTypes": {
                return Optional.ofNullable(clazz.cast(this.policyTypes()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RootMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String name;
        private List<PolicyTypeSummary> policyTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Root model) {
            this.id(model.id);
            this.arn(model.arn);
            this.name(model.name);
            this.policyTypes(model.policyTypes);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<PolicyTypeSummary.Builder> getPolicyTypes() {
            return this.policyTypes != null ? (Collection)this.policyTypes.stream().map(PolicyTypeSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder policyTypes(Collection<PolicyTypeSummary> policyTypes) {
            this.policyTypes = PolicyTypesCopier.copy(policyTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyTypes(PolicyTypeSummary ... policyTypes) {
            this.policyTypes(Arrays.asList(policyTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyTypes(Consumer<PolicyTypeSummary.Builder> ... policyTypes) {
            this.policyTypes(Stream.of(policyTypes).map(c -> (PolicyTypeSummary)((PolicyTypeSummary.Builder)PolicyTypeSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPolicyTypes(Collection<PolicyTypeSummary.BuilderImpl> policyTypes) {
            this.policyTypes = PolicyTypesCopier.copyFromBuilder(policyTypes);
        }

        public Root build() {
            return new Root(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Root> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder policyTypes(Collection<PolicyTypeSummary> var1);

        public Builder policyTypes(PolicyTypeSummary ... var1);

        public Builder policyTypes(Consumer<PolicyTypeSummary.Builder> ... var1);
    }
}

