/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.organizations.model.OrganizationsResponse;
import software.amazon.awssdk.services.organizations.model.PolicyTargetSummary;
import software.amazon.awssdk.services.organizations.model.PolicyTargetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTargetsForPolicyResponse
extends OrganizationsResponse
implements ToCopyableBuilder<Builder, ListTargetsForPolicyResponse> {
    private final List<PolicyTargetSummary> targets;
    private final String nextToken;

    private ListTargetsForPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.targets = builder.targets;
        this.nextToken = builder.nextToken;
    }

    public List<PolicyTargetSummary> targets() {
        return this.targets;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targets());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTargetsForPolicyResponse)) {
            return false;
        }
        ListTargetsForPolicyResponse other = (ListTargetsForPolicyResponse)((Object)obj);
        return Objects.equals(this.targets(), other.targets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListTargetsForPolicyResponse").add("Targets", this.targets()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OrganizationsResponse.BuilderImpl
    implements Builder {
        private List<PolicyTargetSummary> targets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTargetsForPolicyResponse model) {
            super(model);
            this.targets(model.targets);
            this.nextToken(model.nextToken);
        }

        public final Collection<PolicyTargetSummary.Builder> getTargets() {
            return this.targets != null ? (Collection)this.targets.stream().map(PolicyTargetSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<PolicyTargetSummary> targets) {
            this.targets = PolicyTargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(PolicyTargetSummary ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<PolicyTargetSummary.Builder> ... targets) {
            this.targets(Stream.of(targets).map(c -> (PolicyTargetSummary)((PolicyTargetSummary.Builder)PolicyTargetSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargets(Collection<PolicyTargetSummary.BuilderImpl> targets) {
            this.targets = PolicyTargetsCopier.copyFromBuilder(targets);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTargetsForPolicyResponse build() {
            return new ListTargetsForPolicyResponse(this);
        }
    }

    public static interface Builder
    extends OrganizationsResponse.Builder,
    CopyableBuilder<Builder, ListTargetsForPolicyResponse> {
        public Builder targets(Collection<PolicyTargetSummary> var1);

        public Builder targets(PolicyTargetSummary ... var1);

        public Builder targets(Consumer<PolicyTargetSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

