/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.organizations.model.Account;
import software.amazon.awssdk.services.organizations.model.AccountsCopier;
import software.amazon.awssdk.services.organizations.model.OrganizationsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAccountsResponse
extends OrganizationsResponse
implements ToCopyableBuilder<Builder, ListAccountsResponse> {
    private final List<Account> accounts;
    private final String nextToken;

    private ListAccountsResponse(BuilderImpl builder) {
        super(builder);
        this.accounts = builder.accounts;
        this.nextToken = builder.nextToken;
    }

    public List<Account> accounts() {
        return this.accounts;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accounts());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccountsResponse)) {
            return false;
        }
        ListAccountsResponse other = (ListAccountsResponse)((Object)obj);
        return Objects.equals(this.accounts(), other.accounts()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListAccountsResponse").add("Accounts", this.accounts()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Accounts": {
                return Optional.ofNullable(clazz.cast(this.accounts()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OrganizationsResponse.BuilderImpl
    implements Builder {
        private List<Account> accounts = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccountsResponse model) {
            super(model);
            this.accounts(model.accounts);
            this.nextToken(model.nextToken);
        }

        public final Collection<Account.Builder> getAccounts() {
            return this.accounts != null ? (Collection)this.accounts.stream().map(Account::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accounts(Collection<Account> accounts) {
            this.accounts = AccountsCopier.copy(accounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(Account ... accounts) {
            this.accounts(Arrays.asList(accounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(Consumer<Account.Builder> ... accounts) {
            this.accounts(Stream.of(accounts).map(c -> (Account)((Account.Builder)Account.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAccounts(Collection<Account.BuilderImpl> accounts) {
            this.accounts = AccountsCopier.copyFromBuilder(accounts);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAccountsResponse build() {
            return new ListAccountsResponse(this);
        }
    }

    public static interface Builder
    extends OrganizationsResponse.Builder,
    CopyableBuilder<Builder, ListAccountsResponse> {
        public Builder accounts(Collection<Account> var1);

        public Builder accounts(Account ... var1);

        public Builder accounts(Consumer<Account.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

