/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.organizations.model.Policy;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PolicyMarshaller {
    private static final MarshallingInfo<StructuredPojo> POLICYSUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PolicySummary").isBinary(false).build();
    private static final MarshallingInfo<String> CONTENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Content").isBinary(false).build();
    private static final PolicyMarshaller INSTANCE = new PolicyMarshaller();

    private PolicyMarshaller() {
    }

    public static PolicyMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Policy policy, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)policy, (String)"policy");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)policy.policySummary(), POLICYSUMMARY_BINDING);
            protocolMarshaller.marshall((Object)policy.content(), CONTENT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

