/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.organizations.model.Parent;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ParentMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final ParentMarshaller INSTANCE = new ParentMarshaller();

    private ParentMarshaller() {
    }

    public static ParentMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Parent parent, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)parent, (String)"parent");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)parent.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)parent.typeAsString(), TYPE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

