/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.organizations.model.Organization;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OrganizationMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").isBinary(false).build();
    private static final MarshallingInfo<String> FEATURESET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FeatureSet").isBinary(false).build();
    private static final MarshallingInfo<String> MASTERACCOUNTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MasterAccountArn").isBinary(false).build();
    private static final MarshallingInfo<String> MASTERACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MasterAccountId").isBinary(false).build();
    private static final MarshallingInfo<String> MASTERACCOUNTEMAIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MasterAccountEmail").isBinary(false).build();
    private static final MarshallingInfo<List> AVAILABLEPOLICYTYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AvailablePolicyTypes").isBinary(false).build();
    private static final OrganizationMarshaller INSTANCE = new OrganizationMarshaller();

    private OrganizationMarshaller() {
    }

    public static OrganizationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Organization organization, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)organization, (String)"organization");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)organization.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)organization.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)organization.featureSetAsString(), FEATURESET_BINDING);
            protocolMarshaller.marshall((Object)organization.masterAccountArn(), MASTERACCOUNTARN_BINDING);
            protocolMarshaller.marshall((Object)organization.masterAccountId(), MASTERACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)organization.masterAccountEmail(), MASTERACCOUNTEMAIL_BINDING);
            protocolMarshaller.marshall(organization.availablePolicyTypes(), AVAILABLEPOLICYTYPES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

