/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.organizations.model.HandshakeResource;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class HandshakeResourceMarshaller {
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<List> RESOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Resources").isBinary(false).build();
    private static final HandshakeResourceMarshaller INSTANCE = new HandshakeResourceMarshaller();

    private HandshakeResourceMarshaller() {
    }

    public static HandshakeResourceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(HandshakeResource handshakeResource, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)handshakeResource, (String)"handshakeResource");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)handshakeResource.value(), VALUE_BINDING);
            protocolMarshaller.marshall((Object)handshakeResource.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall(handshakeResource.resources(), RESOURCES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

