/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.organizations.model.Account;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AccountMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").isBinary(false).build();
    private static final MarshallingInfo<String> EMAIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Email").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<String> JOINEDMETHOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JoinedMethod").isBinary(false).build();
    private static final MarshallingInfo<Instant> JOINEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JoinedTimestamp").isBinary(false).build();
    private static final AccountMarshaller INSTANCE = new AccountMarshaller();

    private AccountMarshaller() {
    }

    public static AccountMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Account account, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)account, (String)"account");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)account.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)account.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)account.email(), EMAIL_BINDING);
            protocolMarshaller.marshall((Object)account.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)account.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)account.joinedMethodAsString(), JOINEDMETHOD_BINDING);
            protocolMarshaller.marshall((Object)account.joinedTimestamp(), JOINEDTIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

