/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetRequest;
import software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetResponse;

public class ListPoliciesForTargetIterable
implements SdkIterable<ListPoliciesForTargetResponse> {
    private final OrganizationsClient client;
    private final ListPoliciesForTargetRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPoliciesForTargetIterable(OrganizationsClient client, ListPoliciesForTargetRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPoliciesForTargetResponseFetcher();
    }

    public Iterator<ListPoliciesForTargetResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListPoliciesForTargetIterable resume(ListPoliciesForTargetResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListPoliciesForTargetIterable(this.client, (ListPoliciesForTargetRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListPoliciesForTargetIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListPoliciesForTargetResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListPoliciesForTargetResponseFetcher
    implements SyncPageFetcher<ListPoliciesForTargetResponse> {
        private ListPoliciesForTargetResponseFetcher() {
        }

        public boolean hasNextPage(ListPoliciesForTargetResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public ListPoliciesForTargetResponse nextPage(ListPoliciesForTargetResponse previousPage) {
            if (previousPage == null) {
                return ListPoliciesForTargetIterable.this.client.listPoliciesForTarget(ListPoliciesForTargetIterable.this.firstRequest);
            }
            return ListPoliciesForTargetIterable.this.client.listPoliciesForTarget((ListPoliciesForTargetRequest)((Object)ListPoliciesForTargetIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

