/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.model.ListHandshakesForAccountRequest;
import software.amazon.awssdk.services.organizations.model.ListHandshakesForAccountResponse;

public class ListHandshakesForAccountIterable
implements SdkIterable<ListHandshakesForAccountResponse> {
    private final OrganizationsClient client;
    private final ListHandshakesForAccountRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListHandshakesForAccountIterable(OrganizationsClient client, ListHandshakesForAccountRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListHandshakesForAccountResponseFetcher();
    }

    public Iterator<ListHandshakesForAccountResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListHandshakesForAccountIterable resume(ListHandshakesForAccountResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListHandshakesForAccountIterable(this.client, (ListHandshakesForAccountRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListHandshakesForAccountIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListHandshakesForAccountResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListHandshakesForAccountResponseFetcher
    implements SyncPageFetcher<ListHandshakesForAccountResponse> {
        private ListHandshakesForAccountResponseFetcher() {
        }

        public boolean hasNextPage(ListHandshakesForAccountResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public ListHandshakesForAccountResponse nextPage(ListHandshakesForAccountResponse previousPage) {
            if (previousPage == null) {
                return ListHandshakesForAccountIterable.this.client.listHandshakesForAccount(ListHandshakesForAccountIterable.this.firstRequest);
            }
            return ListHandshakesForAccountIterable.this.client.listHandshakesForAccount((ListHandshakesForAccountRequest)((Object)ListHandshakesForAccountIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

