/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.organizations.OrganizationsAsyncClient;
import software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusRequest;
import software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusResponse;

public class ListCreateAccountStatusPublisher
implements SdkPublisher<ListCreateAccountStatusResponse> {
    private final OrganizationsAsyncClient client;
    private final ListCreateAccountStatusRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCreateAccountStatusPublisher(OrganizationsAsyncClient client, ListCreateAccountStatusRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCreateAccountStatusPublisher(OrganizationsAsyncClient client, ListCreateAccountStatusRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCreateAccountStatusResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCreateAccountStatusResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListCreateAccountStatusPublisher resume(ListCreateAccountStatusResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListCreateAccountStatusPublisher(this.client, (ListCreateAccountStatusRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListCreateAccountStatusPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListCreateAccountStatusResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListCreateAccountStatusResponseFetcher
    implements AsyncPageFetcher<ListCreateAccountStatusResponse> {
        private ListCreateAccountStatusResponseFetcher() {
        }

        public boolean hasNextPage(ListCreateAccountStatusResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public CompletableFuture<ListCreateAccountStatusResponse> nextPage(ListCreateAccountStatusResponse previousPage) {
            if (previousPage == null) {
                return ListCreateAccountStatusPublisher.this.client.listCreateAccountStatus(ListCreateAccountStatusPublisher.this.firstRequest);
            }
            return ListCreateAccountStatusPublisher.this.client.listCreateAccountStatus((ListCreateAccountStatusRequest)((Object)ListCreateAccountStatusPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

