/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.model.ListAccountsForParentRequest;
import software.amazon.awssdk.services.organizations.model.ListAccountsForParentResponse;

public class ListAccountsForParentIterable
implements SdkIterable<ListAccountsForParentResponse> {
    private final OrganizationsClient client;
    private final ListAccountsForParentRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccountsForParentIterable(OrganizationsClient client, ListAccountsForParentRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAccountsForParentResponseFetcher();
    }

    public Iterator<ListAccountsForParentResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListAccountsForParentIterable resume(ListAccountsForParentResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListAccountsForParentIterable(this.client, (ListAccountsForParentRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListAccountsForParentIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListAccountsForParentResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListAccountsForParentResponseFetcher
    implements SyncPageFetcher<ListAccountsForParentResponse> {
        private ListAccountsForParentResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountsForParentResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public ListAccountsForParentResponse nextPage(ListAccountsForParentResponse previousPage) {
            if (previousPage == null) {
                return ListAccountsForParentIterable.this.client.listAccountsForParent(ListAccountsForParentIterable.this.firstRequest);
            }
            return ListAccountsForParentIterable.this.client.listAccountsForParent((ListAccountsForParentRequest)((Object)ListAccountsForParentIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

