/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.opsworkscm.model.OpsWorksCmResponse;
import software.amazon.awssdk.services.opsworkscm.model.Server;
import software.amazon.awssdk.services.opsworkscm.model.ServersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeServersResponse
extends OpsWorksCmResponse
implements ToCopyableBuilder<Builder, DescribeServersResponse> {
    private static final SdkField<List<Server>> SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeServersResponse.getter(DescribeServersResponse::servers)).setter(DescribeServersResponse.setter(Builder::servers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Servers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Server::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeServersResponse.getter(DescribeServersResponse::nextToken)).setter(DescribeServersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVERS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Server> servers;
    private final String nextToken;

    private DescribeServersResponse(BuilderImpl builder) {
        super(builder);
        this.servers = builder.servers;
        this.nextToken = builder.nextToken;
    }

    public List<Server> servers() {
        return this.servers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.servers());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServersResponse)) {
            return false;
        }
        DescribeServersResponse other = (DescribeServersResponse)((Object)obj);
        return Objects.equals(this.servers(), other.servers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeServersResponse").add("Servers", this.servers()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Servers": {
                return Optional.ofNullable(clazz.cast(this.servers()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeServersResponse, T> g) {
        return obj -> g.apply((DescribeServersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksCmResponse.BuilderImpl
    implements Builder {
        private List<Server> servers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServersResponse model) {
            super(model);
            this.servers(model.servers);
            this.nextToken(model.nextToken);
        }

        public final Collection<Server.Builder> getServers() {
            return this.servers != null ? (Collection)this.servers.stream().map(Server::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder servers(Collection<Server> servers) {
            this.servers = ServersCopier.copy(servers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder servers(Server ... servers) {
            this.servers(Arrays.asList(servers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder servers(Consumer<Server.Builder> ... servers) {
            this.servers(Stream.of(servers).map(c -> (Server)((Server.Builder)Server.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServers(Collection<Server.BuilderImpl> servers) {
            this.servers = ServersCopier.copyFromBuilder(servers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeServersResponse build() {
            return new DescribeServersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpsWorksCmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeServersResponse> {
        public Builder servers(Collection<Server> var1);

        public Builder servers(Server ... var1);

        public Builder servers(Consumer<Server.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

