/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateServerRequest extends OpsWorksCmRequest implements
        ToCopyableBuilder<UpdateServerRequest.Builder, UpdateServerRequest> {
    private static final SdkField<Boolean> DISABLE_AUTOMATED_BACKUP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DisableAutomatedBackup").getter(getter(UpdateServerRequest::disableAutomatedBackup))
            .setter(setter(Builder::disableAutomatedBackup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableAutomatedBackup").build())
            .build();

    private static final SdkField<Integer> BACKUP_RETENTION_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BackupRetentionCount").getter(getter(UpdateServerRequest::backupRetentionCount))
            .setter(setter(Builder::backupRetentionCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionCount").build())
            .build();

    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerName").getter(getter(UpdateServerRequest::serverName)).setter(setter(Builder::serverName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()).build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreferredMaintenanceWindow")
            .getter(getter(UpdateServerRequest::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreferredBackupWindow").getter(getter(UpdateServerRequest::preferredBackupWindow))
            .setter(setter(Builder::preferredBackupWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredBackupWindow").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DISABLE_AUTOMATED_BACKUP_FIELD, BACKUP_RETENTION_COUNT_FIELD, SERVER_NAME_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD,
            PREFERRED_BACKUP_WINDOW_FIELD));

    private final Boolean disableAutomatedBackup;

    private final Integer backupRetentionCount;

    private final String serverName;

    private final String preferredMaintenanceWindow;

    private final String preferredBackupWindow;

    private UpdateServerRequest(BuilderImpl builder) {
        super(builder);
        this.disableAutomatedBackup = builder.disableAutomatedBackup;
        this.backupRetentionCount = builder.backupRetentionCount;
        this.serverName = builder.serverName;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.preferredBackupWindow = builder.preferredBackupWindow;
    }

    /**
     * <p>
     * Setting DisableAutomatedBackup to <code>true</code> disables automated or scheduled backups. Automated backups
     * are enabled by default.
     * </p>
     * 
     * @return Setting DisableAutomatedBackup to <code>true</code> disables automated or scheduled backups. Automated
     *         backups are enabled by default.
     */
    public final Boolean disableAutomatedBackup() {
        return disableAutomatedBackup;
    }

    /**
     * <p>
     * Sets the number of automated backups that you want to keep.
     * </p>
     * 
     * @return Sets the number of automated backups that you want to keep.
     */
    public final Integer backupRetentionCount() {
        return backupRetentionCount;
    }

    /**
     * <p>
     * The name of the server to update.
     * </p>
     * 
     * @return The name of the server to update.
     */
    public final String serverName() {
        return serverName;
    }

    /**
     * Returns the value of the PreferredMaintenanceWindow property for this object.
     * 
     * @return The value of the PreferredMaintenanceWindow property for this object.
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * Returns the value of the PreferredBackupWindow property for this object.
     * 
     * @return The value of the PreferredBackupWindow property for this object.
     */
    public final String preferredBackupWindow() {
        return preferredBackupWindow;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(disableAutomatedBackup());
        hashCode = 31 * hashCode + Objects.hashCode(backupRetentionCount());
        hashCode = 31 * hashCode + Objects.hashCode(serverName());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(preferredBackupWindow());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServerRequest)) {
            return false;
        }
        UpdateServerRequest other = (UpdateServerRequest) obj;
        return Objects.equals(disableAutomatedBackup(), other.disableAutomatedBackup())
                && Objects.equals(backupRetentionCount(), other.backupRetentionCount())
                && Objects.equals(serverName(), other.serverName())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(preferredBackupWindow(), other.preferredBackupWindow());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateServerRequest").add("DisableAutomatedBackup", disableAutomatedBackup())
                .add("BackupRetentionCount", backupRetentionCount()).add("ServerName", serverName())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow())
                .add("PreferredBackupWindow", preferredBackupWindow()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DisableAutomatedBackup":
            return Optional.ofNullable(clazz.cast(disableAutomatedBackup()));
        case "BackupRetentionCount":
            return Optional.ofNullable(clazz.cast(backupRetentionCount()));
        case "ServerName":
            return Optional.ofNullable(clazz.cast(serverName()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "PreferredBackupWindow":
            return Optional.ofNullable(clazz.cast(preferredBackupWindow()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateServerRequest, T> g) {
        return obj -> g.apply((UpdateServerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksCmRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateServerRequest> {
        /**
         * <p>
         * Setting DisableAutomatedBackup to <code>true</code> disables automated or scheduled backups. Automated
         * backups are enabled by default.
         * </p>
         * 
         * @param disableAutomatedBackup
         *        Setting DisableAutomatedBackup to <code>true</code> disables automated or scheduled backups. Automated
         *        backups are enabled by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableAutomatedBackup(Boolean disableAutomatedBackup);

        /**
         * <p>
         * Sets the number of automated backups that you want to keep.
         * </p>
         * 
         * @param backupRetentionCount
         *        Sets the number of automated backups that you want to keep.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRetentionCount(Integer backupRetentionCount);

        /**
         * <p>
         * The name of the server to update.
         * </p>
         * 
         * @param serverName
         *        The name of the server to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverName(String serverName);

        /**
         * Sets the value of the PreferredMaintenanceWindow property for this object.
         *
         * @param preferredMaintenanceWindow
         *        The new value for the PreferredMaintenanceWindow property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * Sets the value of the PreferredBackupWindow property for this object.
         *
         * @param preferredBackupWindow
         *        The new value for the PreferredBackupWindow property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredBackupWindow(String preferredBackupWindow);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksCmRequest.BuilderImpl implements Builder {
        private Boolean disableAutomatedBackup;

        private Integer backupRetentionCount;

        private String serverName;

        private String preferredMaintenanceWindow;

        private String preferredBackupWindow;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServerRequest model) {
            super(model);
            disableAutomatedBackup(model.disableAutomatedBackup);
            backupRetentionCount(model.backupRetentionCount);
            serverName(model.serverName);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            preferredBackupWindow(model.preferredBackupWindow);
        }

        public final Boolean getDisableAutomatedBackup() {
            return disableAutomatedBackup;
        }

        public final void setDisableAutomatedBackup(Boolean disableAutomatedBackup) {
            this.disableAutomatedBackup = disableAutomatedBackup;
        }

        @Override
        public final Builder disableAutomatedBackup(Boolean disableAutomatedBackup) {
            this.disableAutomatedBackup = disableAutomatedBackup;
            return this;
        }

        public final Integer getBackupRetentionCount() {
            return backupRetentionCount;
        }

        public final void setBackupRetentionCount(Integer backupRetentionCount) {
            this.backupRetentionCount = backupRetentionCount;
        }

        @Override
        public final Builder backupRetentionCount(Integer backupRetentionCount) {
            this.backupRetentionCount = backupRetentionCount;
            return this;
        }

        public final String getServerName() {
            return serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final String getPreferredBackupWindow() {
            return preferredBackupWindow;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServerRequest build() {
            return new UpdateServerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
