/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opsworkscm.OpsWorksCmAsyncClient;
import software.amazon.awssdk.services.opsworkscm.model.DescribeServersRequest;
import software.amazon.awssdk.services.opsworkscm.model.DescribeServersResponse;
import software.amazon.awssdk.services.opsworkscm.model.Server;

public class DescribeServersPublisher
implements SdkPublisher<DescribeServersResponse> {
    private final OpsWorksCmAsyncClient client;
    private final DescribeServersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeServersPublisher(OpsWorksCmAsyncClient client, DescribeServersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeServersPublisher(OpsWorksCmAsyncClient client, DescribeServersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeServersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeServersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Server> servers() {
        Function<DescribeServersResponse, Iterator> getIterator = response -> {
            if (response != null && response.servers() != null) {
                return response.servers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeServersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeServersResponseFetcher
    implements AsyncPageFetcher<DescribeServersResponse> {
        private DescribeServersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeServersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeServersResponse> nextPage(DescribeServersResponse previousPage) {
            if (previousPage == null) {
                return DescribeServersPublisher.this.client.describeServers(DescribeServersPublisher.this.firstRequest);
            }
            return DescribeServersPublisher.this.client.describeServers((DescribeServersRequest)((Object)DescribeServersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

