/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateServerRequest extends OpsWorksCmRequest implements
        ToCopyableBuilder<CreateServerRequest.Builder, CreateServerRequest> {
    private static final SdkField<Boolean> ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).getter(getter(CreateServerRequest::associatePublicIpAddress))
            .setter(setter(Builder::associatePublicIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatePublicIpAddress").build())
            .build();

    private static final SdkField<String> CUSTOM_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServerRequest::customDomain)).setter(setter(Builder::customDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDomain").build()).build();

    private static final SdkField<String> CUSTOM_CERTIFICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServerRequest::customCertificate)).setter(setter(Builder::customCertificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomCertificate").build()).build();

    private static final SdkField<String> CUSTOM_PRIVATE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServerRequest::customPrivateKey)).setter(setter(Builder::customPrivateKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomPrivateKey").build()).build();

    private static final SdkField<Boolean> DISABLE_AUTOMATED_BACKUP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateServerRequest::disableAutomatedBackup)).setter(setter(Builder::disableAutomatedBackup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableAutomatedBackup").build())
            .build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServerRequest::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServerRequest::engineModel)).setter(setter(Builder::engineModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineModel").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServerRequest::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<List<EngineAttribute>> ENGINE_ATTRIBUTES_FIELD = SdkField
            .<List<EngineAttribute>> builder(MarshallingType.LIST)
            .getter(getter(CreateServerRequest::engineAttributes))
            .setter(setter(Builder::engineAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EngineAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(EngineAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> BACKUP_RETENTION_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateServerRequest::backupRetentionCount)).setter(setter(Builder::backupRetentionCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionCount").build())
            .build();

    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServerRequest::serverName)).setter(setter(Builder::serverName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()).build();

    private static final SdkField<String> INSTANCE_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServerRequest::instanceProfileArn)).setter(setter(Builder::instanceProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProfileArn").build())
            .build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServerRequest::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> KEY_PAIR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServerRequest::keyPair)).setter(setter(Builder::keyPair))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPair").build()).build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServerRequest::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServerRequest::preferredBackupWindow)).setter(setter(Builder::preferredBackupWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredBackupWindow").build())
            .build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateServerRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SERVICE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServerRequest::serviceRoleArn)).setter(setter(Builder::serviceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRoleArn").build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateServerRequest::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateServerRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> BACKUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServerRequest::backupId)).setter(setter(Builder::backupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD, CUSTOM_DOMAIN_FIELD, CUSTOM_CERTIFICATE_FIELD, CUSTOM_PRIVATE_KEY_FIELD,
            DISABLE_AUTOMATED_BACKUP_FIELD, ENGINE_FIELD, ENGINE_MODEL_FIELD, ENGINE_VERSION_FIELD, ENGINE_ATTRIBUTES_FIELD,
            BACKUP_RETENTION_COUNT_FIELD, SERVER_NAME_FIELD, INSTANCE_PROFILE_ARN_FIELD, INSTANCE_TYPE_FIELD, KEY_PAIR_FIELD,
            PREFERRED_MAINTENANCE_WINDOW_FIELD, PREFERRED_BACKUP_WINDOW_FIELD, SECURITY_GROUP_IDS_FIELD, SERVICE_ROLE_ARN_FIELD,
            SUBNET_IDS_FIELD, TAGS_FIELD, BACKUP_ID_FIELD));

    private final Boolean associatePublicIpAddress;

    private final String customDomain;

    private final String customCertificate;

    private final String customPrivateKey;

    private final Boolean disableAutomatedBackup;

    private final String engine;

    private final String engineModel;

    private final String engineVersion;

    private final List<EngineAttribute> engineAttributes;

    private final Integer backupRetentionCount;

    private final String serverName;

    private final String instanceProfileArn;

    private final String instanceType;

    private final String keyPair;

    private final String preferredMaintenanceWindow;

    private final String preferredBackupWindow;

    private final List<String> securityGroupIds;

    private final String serviceRoleArn;

    private final List<String> subnetIds;

    private final List<Tag> tags;

    private final String backupId;

    private CreateServerRequest(BuilderImpl builder) {
        super(builder);
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.customDomain = builder.customDomain;
        this.customCertificate = builder.customCertificate;
        this.customPrivateKey = builder.customPrivateKey;
        this.disableAutomatedBackup = builder.disableAutomatedBackup;
        this.engine = builder.engine;
        this.engineModel = builder.engineModel;
        this.engineVersion = builder.engineVersion;
        this.engineAttributes = builder.engineAttributes;
        this.backupRetentionCount = builder.backupRetentionCount;
        this.serverName = builder.serverName;
        this.instanceProfileArn = builder.instanceProfileArn;
        this.instanceType = builder.instanceType;
        this.keyPair = builder.keyPair;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.securityGroupIds = builder.securityGroupIds;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.subnetIds = builder.subnetIds;
        this.tags = builder.tags;
        this.backupId = builder.backupId;
    }

    /**
     * <p>
     * Associate a public IP address with a server that you are launching. Valid values are <code>true</code> or
     * <code>false</code>. The default value is <code>true</code>.
     * </p>
     * 
     * @return Associate a public IP address with a server that you are launching. Valid values are <code>true</code> or
     *         <code>false</code>. The default value is <code>true</code>.
     */
    public Boolean associatePublicIpAddress() {
        return associatePublicIpAddress;
    }

    /**
     * <p>
     * Supported on servers running Chef Automate 2. An optional public endpoint of a server, such as
     * <code>https://aws.my-company.com</code>. To access the server, create a CNAME DNS record in your preferred DNS
     * service that points the custom domain to the endpoint that is generated when the server is created (the value of
     * the CreateServer Endpoint attribute). You cannot access the server by using the generated <code>Endpoint</code>
     * value if the server is using a custom domain. If you specify a custom domain, you must also specify values for
     * <code>CustomCertificate</code> and <code>CustomPrivateKey</code>.
     * </p>
     * 
     * @return Supported on servers running Chef Automate 2. An optional public endpoint of a server, such as
     *         <code>https://aws.my-company.com</code>. To access the server, create a CNAME DNS record in your
     *         preferred DNS service that points the custom domain to the endpoint that is generated when the server is
     *         created (the value of the CreateServer Endpoint attribute). You cannot access the server by using the
     *         generated <code>Endpoint</code> value if the server is using a custom domain. If you specify a custom
     *         domain, you must also specify values for <code>CustomCertificate</code> and <code>CustomPrivateKey</code>
     *         .
     */
    public String customDomain() {
        return customDomain;
    }

    /**
     * <p>
     * Supported on servers running Chef Automate 2. A PEM-formatted HTTPS certificate. The value can be be a single,
     * self-signed certificate, or a certificate chain. If you specify a custom certificate, you must also specify
     * values for <code>CustomDomain</code> and <code>CustomPrivateKey</code>. The following are requirements for the
     * <code>CustomCertificate</code> value:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can provide either a self-signed, custom certificate, or the full certificate chain.
     * </p>
     * </li>
     * <li>
     * <p>
     * The certificate must be a valid X509 certificate, or a certificate chain in PEM format.
     * </p>
     * </li>
     * <li>
     * <p>
     * The certificate must be valid at the time of upload. A certificate can't be used before its validity period
     * begins (the certificate's <code>NotBefore</code> date), or after it expires (the certificate's
     * <code>NotAfter</code> date).
     * </p>
     * </li>
     * <li>
     * <p>
     * The certificate’s common name or subject alternative names (SANs), if present, must match the value of
     * <code>CustomDomain</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The certificate must match the value of <code>CustomPrivateKey</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Supported on servers running Chef Automate 2. A PEM-formatted HTTPS certificate. The value can be be a
     *         single, self-signed certificate, or a certificate chain. If you specify a custom certificate, you must
     *         also specify values for <code>CustomDomain</code> and <code>CustomPrivateKey</code>. The following are
     *         requirements for the <code>CustomCertificate</code> value:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You can provide either a self-signed, custom certificate, or the full certificate chain.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The certificate must be a valid X509 certificate, or a certificate chain in PEM format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The certificate must be valid at the time of upload. A certificate can't be used before its validity
     *         period begins (the certificate's <code>NotBefore</code> date), or after it expires (the certificate's
     *         <code>NotAfter</code> date).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The certificate’s common name or subject alternative names (SANs), if present, must match the value of
     *         <code>CustomDomain</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The certificate must match the value of <code>CustomPrivateKey</code>.
     *         </p>
     *         </li>
     */
    public String customCertificate() {
        return customCertificate;
    }

    /**
     * <p>
     * Supported on servers running Chef Automate 2. A private key in PEM format for connecting to the server by using
     * HTTPS. The private key must not be encrypted; it cannot be protected by a password or passphrase. If you specify
     * a custom private key, you must also specify values for <code>CustomDomain</code> and
     * <code>CustomCertificate</code>.
     * </p>
     * 
     * @return Supported on servers running Chef Automate 2. A private key in PEM format for connecting to the server by
     *         using HTTPS. The private key must not be encrypted; it cannot be protected by a password or passphrase.
     *         If you specify a custom private key, you must also specify values for <code>CustomDomain</code> and
     *         <code>CustomCertificate</code>.
     */
    public String customPrivateKey() {
        return customPrivateKey;
    }

    /**
     * <p>
     * Enable or disable scheduled backups. Valid values are <code>true</code> or <code>false</code>. The default value
     * is <code>true</code>.
     * </p>
     * 
     * @return Enable or disable scheduled backups. Valid values are <code>true</code> or <code>false</code>. The
     *         default value is <code>true</code>.
     */
    public Boolean disableAutomatedBackup() {
        return disableAutomatedBackup;
    }

    /**
     * <p>
     * The configuration management engine to use. Valid values include <code>ChefAutomate</code> and
     * <code>Puppet</code>.
     * </p>
     * 
     * @return The configuration management engine to use. Valid values include <code>ChefAutomate</code> and
     *         <code>Puppet</code>.
     */
    public String engine() {
        return engine;
    }

    /**
     * <p>
     * The engine model of the server. Valid values in this release include <code>Monolithic</code> for Puppet and
     * <code>Single</code> for Chef.
     * </p>
     * 
     * @return The engine model of the server. Valid values in this release include <code>Monolithic</code> for Puppet
     *         and <code>Single</code> for Chef.
     */
    public String engineModel() {
        return engineModel;
    }

    /**
     * <p>
     * The major release version of the engine that you want to use. For a Chef server, the valid value for
     * EngineVersion is currently <code>12</code>. For a Puppet server, the valid value is <code>2017</code>.
     * </p>
     * 
     * @return The major release version of the engine that you want to use. For a Chef server, the valid value for
     *         EngineVersion is currently <code>12</code>. For a Puppet server, the valid value is <code>2017</code>.
     */
    public String engineVersion() {
        return engineVersion;
    }

    /**
     * Returns true if the EngineAttributes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasEngineAttributes() {
        return engineAttributes != null && !(engineAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional engine attributes on a specified server.
     * </p>
     * <p class="title">
     * <b>Attributes accepted in a Chef createServer request:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CHEF_AUTOMATE_PIVOTAL_KEY</code>: A base64-encoded RSA public key. The corresponding private key is
     * required to access the Chef API. When no CHEF_AUTOMATE_PIVOTAL_KEY is set, a private key is generated and
     * returned in the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CHEF_AUTOMATE_ADMIN_PASSWORD</code>: The password for the administrative user in the Chef Automate
     * web-based dashboard. The password length is a minimum of eight characters, and a maximum of 32. The password can
     * contain letters, numbers, and special characters (!/@#$%^&amp;+=_). The password must contain at least one lower
     * case letter, one upper case letter, one number, and one special character. When no CHEF_AUTOMATE_ADMIN_PASSWORD
     * is set, one is generated and returned in the response.
     * </p>
     * </li>
     * </ul>
     * <p class="title">
     * <b>Attributes accepted in a Puppet createServer request:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PUPPET_ADMIN_PASSWORD</code>: To work with the Puppet Enterprise console, a password must use ASCII
     * characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PUPPET_R10K_REMOTE</code>: The r10k remote is the URL of your control repository (for example,
     * ssh://git@your.git-repo.com:user/control-repo.git). Specifying an r10k remote opens TCP port 8170.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PUPPET_R10K_PRIVATE_KEY</code>: If you are using a private Git repository, add PUPPET_R10K_PRIVATE_KEY to
     * specify a PEM-encoded private SSH key.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEngineAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Optional engine attributes on a specified server. </p>
     *         <p class="title">
     *         <b>Attributes accepted in a Chef createServer request:</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CHEF_AUTOMATE_PIVOTAL_KEY</code>: A base64-encoded RSA public key. The corresponding private key is
     *         required to access the Chef API. When no CHEF_AUTOMATE_PIVOTAL_KEY is set, a private key is generated and
     *         returned in the response.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CHEF_AUTOMATE_ADMIN_PASSWORD</code>: The password for the administrative user in the Chef Automate
     *         web-based dashboard. The password length is a minimum of eight characters, and a maximum of 32. The
     *         password can contain letters, numbers, and special characters (!/@#$%^&amp;+=_). The password must
     *         contain at least one lower case letter, one upper case letter, one number, and one special character.
     *         When no CHEF_AUTOMATE_ADMIN_PASSWORD is set, one is generated and returned in the response.
     *         </p>
     *         </li>
     *         </ul>
     *         <p class="title">
     *         <b>Attributes accepted in a Puppet createServer request:</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PUPPET_ADMIN_PASSWORD</code>: To work with the Puppet Enterprise console, a password must use ASCII
     *         characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PUPPET_R10K_REMOTE</code>: The r10k remote is the URL of your control repository (for example,
     *         ssh://git@your.git-repo.com:user/control-repo.git). Specifying an r10k remote opens TCP port 8170.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PUPPET_R10K_PRIVATE_KEY</code>: If you are using a private Git repository, add
     *         PUPPET_R10K_PRIVATE_KEY to specify a PEM-encoded private SSH key.
     *         </p>
     *         </li>
     */
    public List<EngineAttribute> engineAttributes() {
        return engineAttributes;
    }

    /**
     * <p>
     * The number of automated backups that you want to keep. Whenever a new backup is created, AWS OpsWorks CM deletes
     * the oldest backups if this number is exceeded. The default value is <code>1</code>.
     * </p>
     * 
     * @return The number of automated backups that you want to keep. Whenever a new backup is created, AWS OpsWorks CM
     *         deletes the oldest backups if this number is exceeded. The default value is <code>1</code>.
     */
    public Integer backupRetentionCount() {
        return backupRetentionCount;
    }

    /**
     * <p>
     * The name of the server. The server name must be unique within your AWS account, within each region. Server names
     * must start with a letter; then letters, numbers, or hyphens (-) are allowed, up to a maximum of 40 characters.
     * </p>
     * 
     * @return The name of the server. The server name must be unique within your AWS account, within each region.
     *         Server names must start with a letter; then letters, numbers, or hyphens (-) are allowed, up to a maximum
     *         of 40 characters.
     */
    public String serverName() {
        return serverName;
    }

    /**
     * <p>
     * The ARN of the instance profile that your Amazon EC2 instances use. Although the AWS OpsWorks console typically
     * creates the instance profile for you, if you are using API commands instead, run the service-role-creation.yaml
     * AWS CloudFormation template, located at
     * https://s3.amazonaws.com/opsworks-cm-us-east-1-prod-default-assets/misc/opsworks-cm-roles.yaml. This template
     * creates a CloudFormation stack that includes the instance profile you need.
     * </p>
     * 
     * @return The ARN of the instance profile that your Amazon EC2 instances use. Although the AWS OpsWorks console
     *         typically creates the instance profile for you, if you are using API commands instead, run the
     *         service-role-creation.yaml AWS CloudFormation template, located at
     *         https://s3.amazonaws.com/opsworks-cm-us-east-1-prod-default-assets/misc/opsworks-cm-roles.yaml. This
     *         template creates a CloudFormation stack that includes the instance profile you need.
     */
    public String instanceProfileArn() {
        return instanceProfileArn;
    }

    /**
     * <p>
     * The Amazon EC2 instance type to use. For example, <code>m5.large</code>.
     * </p>
     * 
     * @return The Amazon EC2 instance type to use. For example, <code>m5.large</code>.
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The Amazon EC2 key pair to set for the instance. This parameter is optional; if desired, you may specify this
     * parameter to connect to your instances by using SSH.
     * </p>
     * 
     * @return The Amazon EC2 key pair to set for the instance. This parameter is optional; if desired, you may specify
     *         this parameter to connect to your instances by using SSH.
     */
    public String keyPair() {
        return keyPair;
    }

    /**
     * <p>
     * The start time for a one-hour period each week during which AWS OpsWorks CM performs maintenance on the instance.
     * Valid values must be specified in the following format: <code>DDD:HH:MM</code>. The specified time is in
     * coordinated universal time (UTC). The default value is a random one-hour period on Tuesday, Wednesday, or Friday.
     * See <code>TimeWindowDefinition</code> for more information.
     * </p>
     * <p>
     * <b>Example:</b> <code>Mon:08:00</code>, which represents a start time of every Monday at 08:00 UTC. (8:00 a.m.)
     * </p>
     * 
     * @return The start time for a one-hour period each week during which AWS OpsWorks CM performs maintenance on the
     *         instance. Valid values must be specified in the following format: <code>DDD:HH:MM</code>. The specified
     *         time is in coordinated universal time (UTC). The default value is a random one-hour period on Tuesday,
     *         Wednesday, or Friday. See <code>TimeWindowDefinition</code> for more information. </p>
     *         <p>
     *         <b>Example:</b> <code>Mon:08:00</code>, which represents a start time of every Monday at 08:00 UTC. (8:00
     *         a.m.)
     */
    public String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * The start time for a one-hour period during which AWS OpsWorks CM backs up application-level data on your server
     * if automated backups are enabled. Valid values must be specified in one of the following formats:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HH:MM</code> for daily backups
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DDD:HH:MM</code> for weekly backups
     * </p>
     * </li>
     * </ul>
     * <p>
     * The specified time is in coordinated universal time (UTC). The default value is a random, daily start time.
     * </p>
     * <p>
     * <b>Example:</b> <code>08:00</code>, which represents a daily start time of 08:00 UTC.
     * </p>
     * <p>
     * <b>Example:</b> <code>Mon:08:00</code>, which represents a start time of every Monday at 08:00 UTC. (8:00 a.m.)
     * </p>
     * 
     * @return The start time for a one-hour period during which AWS OpsWorks CM backs up application-level data on your
     *         server if automated backups are enabled. Valid values must be specified in one of the following formats:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HH:MM</code> for daily backups
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DDD:HH:MM</code> for weekly backups
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The specified time is in coordinated universal time (UTC). The default value is a random, daily start
     *         time.
     *         </p>
     *         <p>
     *         <b>Example:</b> <code>08:00</code>, which represents a daily start time of 08:00 UTC.
     *         </p>
     *         <p>
     *         <b>Example:</b> <code>Mon:08:00</code>, which represents a start time of every Monday at 08:00 UTC. (8:00
     *         a.m.)
     */
    public String preferredBackupWindow() {
        return preferredBackupWindow;
    }

    /**
     * Returns true if the SecurityGroupIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of security group IDs to attach to the Amazon EC2 instance. If you add this parameter, the specified
     * security groups must be within the VPC that is specified by <code>SubnetIds</code>.
     * </p>
     * <p>
     * If you do not specify this parameter, AWS OpsWorks CM creates one new security group that uses TCP ports 22 and
     * 443, open to 0.0.0.0/0 (everyone).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of security group IDs to attach to the Amazon EC2 instance. If you add this parameter, the
     *         specified security groups must be within the VPC that is specified by <code>SubnetIds</code>. </p>
     *         <p>
     *         If you do not specify this parameter, AWS OpsWorks CM creates one new security group that uses TCP ports
     *         22 and 443, open to 0.0.0.0/0 (everyone).
     */
    public List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The service role that the AWS OpsWorks CM service backend uses to work with your account. Although the AWS
     * OpsWorks management console typically creates the service role for you, if you are using the AWS CLI or API
     * commands, run the service-role-creation.yaml AWS CloudFormation template, located at
     * https://s3.amazonaws.com/opsworks-cm-us-east-1-prod-default-assets/misc/opsworks-cm-roles.yaml. This template
     * creates a CloudFormation stack that includes the service role and instance profile that you need.
     * </p>
     * 
     * @return The service role that the AWS OpsWorks CM service backend uses to work with your account. Although the
     *         AWS OpsWorks management console typically creates the service role for you, if you are using the AWS CLI
     *         or API commands, run the service-role-creation.yaml AWS CloudFormation template, located at
     *         https://s3.amazonaws.com/opsworks-cm-us-east-1-prod-default-assets/misc/opsworks-cm-roles.yaml. This
     *         template creates a CloudFormation stack that includes the service role and instance profile that you
     *         need.
     */
    public String serviceRoleArn() {
        return serviceRoleArn;
    }

    /**
     * Returns true if the SubnetIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of subnets in which to launch the server EC2 instance.
     * </p>
     * <p>
     * Amazon EC2-Classic customers: This field is required. All servers must run within a VPC. The VPC must have
     * "Auto Assign Public IP" enabled.
     * </p>
     * <p>
     * EC2-VPC customers: This field is optional. If you do not specify subnet IDs, your EC2 instances are created in a
     * default subnet that is selected by Amazon EC2. If you specify subnet IDs, the VPC must have
     * "Auto Assign Public IP" enabled.
     * </p>
     * <p>
     * For more information about supported Amazon EC2 platforms, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported Platforms</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubnetIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of subnets in which to launch the server EC2 instance. </p>
     *         <p>
     *         Amazon EC2-Classic customers: This field is required. All servers must run within a VPC. The VPC must
     *         have "Auto Assign Public IP" enabled.
     *         </p>
     *         <p>
     *         EC2-VPC customers: This field is optional. If you do not specify subnet IDs, your EC2 instances are
     *         created in a default subnet that is selected by Amazon EC2. If you specify subnet IDs, the VPC must have
     *         "Auto Assign Public IP" enabled.
     *         </p>
     *         <p>
     *         For more information about supported Amazon EC2 platforms, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported
     *         Platforms</a>.
     */
    public List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A map that contains tag keys and tag values to attach to an AWS OpsWorks for Chef Automate or AWS OpsWorks for
     * Puppet Enterprise server.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The key cannot be empty.
     * </p>
     * </li>
     * <li>
     * <p>
     * The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or separators, or the
     * following special characters: <code>+ - = . _ : /</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * The value can be a maximum 255 characters, and contain only Unicode letters, numbers, or separators, or the
     * following special characters: <code>+ - = . _ : /</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Leading and trailing white spaces are trimmed from both the key and value.
     * </p>
     * </li>
     * <li>
     * <p>
     * A maximum of 50 user-applied tags is allowed for any AWS OpsWorks-CM server.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map that contains tag keys and tag values to attach to an AWS OpsWorks for Chef Automate or AWS
     *         OpsWorks for Puppet Enterprise server.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The key cannot be empty.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or separators,
     *         or the following special characters: <code>+ - = . _ : /</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The value can be a maximum 255 characters, and contain only Unicode letters, numbers, or separators, or
     *         the following special characters: <code>+ - = . _ : /</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Leading and trailing white spaces are trimmed from both the key and value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A maximum of 50 user-applied tags is allowed for any AWS OpsWorks-CM server.
     *         </p>
     *         </li>
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * If you specify this field, AWS OpsWorks CM creates the server by using the backup represented by BackupId.
     * </p>
     * 
     * @return If you specify this field, AWS OpsWorks CM creates the server by using the backup represented by
     *         BackupId.
     */
    public String backupId() {
        return backupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(associatePublicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(customDomain());
        hashCode = 31 * hashCode + Objects.hashCode(customCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(customPrivateKey());
        hashCode = 31 * hashCode + Objects.hashCode(disableAutomatedBackup());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineModel());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(engineAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(backupRetentionCount());
        hashCode = 31 * hashCode + Objects.hashCode(serverName());
        hashCode = 31 * hashCode + Objects.hashCode(instanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(keyPair());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(subnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(backupId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServerRequest)) {
            return false;
        }
        CreateServerRequest other = (CreateServerRequest) obj;
        return Objects.equals(associatePublicIpAddress(), other.associatePublicIpAddress())
                && Objects.equals(customDomain(), other.customDomain())
                && Objects.equals(customCertificate(), other.customCertificate())
                && Objects.equals(customPrivateKey(), other.customPrivateKey())
                && Objects.equals(disableAutomatedBackup(), other.disableAutomatedBackup())
                && Objects.equals(engine(), other.engine()) && Objects.equals(engineModel(), other.engineModel())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(engineAttributes(), other.engineAttributes())
                && Objects.equals(backupRetentionCount(), other.backupRetentionCount())
                && Objects.equals(serverName(), other.serverName())
                && Objects.equals(instanceProfileArn(), other.instanceProfileArn())
                && Objects.equals(instanceType(), other.instanceType()) && Objects.equals(keyPair(), other.keyPair())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(preferredBackupWindow(), other.preferredBackupWindow())
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(serviceRoleArn(), other.serviceRoleArn()) && Objects.equals(subnetIds(), other.subnetIds())
                && Objects.equals(tags(), other.tags()) && Objects.equals(backupId(), other.backupId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateServerRequest").add("AssociatePublicIpAddress", associatePublicIpAddress())
                .add("CustomDomain", customDomain()).add("CustomCertificate", customCertificate())
                .add("CustomPrivateKey", customPrivateKey() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DisableAutomatedBackup", disableAutomatedBackup()).add("Engine", engine())
                .add("EngineModel", engineModel()).add("EngineVersion", engineVersion())
                .add("EngineAttributes", engineAttributes()).add("BackupRetentionCount", backupRetentionCount())
                .add("ServerName", serverName()).add("InstanceProfileArn", instanceProfileArn())
                .add("InstanceType", instanceType()).add("KeyPair", keyPair())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow())
                .add("PreferredBackupWindow", preferredBackupWindow()).add("SecurityGroupIds", securityGroupIds())
                .add("ServiceRoleArn", serviceRoleArn()).add("SubnetIds", subnetIds()).add("Tags", tags())
                .add("BackupId", backupId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociatePublicIpAddress":
            return Optional.ofNullable(clazz.cast(associatePublicIpAddress()));
        case "CustomDomain":
            return Optional.ofNullable(clazz.cast(customDomain()));
        case "CustomCertificate":
            return Optional.ofNullable(clazz.cast(customCertificate()));
        case "CustomPrivateKey":
            return Optional.ofNullable(clazz.cast(customPrivateKey()));
        case "DisableAutomatedBackup":
            return Optional.ofNullable(clazz.cast(disableAutomatedBackup()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineModel":
            return Optional.ofNullable(clazz.cast(engineModel()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "EngineAttributes":
            return Optional.ofNullable(clazz.cast(engineAttributes()));
        case "BackupRetentionCount":
            return Optional.ofNullable(clazz.cast(backupRetentionCount()));
        case "ServerName":
            return Optional.ofNullable(clazz.cast(serverName()));
        case "InstanceProfileArn":
            return Optional.ofNullable(clazz.cast(instanceProfileArn()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "KeyPair":
            return Optional.ofNullable(clazz.cast(keyPair()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "PreferredBackupWindow":
            return Optional.ofNullable(clazz.cast(preferredBackupWindow()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "ServiceRoleArn":
            return Optional.ofNullable(clazz.cast(serviceRoleArn()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "BackupId":
            return Optional.ofNullable(clazz.cast(backupId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateServerRequest, T> g) {
        return obj -> g.apply((CreateServerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksCmRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateServerRequest> {
        /**
         * <p>
         * Associate a public IP address with a server that you are launching. Valid values are <code>true</code> or
         * <code>false</code>. The default value is <code>true</code>.
         * </p>
         * 
         * @param associatePublicIpAddress
         *        Associate a public IP address with a server that you are launching. Valid values are <code>true</code>
         *        or <code>false</code>. The default value is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatePublicIpAddress(Boolean associatePublicIpAddress);

        /**
         * <p>
         * Supported on servers running Chef Automate 2. An optional public endpoint of a server, such as
         * <code>https://aws.my-company.com</code>. To access the server, create a CNAME DNS record in your preferred
         * DNS service that points the custom domain to the endpoint that is generated when the server is created (the
         * value of the CreateServer Endpoint attribute). You cannot access the server by using the generated
         * <code>Endpoint</code> value if the server is using a custom domain. If you specify a custom domain, you must
         * also specify values for <code>CustomCertificate</code> and <code>CustomPrivateKey</code>.
         * </p>
         * 
         * @param customDomain
         *        Supported on servers running Chef Automate 2. An optional public endpoint of a server, such as
         *        <code>https://aws.my-company.com</code>. To access the server, create a CNAME DNS record in your
         *        preferred DNS service that points the custom domain to the endpoint that is generated when the server
         *        is created (the value of the CreateServer Endpoint attribute). You cannot access the server by using
         *        the generated <code>Endpoint</code> value if the server is using a custom domain. If you specify a
         *        custom domain, you must also specify values for <code>CustomCertificate</code> and
         *        <code>CustomPrivateKey</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomain(String customDomain);

        /**
         * <p>
         * Supported on servers running Chef Automate 2. A PEM-formatted HTTPS certificate. The value can be be a
         * single, self-signed certificate, or a certificate chain. If you specify a custom certificate, you must also
         * specify values for <code>CustomDomain</code> and <code>CustomPrivateKey</code>. The following are
         * requirements for the <code>CustomCertificate</code> value:
         * </p>
         * <ul>
         * <li>
         * <p>
         * You can provide either a self-signed, custom certificate, or the full certificate chain.
         * </p>
         * </li>
         * <li>
         * <p>
         * The certificate must be a valid X509 certificate, or a certificate chain in PEM format.
         * </p>
         * </li>
         * <li>
         * <p>
         * The certificate must be valid at the time of upload. A certificate can't be used before its validity period
         * begins (the certificate's <code>NotBefore</code> date), or after it expires (the certificate's
         * <code>NotAfter</code> date).
         * </p>
         * </li>
         * <li>
         * <p>
         * The certificate’s common name or subject alternative names (SANs), if present, must match the value of
         * <code>CustomDomain</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The certificate must match the value of <code>CustomPrivateKey</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param customCertificate
         *        Supported on servers running Chef Automate 2. A PEM-formatted HTTPS certificate. The value can be be a
         *        single, self-signed certificate, or a certificate chain. If you specify a custom certificate, you must
         *        also specify values for <code>CustomDomain</code> and <code>CustomPrivateKey</code>. The following are
         *        requirements for the <code>CustomCertificate</code> value:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        You can provide either a self-signed, custom certificate, or the full certificate chain.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The certificate must be a valid X509 certificate, or a certificate chain in PEM format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The certificate must be valid at the time of upload. A certificate can't be used before its validity
         *        period begins (the certificate's <code>NotBefore</code> date), or after it expires (the certificate's
         *        <code>NotAfter</code> date).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The certificate’s common name or subject alternative names (SANs), if present, must match the value of
         *        <code>CustomDomain</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The certificate must match the value of <code>CustomPrivateKey</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customCertificate(String customCertificate);

        /**
         * <p>
         * Supported on servers running Chef Automate 2. A private key in PEM format for connecting to the server by
         * using HTTPS. The private key must not be encrypted; it cannot be protected by a password or passphrase. If
         * you specify a custom private key, you must also specify values for <code>CustomDomain</code> and
         * <code>CustomCertificate</code>.
         * </p>
         * 
         * @param customPrivateKey
         *        Supported on servers running Chef Automate 2. A private key in PEM format for connecting to the server
         *        by using HTTPS. The private key must not be encrypted; it cannot be protected by a password or
         *        passphrase. If you specify a custom private key, you must also specify values for
         *        <code>CustomDomain</code> and <code>CustomCertificate</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customPrivateKey(String customPrivateKey);

        /**
         * <p>
         * Enable or disable scheduled backups. Valid values are <code>true</code> or <code>false</code>. The default
         * value is <code>true</code>.
         * </p>
         * 
         * @param disableAutomatedBackup
         *        Enable or disable scheduled backups. Valid values are <code>true</code> or <code>false</code>. The
         *        default value is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableAutomatedBackup(Boolean disableAutomatedBackup);

        /**
         * <p>
         * The configuration management engine to use. Valid values include <code>ChefAutomate</code> and
         * <code>Puppet</code>.
         * </p>
         * 
         * @param engine
         *        The configuration management engine to use. Valid values include <code>ChefAutomate</code> and
         *        <code>Puppet</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The engine model of the server. Valid values in this release include <code>Monolithic</code> for Puppet and
         * <code>Single</code> for Chef.
         * </p>
         * 
         * @param engineModel
         *        The engine model of the server. Valid values in this release include <code>Monolithic</code> for
         *        Puppet and <code>Single</code> for Chef.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineModel(String engineModel);

        /**
         * <p>
         * The major release version of the engine that you want to use. For a Chef server, the valid value for
         * EngineVersion is currently <code>12</code>. For a Puppet server, the valid value is <code>2017</code>.
         * </p>
         * 
         * @param engineVersion
         *        The major release version of the engine that you want to use. For a Chef server, the valid value for
         *        EngineVersion is currently <code>12</code>. For a Puppet server, the valid value is <code>2017</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * Optional engine attributes on a specified server.
         * </p>
         * <p class="title">
         * <b>Attributes accepted in a Chef createServer request:</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CHEF_AUTOMATE_PIVOTAL_KEY</code>: A base64-encoded RSA public key. The corresponding private key is
         * required to access the Chef API. When no CHEF_AUTOMATE_PIVOTAL_KEY is set, a private key is generated and
         * returned in the response.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CHEF_AUTOMATE_ADMIN_PASSWORD</code>: The password for the administrative user in the Chef Automate
         * web-based dashboard. The password length is a minimum of eight characters, and a maximum of 32. The password
         * can contain letters, numbers, and special characters (!/@#$%^&amp;+=_). The password must contain at least
         * one lower case letter, one upper case letter, one number, and one special character. When no
         * CHEF_AUTOMATE_ADMIN_PASSWORD is set, one is generated and returned in the response.
         * </p>
         * </li>
         * </ul>
         * <p class="title">
         * <b>Attributes accepted in a Puppet createServer request:</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PUPPET_ADMIN_PASSWORD</code>: To work with the Puppet Enterprise console, a password must use ASCII
         * characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PUPPET_R10K_REMOTE</code>: The r10k remote is the URL of your control repository (for example,
         * ssh://git@your.git-repo.com:user/control-repo.git). Specifying an r10k remote opens TCP port 8170.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PUPPET_R10K_PRIVATE_KEY</code>: If you are using a private Git repository, add PUPPET_R10K_PRIVATE_KEY
         * to specify a PEM-encoded private SSH key.
         * </p>
         * </li>
         * </ul>
         * 
         * @param engineAttributes
         *        Optional engine attributes on a specified server. </p>
         *        <p class="title">
         *        <b>Attributes accepted in a Chef createServer request:</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CHEF_AUTOMATE_PIVOTAL_KEY</code>: A base64-encoded RSA public key. The corresponding private key
         *        is required to access the Chef API. When no CHEF_AUTOMATE_PIVOTAL_KEY is set, a private key is
         *        generated and returned in the response.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CHEF_AUTOMATE_ADMIN_PASSWORD</code>: The password for the administrative user in the Chef
         *        Automate web-based dashboard. The password length is a minimum of eight characters, and a maximum of
         *        32. The password can contain letters, numbers, and special characters (!/@#$%^&amp;+=_). The password
         *        must contain at least one lower case letter, one upper case letter, one number, and one special
         *        character. When no CHEF_AUTOMATE_ADMIN_PASSWORD is set, one is generated and returned in the response.
         *        </p>
         *        </li>
         *        </ul>
         *        <p class="title">
         *        <b>Attributes accepted in a Puppet createServer request:</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PUPPET_ADMIN_PASSWORD</code>: To work with the Puppet Enterprise console, a password must use
         *        ASCII characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PUPPET_R10K_REMOTE</code>: The r10k remote is the URL of your control repository (for example,
         *        ssh://git@your.git-repo.com:user/control-repo.git). Specifying an r10k remote opens TCP port 8170.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PUPPET_R10K_PRIVATE_KEY</code>: If you are using a private Git repository, add
         *        PUPPET_R10K_PRIVATE_KEY to specify a PEM-encoded private SSH key.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineAttributes(Collection<EngineAttribute> engineAttributes);

        /**
         * <p>
         * Optional engine attributes on a specified server.
         * </p>
         * <p class="title">
         * <b>Attributes accepted in a Chef createServer request:</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CHEF_AUTOMATE_PIVOTAL_KEY</code>: A base64-encoded RSA public key. The corresponding private key is
         * required to access the Chef API. When no CHEF_AUTOMATE_PIVOTAL_KEY is set, a private key is generated and
         * returned in the response.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CHEF_AUTOMATE_ADMIN_PASSWORD</code>: The password for the administrative user in the Chef Automate
         * web-based dashboard. The password length is a minimum of eight characters, and a maximum of 32. The password
         * can contain letters, numbers, and special characters (!/@#$%^&amp;+=_). The password must contain at least
         * one lower case letter, one upper case letter, one number, and one special character. When no
         * CHEF_AUTOMATE_ADMIN_PASSWORD is set, one is generated and returned in the response.
         * </p>
         * </li>
         * </ul>
         * <p class="title">
         * <b>Attributes accepted in a Puppet createServer request:</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PUPPET_ADMIN_PASSWORD</code>: To work with the Puppet Enterprise console, a password must use ASCII
         * characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PUPPET_R10K_REMOTE</code>: The r10k remote is the URL of your control repository (for example,
         * ssh://git@your.git-repo.com:user/control-repo.git). Specifying an r10k remote opens TCP port 8170.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PUPPET_R10K_PRIVATE_KEY</code>: If you are using a private Git repository, add PUPPET_R10K_PRIVATE_KEY
         * to specify a PEM-encoded private SSH key.
         * </p>
         * </li>
         * </ul>
         * 
         * @param engineAttributes
         *        Optional engine attributes on a specified server. </p>
         *        <p class="title">
         *        <b>Attributes accepted in a Chef createServer request:</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CHEF_AUTOMATE_PIVOTAL_KEY</code>: A base64-encoded RSA public key. The corresponding private key
         *        is required to access the Chef API. When no CHEF_AUTOMATE_PIVOTAL_KEY is set, a private key is
         *        generated and returned in the response.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CHEF_AUTOMATE_ADMIN_PASSWORD</code>: The password for the administrative user in the Chef
         *        Automate web-based dashboard. The password length is a minimum of eight characters, and a maximum of
         *        32. The password can contain letters, numbers, and special characters (!/@#$%^&amp;+=_). The password
         *        must contain at least one lower case letter, one upper case letter, one number, and one special
         *        character. When no CHEF_AUTOMATE_ADMIN_PASSWORD is set, one is generated and returned in the response.
         *        </p>
         *        </li>
         *        </ul>
         *        <p class="title">
         *        <b>Attributes accepted in a Puppet createServer request:</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PUPPET_ADMIN_PASSWORD</code>: To work with the Puppet Enterprise console, a password must use
         *        ASCII characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PUPPET_R10K_REMOTE</code>: The r10k remote is the URL of your control repository (for example,
         *        ssh://git@your.git-repo.com:user/control-repo.git). Specifying an r10k remote opens TCP port 8170.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PUPPET_R10K_PRIVATE_KEY</code>: If you are using a private Git repository, add
         *        PUPPET_R10K_PRIVATE_KEY to specify a PEM-encoded private SSH key.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineAttributes(EngineAttribute... engineAttributes);

        /**
         * <p>
         * Optional engine attributes on a specified server.
         * </p>
         * <p class="title">
         * <b>Attributes accepted in a Chef createServer request:</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CHEF_AUTOMATE_PIVOTAL_KEY</code>: A base64-encoded RSA public key. The corresponding private key is
         * required to access the Chef API. When no CHEF_AUTOMATE_PIVOTAL_KEY is set, a private key is generated and
         * returned in the response.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CHEF_AUTOMATE_ADMIN_PASSWORD</code>: The password for the administrative user in the Chef Automate
         * web-based dashboard. The password length is a minimum of eight characters, and a maximum of 32. The password
         * can contain letters, numbers, and special characters (!/@#$%^&amp;+=_). The password must contain at least
         * one lower case letter, one upper case letter, one number, and one special character. When no
         * CHEF_AUTOMATE_ADMIN_PASSWORD is set, one is generated and returned in the response.
         * </p>
         * </li>
         * </ul>
         * <p class="title">
         * <b>Attributes accepted in a Puppet createServer request:</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PUPPET_ADMIN_PASSWORD</code>: To work with the Puppet Enterprise console, a password must use ASCII
         * characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PUPPET_R10K_REMOTE</code>: The r10k remote is the URL of your control repository (for example,
         * ssh://git@your.git-repo.com:user/control-repo.git). Specifying an r10k remote opens TCP port 8170.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PUPPET_R10K_PRIVATE_KEY</code>: If you are using a private Git repository, add PUPPET_R10K_PRIVATE_KEY
         * to specify a PEM-encoded private SSH key.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<EngineAttribute>.Builder} avoiding the need
         * to create one manually via {@link List<EngineAttribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EngineAttribute>.Builder#build()} is called immediately and
         * its result is passed to {@link #engineAttributes(List<EngineAttribute>)}.
         * 
         * @param engineAttributes
         *        a consumer that will call methods on {@link List<EngineAttribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #engineAttributes(List<EngineAttribute>)
         */
        Builder engineAttributes(Consumer<EngineAttribute.Builder>... engineAttributes);

        /**
         * <p>
         * The number of automated backups that you want to keep. Whenever a new backup is created, AWS OpsWorks CM
         * deletes the oldest backups if this number is exceeded. The default value is <code>1</code>.
         * </p>
         * 
         * @param backupRetentionCount
         *        The number of automated backups that you want to keep. Whenever a new backup is created, AWS OpsWorks
         *        CM deletes the oldest backups if this number is exceeded. The default value is <code>1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRetentionCount(Integer backupRetentionCount);

        /**
         * <p>
         * The name of the server. The server name must be unique within your AWS account, within each region. Server
         * names must start with a letter; then letters, numbers, or hyphens (-) are allowed, up to a maximum of 40
         * characters.
         * </p>
         * 
         * @param serverName
         *        The name of the server. The server name must be unique within your AWS account, within each region.
         *        Server names must start with a letter; then letters, numbers, or hyphens (-) are allowed, up to a
         *        maximum of 40 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverName(String serverName);

        /**
         * <p>
         * The ARN of the instance profile that your Amazon EC2 instances use. Although the AWS OpsWorks console
         * typically creates the instance profile for you, if you are using API commands instead, run the
         * service-role-creation.yaml AWS CloudFormation template, located at
         * https://s3.amazonaws.com/opsworks-cm-us-east-1-prod-default-assets/misc/opsworks-cm-roles.yaml. This template
         * creates a CloudFormation stack that includes the instance profile you need.
         * </p>
         * 
         * @param instanceProfileArn
         *        The ARN of the instance profile that your Amazon EC2 instances use. Although the AWS OpsWorks console
         *        typically creates the instance profile for you, if you are using API commands instead, run the
         *        service-role-creation.yaml AWS CloudFormation template, located at
         *        https://s3.amazonaws.com/opsworks-cm-us-east-1-prod-default-assets/misc/opsworks-cm-roles.yaml. This
         *        template creates a CloudFormation stack that includes the instance profile you need.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceProfileArn(String instanceProfileArn);

        /**
         * <p>
         * The Amazon EC2 instance type to use. For example, <code>m5.large</code>.
         * </p>
         * 
         * @param instanceType
         *        The Amazon EC2 instance type to use. For example, <code>m5.large</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The Amazon EC2 key pair to set for the instance. This parameter is optional; if desired, you may specify this
         * parameter to connect to your instances by using SSH.
         * </p>
         * 
         * @param keyPair
         *        The Amazon EC2 key pair to set for the instance. This parameter is optional; if desired, you may
         *        specify this parameter to connect to your instances by using SSH.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPair(String keyPair);

        /**
         * <p>
         * The start time for a one-hour period each week during which AWS OpsWorks CM performs maintenance on the
         * instance. Valid values must be specified in the following format: <code>DDD:HH:MM</code>. The specified time
         * is in coordinated universal time (UTC). The default value is a random one-hour period on Tuesday, Wednesday,
         * or Friday. See <code>TimeWindowDefinition</code> for more information.
         * </p>
         * <p>
         * <b>Example:</b> <code>Mon:08:00</code>, which represents a start time of every Monday at 08:00 UTC. (8:00
         * a.m.)
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        The start time for a one-hour period each week during which AWS OpsWorks CM performs maintenance on
         *        the instance. Valid values must be specified in the following format: <code>DDD:HH:MM</code>. The
         *        specified time is in coordinated universal time (UTC). The default value is a random one-hour period
         *        on Tuesday, Wednesday, or Friday. See <code>TimeWindowDefinition</code> for more information. </p>
         *        <p>
         *        <b>Example:</b> <code>Mon:08:00</code>, which represents a start time of every Monday at 08:00 UTC.
         *        (8:00 a.m.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * The start time for a one-hour period during which AWS OpsWorks CM backs up application-level data on your
         * server if automated backups are enabled. Valid values must be specified in one of the following formats:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HH:MM</code> for daily backups
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DDD:HH:MM</code> for weekly backups
         * </p>
         * </li>
         * </ul>
         * <p>
         * The specified time is in coordinated universal time (UTC). The default value is a random, daily start time.
         * </p>
         * <p>
         * <b>Example:</b> <code>08:00</code>, which represents a daily start time of 08:00 UTC.
         * </p>
         * <p>
         * <b>Example:</b> <code>Mon:08:00</code>, which represents a start time of every Monday at 08:00 UTC. (8:00
         * a.m.)
         * </p>
         * 
         * @param preferredBackupWindow
         *        The start time for a one-hour period during which AWS OpsWorks CM backs up application-level data on
         *        your server if automated backups are enabled. Valid values must be specified in one of the following
         *        formats: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HH:MM</code> for daily backups
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DDD:HH:MM</code> for weekly backups
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The specified time is in coordinated universal time (UTC). The default value is a random, daily start
         *        time.
         *        </p>
         *        <p>
         *        <b>Example:</b> <code>08:00</code>, which represents a daily start time of 08:00 UTC.
         *        </p>
         *        <p>
         *        <b>Example:</b> <code>Mon:08:00</code>, which represents a start time of every Monday at 08:00 UTC.
         *        (8:00 a.m.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredBackupWindow(String preferredBackupWindow);

        /**
         * <p>
         * A list of security group IDs to attach to the Amazon EC2 instance. If you add this parameter, the specified
         * security groups must be within the VPC that is specified by <code>SubnetIds</code>.
         * </p>
         * <p>
         * If you do not specify this parameter, AWS OpsWorks CM creates one new security group that uses TCP ports 22
         * and 443, open to 0.0.0.0/0 (everyone).
         * </p>
         * 
         * @param securityGroupIds
         *        A list of security group IDs to attach to the Amazon EC2 instance. If you add this parameter, the
         *        specified security groups must be within the VPC that is specified by <code>SubnetIds</code>. </p>
         *        <p>
         *        If you do not specify this parameter, AWS OpsWorks CM creates one new security group that uses TCP
         *        ports 22 and 443, open to 0.0.0.0/0 (everyone).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * A list of security group IDs to attach to the Amazon EC2 instance. If you add this parameter, the specified
         * security groups must be within the VPC that is specified by <code>SubnetIds</code>.
         * </p>
         * <p>
         * If you do not specify this parameter, AWS OpsWorks CM creates one new security group that uses TCP ports 22
         * and 443, open to 0.0.0.0/0 (everyone).
         * </p>
         * 
         * @param securityGroupIds
         *        A list of security group IDs to attach to the Amazon EC2 instance. If you add this parameter, the
         *        specified security groups must be within the VPC that is specified by <code>SubnetIds</code>. </p>
         *        <p>
         *        If you do not specify this parameter, AWS OpsWorks CM creates one new security group that uses TCP
         *        ports 22 and 443, open to 0.0.0.0/0 (everyone).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The service role that the AWS OpsWorks CM service backend uses to work with your account. Although the AWS
         * OpsWorks management console typically creates the service role for you, if you are using the AWS CLI or API
         * commands, run the service-role-creation.yaml AWS CloudFormation template, located at
         * https://s3.amazonaws.com/opsworks-cm-us-east-1-prod-default-assets/misc/opsworks-cm-roles.yaml. This template
         * creates a CloudFormation stack that includes the service role and instance profile that you need.
         * </p>
         * 
         * @param serviceRoleArn
         *        The service role that the AWS OpsWorks CM service backend uses to work with your account. Although the
         *        AWS OpsWorks management console typically creates the service role for you, if you are using the AWS
         *        CLI or API commands, run the service-role-creation.yaml AWS CloudFormation template, located at
         *        https://s3.amazonaws.com/opsworks-cm-us-east-1-prod-default-assets/misc/opsworks-cm-roles.yaml. This
         *        template creates a CloudFormation stack that includes the service role and instance profile that you
         *        need.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRoleArn(String serviceRoleArn);

        /**
         * <p>
         * The IDs of subnets in which to launch the server EC2 instance.
         * </p>
         * <p>
         * Amazon EC2-Classic customers: This field is required. All servers must run within a VPC. The VPC must have
         * "Auto Assign Public IP" enabled.
         * </p>
         * <p>
         * EC2-VPC customers: This field is optional. If you do not specify subnet IDs, your EC2 instances are created
         * in a default subnet that is selected by Amazon EC2. If you specify subnet IDs, the VPC must have
         * "Auto Assign Public IP" enabled.
         * </p>
         * <p>
         * For more information about supported Amazon EC2 platforms, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported
         * Platforms</a>.
         * </p>
         * 
         * @param subnetIds
         *        The IDs of subnets in which to launch the server EC2 instance. </p>
         *        <p>
         *        Amazon EC2-Classic customers: This field is required. All servers must run within a VPC. The VPC must
         *        have "Auto Assign Public IP" enabled.
         *        </p>
         *        <p>
         *        EC2-VPC customers: This field is optional. If you do not specify subnet IDs, your EC2 instances are
         *        created in a default subnet that is selected by Amazon EC2. If you specify subnet IDs, the VPC must
         *        have "Auto Assign Public IP" enabled.
         *        </p>
         *        <p>
         *        For more information about supported Amazon EC2 platforms, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported
         *        Platforms</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The IDs of subnets in which to launch the server EC2 instance.
         * </p>
         * <p>
         * Amazon EC2-Classic customers: This field is required. All servers must run within a VPC. The VPC must have
         * "Auto Assign Public IP" enabled.
         * </p>
         * <p>
         * EC2-VPC customers: This field is optional. If you do not specify subnet IDs, your EC2 instances are created
         * in a default subnet that is selected by Amazon EC2. If you specify subnet IDs, the VPC must have
         * "Auto Assign Public IP" enabled.
         * </p>
         * <p>
         * For more information about supported Amazon EC2 platforms, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported
         * Platforms</a>.
         * </p>
         * 
         * @param subnetIds
         *        The IDs of subnets in which to launch the server EC2 instance. </p>
         *        <p>
         *        Amazon EC2-Classic customers: This field is required. All servers must run within a VPC. The VPC must
         *        have "Auto Assign Public IP" enabled.
         *        </p>
         *        <p>
         *        EC2-VPC customers: This field is optional. If you do not specify subnet IDs, your EC2 instances are
         *        created in a default subnet that is selected by Amazon EC2. If you specify subnet IDs, the VPC must
         *        have "Auto Assign Public IP" enabled.
         *        </p>
         *        <p>
         *        For more information about supported Amazon EC2 platforms, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported
         *        Platforms</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * A map that contains tag keys and tag values to attach to an AWS OpsWorks for Chef Automate or AWS OpsWorks
         * for Puppet Enterprise server.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The key cannot be empty.
         * </p>
         * </li>
         * <li>
         * <p>
         * The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or separators, or
         * the following special characters: <code>+ - = . _ : /</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * The value can be a maximum 255 characters, and contain only Unicode letters, numbers, or separators, or the
         * following special characters: <code>+ - = . _ : /</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Leading and trailing white spaces are trimmed from both the key and value.
         * </p>
         * </li>
         * <li>
         * <p>
         * A maximum of 50 user-applied tags is allowed for any AWS OpsWorks-CM server.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        A map that contains tag keys and tag values to attach to an AWS OpsWorks for Chef Automate or AWS
         *        OpsWorks for Puppet Enterprise server.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The key cannot be empty.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or
         *        separators, or the following special characters: <code>+ - = . _ : /</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The value can be a maximum 255 characters, and contain only Unicode letters, numbers, or separators,
         *        or the following special characters: <code>+ - = . _ : /</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Leading and trailing white spaces are trimmed from both the key and value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A maximum of 50 user-applied tags is allowed for any AWS OpsWorks-CM server.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A map that contains tag keys and tag values to attach to an AWS OpsWorks for Chef Automate or AWS OpsWorks
         * for Puppet Enterprise server.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The key cannot be empty.
         * </p>
         * </li>
         * <li>
         * <p>
         * The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or separators, or
         * the following special characters: <code>+ - = . _ : /</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * The value can be a maximum 255 characters, and contain only Unicode letters, numbers, or separators, or the
         * following special characters: <code>+ - = . _ : /</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Leading and trailing white spaces are trimmed from both the key and value.
         * </p>
         * </li>
         * <li>
         * <p>
         * A maximum of 50 user-applied tags is allowed for any AWS OpsWorks-CM server.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        A map that contains tag keys and tag values to attach to an AWS OpsWorks for Chef Automate or AWS
         *        OpsWorks for Puppet Enterprise server.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The key cannot be empty.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or
         *        separators, or the following special characters: <code>+ - = . _ : /</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The value can be a maximum 255 characters, and contain only Unicode letters, numbers, or separators,
         *        or the following special characters: <code>+ - = . _ : /</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Leading and trailing white spaces are trimmed from both the key and value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A maximum of 50 user-applied tags is allowed for any AWS OpsWorks-CM server.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A map that contains tag keys and tag values to attach to an AWS OpsWorks for Chef Automate or AWS OpsWorks
         * for Puppet Enterprise server.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The key cannot be empty.
         * </p>
         * </li>
         * <li>
         * <p>
         * The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or separators, or
         * the following special characters: <code>+ - = . _ : /</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * The value can be a maximum 255 characters, and contain only Unicode letters, numbers, or separators, or the
         * following special characters: <code>+ - = . _ : /</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Leading and trailing white spaces are trimmed from both the key and value.
         * </p>
         * </li>
         * <li>
         * <p>
         * A maximum of 50 user-applied tags is allowed for any AWS OpsWorks-CM server.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * If you specify this field, AWS OpsWorks CM creates the server by using the backup represented by BackupId.
         * </p>
         * 
         * @param backupId
         *        If you specify this field, AWS OpsWorks CM creates the server by using the backup represented by
         *        BackupId.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupId(String backupId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksCmRequest.BuilderImpl implements Builder {
        private Boolean associatePublicIpAddress;

        private String customDomain;

        private String customCertificate;

        private String customPrivateKey;

        private Boolean disableAutomatedBackup;

        private String engine;

        private String engineModel;

        private String engineVersion;

        private List<EngineAttribute> engineAttributes = DefaultSdkAutoConstructList.getInstance();

        private Integer backupRetentionCount;

        private String serverName;

        private String instanceProfileArn;

        private String instanceType;

        private String keyPair;

        private String preferredMaintenanceWindow;

        private String preferredBackupWindow;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String serviceRoleArn;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String backupId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServerRequest model) {
            super(model);
            associatePublicIpAddress(model.associatePublicIpAddress);
            customDomain(model.customDomain);
            customCertificate(model.customCertificate);
            customPrivateKey(model.customPrivateKey);
            disableAutomatedBackup(model.disableAutomatedBackup);
            engine(model.engine);
            engineModel(model.engineModel);
            engineVersion(model.engineVersion);
            engineAttributes(model.engineAttributes);
            backupRetentionCount(model.backupRetentionCount);
            serverName(model.serverName);
            instanceProfileArn(model.instanceProfileArn);
            instanceType(model.instanceType);
            keyPair(model.keyPair);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            preferredBackupWindow(model.preferredBackupWindow);
            securityGroupIds(model.securityGroupIds);
            serviceRoleArn(model.serviceRoleArn);
            subnetIds(model.subnetIds);
            tags(model.tags);
            backupId(model.backupId);
        }

        public final Boolean getAssociatePublicIpAddress() {
            return associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        public final String getCustomDomain() {
            return customDomain;
        }

        @Override
        public final Builder customDomain(String customDomain) {
            this.customDomain = customDomain;
            return this;
        }

        public final void setCustomDomain(String customDomain) {
            this.customDomain = customDomain;
        }

        public final String getCustomCertificate() {
            return customCertificate;
        }

        @Override
        public final Builder customCertificate(String customCertificate) {
            this.customCertificate = customCertificate;
            return this;
        }

        public final void setCustomCertificate(String customCertificate) {
            this.customCertificate = customCertificate;
        }

        public final String getCustomPrivateKey() {
            return customPrivateKey;
        }

        @Override
        public final Builder customPrivateKey(String customPrivateKey) {
            this.customPrivateKey = customPrivateKey;
            return this;
        }

        public final void setCustomPrivateKey(String customPrivateKey) {
            this.customPrivateKey = customPrivateKey;
        }

        public final Boolean getDisableAutomatedBackup() {
            return disableAutomatedBackup;
        }

        @Override
        public final Builder disableAutomatedBackup(Boolean disableAutomatedBackup) {
            this.disableAutomatedBackup = disableAutomatedBackup;
            return this;
        }

        public final void setDisableAutomatedBackup(Boolean disableAutomatedBackup) {
            this.disableAutomatedBackup = disableAutomatedBackup;
        }

        public final String getEngine() {
            return engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineModel() {
            return engineModel;
        }

        @Override
        public final Builder engineModel(String engineModel) {
            this.engineModel = engineModel;
            return this;
        }

        public final void setEngineModel(String engineModel) {
            this.engineModel = engineModel;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Collection<EngineAttribute.Builder> getEngineAttributes() {
            return engineAttributes != null ? engineAttributes.stream().map(EngineAttribute::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder engineAttributes(Collection<EngineAttribute> engineAttributes) {
            this.engineAttributes = EngineAttributesCopier.copy(engineAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineAttributes(EngineAttribute... engineAttributes) {
            engineAttributes(Arrays.asList(engineAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineAttributes(Consumer<EngineAttribute.Builder>... engineAttributes) {
            engineAttributes(Stream.of(engineAttributes).map(c -> EngineAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEngineAttributes(Collection<EngineAttribute.BuilderImpl> engineAttributes) {
            this.engineAttributes = EngineAttributesCopier.copyFromBuilder(engineAttributes);
        }

        public final Integer getBackupRetentionCount() {
            return backupRetentionCount;
        }

        @Override
        public final Builder backupRetentionCount(Integer backupRetentionCount) {
            this.backupRetentionCount = backupRetentionCount;
            return this;
        }

        public final void setBackupRetentionCount(Integer backupRetentionCount) {
            this.backupRetentionCount = backupRetentionCount;
        }

        public final String getServerName() {
            return serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final String getInstanceProfileArn() {
            return instanceProfileArn;
        }

        @Override
        public final Builder instanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
            return this;
        }

        public final void setInstanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKeyPair() {
            return keyPair;
        }

        @Override
        public final Builder keyPair(String keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public final void setKeyPair(String keyPair) {
            this.keyPair = keyPair;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final String getPreferredBackupWindow() {
            return preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        public final Collection<String> getSecurityGroupIds() {
            return securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringsCopier.copy(securityGroupIds);
        }

        public final String getServiceRoleArn() {
            return serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final Collection<String> getSubnetIds() {
            return subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringsCopier.copy(subnetIds);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getBackupId() {
            return backupId;
        }

        @Override
        public final Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        public final void setBackupId(String backupId) {
            this.backupId = backupId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServerRequest build() {
            return new CreateServerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
