/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworkscm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a single backup.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Backup implements SdkPojo, Serializable, ToCopyableBuilder<Backup.Builder, Backup> {
    private static final SdkField<String> BACKUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Backup::backupArn)).setter(setter(Builder::backupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupArn").build()).build();

    private static final SdkField<String> BACKUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Backup::backupId)).setter(setter(Builder::backupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupId").build()).build();

    private static final SdkField<String> BACKUP_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Backup::backupTypeAsString)).setter(setter(Builder::backupType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupType").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Backup::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Backup::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Backup::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Backup::engineModel)).setter(setter(Builder::engineModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineModel").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Backup::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> INSTANCE_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Backup::instanceProfileArn)).setter(setter(Builder::instanceProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProfileArn").build())
            .build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Backup::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> KEY_PAIR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Backup::keyPair)).setter(setter(Builder::keyPair))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPair").build()).build();

    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Backup::preferredBackupWindow)).setter(setter(Builder::preferredBackupWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredBackupWindow").build())
            .build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Backup::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<Integer> S3_DATA_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Backup::s3DataSize)).setter(setter(Builder::s3DataSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DataSize").build()).build();

    private static final SdkField<String> S3_DATA_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Backup::s3DataUrl)).setter(setter(Builder::s3DataUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DataUrl").build()).build();

    private static final SdkField<String> S3_LOG_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Backup::s3LogUrl)).setter(setter(Builder::s3LogUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3LogUrl").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Backup::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Backup::serverName)).setter(setter(Builder::serverName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()).build();

    private static final SdkField<String> SERVICE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Backup::serviceRoleArn)).setter(setter(Builder::serviceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRoleArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Backup::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Backup::statusDescription)).setter(setter(Builder::statusDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDescription").build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Backup::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TOOLS_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Backup::toolsVersion)).setter(setter(Builder::toolsVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToolsVersion").build()).build();

    private static final SdkField<String> USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Backup::userArn)).setter(setter(Builder::userArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_ARN_FIELD,
            BACKUP_ID_FIELD, BACKUP_TYPE_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, ENGINE_FIELD, ENGINE_MODEL_FIELD,
            ENGINE_VERSION_FIELD, INSTANCE_PROFILE_ARN_FIELD, INSTANCE_TYPE_FIELD, KEY_PAIR_FIELD, PREFERRED_BACKUP_WINDOW_FIELD,
            PREFERRED_MAINTENANCE_WINDOW_FIELD, S3_DATA_SIZE_FIELD, S3_DATA_URL_FIELD, S3_LOG_URL_FIELD,
            SECURITY_GROUP_IDS_FIELD, SERVER_NAME_FIELD, SERVICE_ROLE_ARN_FIELD, STATUS_FIELD, STATUS_DESCRIPTION_FIELD,
            SUBNET_IDS_FIELD, TOOLS_VERSION_FIELD, USER_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String backupArn;

    private final String backupId;

    private final String backupType;

    private final Instant createdAt;

    private final String description;

    private final String engine;

    private final String engineModel;

    private final String engineVersion;

    private final String instanceProfileArn;

    private final String instanceType;

    private final String keyPair;

    private final String preferredBackupWindow;

    private final String preferredMaintenanceWindow;

    private final Integer s3DataSize;

    private final String s3DataUrl;

    private final String s3LogUrl;

    private final List<String> securityGroupIds;

    private final String serverName;

    private final String serviceRoleArn;

    private final String status;

    private final String statusDescription;

    private final List<String> subnetIds;

    private final String toolsVersion;

    private final String userArn;

    private Backup(BuilderImpl builder) {
        this.backupArn = builder.backupArn;
        this.backupId = builder.backupId;
        this.backupType = builder.backupType;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.engine = builder.engine;
        this.engineModel = builder.engineModel;
        this.engineVersion = builder.engineVersion;
        this.instanceProfileArn = builder.instanceProfileArn;
        this.instanceType = builder.instanceType;
        this.keyPair = builder.keyPair;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.s3DataSize = builder.s3DataSize;
        this.s3DataUrl = builder.s3DataUrl;
        this.s3LogUrl = builder.s3LogUrl;
        this.securityGroupIds = builder.securityGroupIds;
        this.serverName = builder.serverName;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.status = builder.status;
        this.statusDescription = builder.statusDescription;
        this.subnetIds = builder.subnetIds;
        this.toolsVersion = builder.toolsVersion;
        this.userArn = builder.userArn;
    }

    /**
     * <p>
     * The ARN of the backup.
     * </p>
     * 
     * @return The ARN of the backup.
     */
    public String backupArn() {
        return backupArn;
    }

    /**
     * <p>
     * The generated ID of the backup. Example: <code>myServerName-yyyyMMddHHmmssSSS</code>
     * </p>
     * 
     * @return The generated ID of the backup. Example: <code>myServerName-yyyyMMddHHmmssSSS</code>
     */
    public String backupId() {
        return backupId;
    }

    /**
     * <p>
     * The backup type. Valid values are <code>automated</code> or <code>manual</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #backupType} will
     * return {@link BackupType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #backupTypeAsString}.
     * </p>
     * 
     * @return The backup type. Valid values are <code>automated</code> or <code>manual</code>.
     * @see BackupType
     */
    public BackupType backupType() {
        return BackupType.fromValue(backupType);
    }

    /**
     * <p>
     * The backup type. Valid values are <code>automated</code> or <code>manual</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #backupType} will
     * return {@link BackupType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #backupTypeAsString}.
     * </p>
     * 
     * @return The backup type. Valid values are <code>automated</code> or <code>manual</code>.
     * @see BackupType
     */
    public String backupTypeAsString() {
        return backupType;
    }

    /**
     * <p>
     * The time stamp when the backup was created in the database. Example: <code>2016-07-29T13:38:47.520Z</code>
     * </p>
     * 
     * @return The time stamp when the backup was created in the database. Example:
     *         <code>2016-07-29T13:38:47.520Z</code>
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * A user-provided description for a manual backup. This field is empty for automated backups.
     * </p>
     * 
     * @return A user-provided description for a manual backup. This field is empty for automated backups.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The engine type that is obtained from the server when the backup is created.
     * </p>
     * 
     * @return The engine type that is obtained from the server when the backup is created.
     */
    public String engine() {
        return engine;
    }

    /**
     * <p>
     * The engine model that is obtained from the server when the backup is created.
     * </p>
     * 
     * @return The engine model that is obtained from the server when the backup is created.
     */
    public String engineModel() {
        return engineModel;
    }

    /**
     * <p>
     * The engine version that is obtained from the server when the backup is created.
     * </p>
     * 
     * @return The engine version that is obtained from the server when the backup is created.
     */
    public String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The EC2 instance profile ARN that is obtained from the server when the backup is created. Because this value is
     * stored, you are not required to provide the InstanceProfileArn again if you restore a backup.
     * </p>
     * 
     * @return The EC2 instance profile ARN that is obtained from the server when the backup is created. Because this
     *         value is stored, you are not required to provide the InstanceProfileArn again if you restore a backup.
     */
    public String instanceProfileArn() {
        return instanceProfileArn;
    }

    /**
     * <p>
     * The instance type that is obtained from the server when the backup is created.
     * </p>
     * 
     * @return The instance type that is obtained from the server when the backup is created.
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The key pair that is obtained from the server when the backup is created.
     * </p>
     * 
     * @return The key pair that is obtained from the server when the backup is created.
     */
    public String keyPair() {
        return keyPair;
    }

    /**
     * <p>
     * The preferred backup period that is obtained from the server when the backup is created.
     * </p>
     * 
     * @return The preferred backup period that is obtained from the server when the backup is created.
     */
    public String preferredBackupWindow() {
        return preferredBackupWindow;
    }

    /**
     * <p>
     * The preferred maintenance period that is obtained from the server when the backup is created.
     * </p>
     * 
     * @return The preferred maintenance period that is obtained from the server when the backup is created.
     */
    public String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * This field is deprecated and is no longer used.
     * </p>
     * 
     * @return This field is deprecated and is no longer used.
     */
    public Integer s3DataSize() {
        return s3DataSize;
    }

    /**
     * <p>
     * This field is deprecated and is no longer used.
     * </p>
     * 
     * @return This field is deprecated and is no longer used.
     */
    public String s3DataUrl() {
        return s3DataUrl;
    }

    /**
     * <p>
     * The Amazon S3 URL of the backup's log file.
     * </p>
     * 
     * @return The Amazon S3 URL of the backup's log file.
     */
    public String s3LogUrl() {
        return s3LogUrl;
    }

    /**
     * Returns true if the SecurityGroupIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security group IDs that are obtained from the server when the backup is created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The security group IDs that are obtained from the server when the backup is created.
     */
    public List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The name of the server from which the backup was made.
     * </p>
     * 
     * @return The name of the server from which the backup was made.
     */
    public String serverName() {
        return serverName;
    }

    /**
     * <p>
     * The service role ARN that is obtained from the server when the backup is created.
     * </p>
     * 
     * @return The service role ARN that is obtained from the server when the backup is created.
     */
    public String serviceRoleArn() {
        return serviceRoleArn;
    }

    /**
     * <p>
     * The status of a backup while in progress.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BackupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a backup while in progress.
     * @see BackupStatus
     */
    public BackupStatus status() {
        return BackupStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of a backup while in progress.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BackupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a backup while in progress.
     * @see BackupStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * An informational message about backup status.
     * </p>
     * 
     * @return An informational message about backup status.
     */
    public String statusDescription() {
        return statusDescription;
    }

    /**
     * Returns true if the SubnetIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The subnet IDs that are obtained from the server when the backup is created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubnetIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The subnet IDs that are obtained from the server when the backup is created.
     */
    public List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * <p>
     * The version of AWS OpsWorks CM-specific tools that is obtained from the server when the backup is created.
     * </p>
     * 
     * @return The version of AWS OpsWorks CM-specific tools that is obtained from the server when the backup is
     *         created.
     */
    public String toolsVersion() {
        return toolsVersion;
    }

    /**
     * <p>
     * The IAM user ARN of the requester for manual backups. This field is empty for automated backups.
     * </p>
     * 
     * @return The IAM user ARN of the requester for manual backups. This field is empty for automated backups.
     */
    public String userArn() {
        return userArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(backupArn());
        hashCode = 31 * hashCode + Objects.hashCode(backupId());
        hashCode = 31 * hashCode + Objects.hashCode(backupTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineModel());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(instanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(keyPair());
        hashCode = 31 * hashCode + Objects.hashCode(preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(s3DataSize());
        hashCode = 31 * hashCode + Objects.hashCode(s3DataUrl());
        hashCode = 31 * hashCode + Objects.hashCode(s3LogUrl());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(serverName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusDescription());
        hashCode = 31 * hashCode + Objects.hashCode(subnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(toolsVersion());
        hashCode = 31 * hashCode + Objects.hashCode(userArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Backup)) {
            return false;
        }
        Backup other = (Backup) obj;
        return Objects.equals(backupArn(), other.backupArn()) && Objects.equals(backupId(), other.backupId())
                && Objects.equals(backupTypeAsString(), other.backupTypeAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(description(), other.description())
                && Objects.equals(engine(), other.engine()) && Objects.equals(engineModel(), other.engineModel())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(instanceProfileArn(), other.instanceProfileArn())
                && Objects.equals(instanceType(), other.instanceType()) && Objects.equals(keyPair(), other.keyPair())
                && Objects.equals(preferredBackupWindow(), other.preferredBackupWindow())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(s3DataSize(), other.s3DataSize()) && Objects.equals(s3DataUrl(), other.s3DataUrl())
                && Objects.equals(s3LogUrl(), other.s3LogUrl()) && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(serverName(), other.serverName()) && Objects.equals(serviceRoleArn(), other.serviceRoleArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusDescription(), other.statusDescription())
                && Objects.equals(subnetIds(), other.subnetIds()) && Objects.equals(toolsVersion(), other.toolsVersion())
                && Objects.equals(userArn(), other.userArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Backup").add("BackupArn", backupArn()).add("BackupId", backupId())
                .add("BackupType", backupTypeAsString()).add("CreatedAt", createdAt()).add("Description", description())
                .add("Engine", engine()).add("EngineModel", engineModel()).add("EngineVersion", engineVersion())
                .add("InstanceProfileArn", instanceProfileArn()).add("InstanceType", instanceType()).add("KeyPair", keyPair())
                .add("PreferredBackupWindow", preferredBackupWindow())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow()).add("S3DataSize", s3DataSize())
                .add("S3DataUrl", s3DataUrl()).add("S3LogUrl", s3LogUrl()).add("SecurityGroupIds", securityGroupIds())
                .add("ServerName", serverName()).add("ServiceRoleArn", serviceRoleArn()).add("Status", statusAsString())
                .add("StatusDescription", statusDescription()).add("SubnetIds", subnetIds()).add("ToolsVersion", toolsVersion())
                .add("UserArn", userArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupArn":
            return Optional.ofNullable(clazz.cast(backupArn()));
        case "BackupId":
            return Optional.ofNullable(clazz.cast(backupId()));
        case "BackupType":
            return Optional.ofNullable(clazz.cast(backupTypeAsString()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineModel":
            return Optional.ofNullable(clazz.cast(engineModel()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "InstanceProfileArn":
            return Optional.ofNullable(clazz.cast(instanceProfileArn()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "KeyPair":
            return Optional.ofNullable(clazz.cast(keyPair()));
        case "PreferredBackupWindow":
            return Optional.ofNullable(clazz.cast(preferredBackupWindow()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "S3DataSize":
            return Optional.ofNullable(clazz.cast(s3DataSize()));
        case "S3DataUrl":
            return Optional.ofNullable(clazz.cast(s3DataUrl()));
        case "S3LogUrl":
            return Optional.ofNullable(clazz.cast(s3LogUrl()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "ServerName":
            return Optional.ofNullable(clazz.cast(serverName()));
        case "ServiceRoleArn":
            return Optional.ofNullable(clazz.cast(serviceRoleArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusDescription":
            return Optional.ofNullable(clazz.cast(statusDescription()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "ToolsVersion":
            return Optional.ofNullable(clazz.cast(toolsVersion()));
        case "UserArn":
            return Optional.ofNullable(clazz.cast(userArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Backup, T> g) {
        return obj -> g.apply((Backup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Backup> {
        /**
         * <p>
         * The ARN of the backup.
         * </p>
         * 
         * @param backupArn
         *        The ARN of the backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupArn(String backupArn);

        /**
         * <p>
         * The generated ID of the backup. Example: <code>myServerName-yyyyMMddHHmmssSSS</code>
         * </p>
         * 
         * @param backupId
         *        The generated ID of the backup. Example: <code>myServerName-yyyyMMddHHmmssSSS</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupId(String backupId);

        /**
         * <p>
         * The backup type. Valid values are <code>automated</code> or <code>manual</code>.
         * </p>
         * 
         * @param backupType
         *        The backup type. Valid values are <code>automated</code> or <code>manual</code>.
         * @see BackupType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BackupType
         */
        Builder backupType(String backupType);

        /**
         * <p>
         * The backup type. Valid values are <code>automated</code> or <code>manual</code>.
         * </p>
         * 
         * @param backupType
         *        The backup type. Valid values are <code>automated</code> or <code>manual</code>.
         * @see BackupType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BackupType
         */
        Builder backupType(BackupType backupType);

        /**
         * <p>
         * The time stamp when the backup was created in the database. Example: <code>2016-07-29T13:38:47.520Z</code>
         * </p>
         * 
         * @param createdAt
         *        The time stamp when the backup was created in the database. Example:
         *        <code>2016-07-29T13:38:47.520Z</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * A user-provided description for a manual backup. This field is empty for automated backups.
         * </p>
         * 
         * @param description
         *        A user-provided description for a manual backup. This field is empty for automated backups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The engine type that is obtained from the server when the backup is created.
         * </p>
         * 
         * @param engine
         *        The engine type that is obtained from the server when the backup is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The engine model that is obtained from the server when the backup is created.
         * </p>
         * 
         * @param engineModel
         *        The engine model that is obtained from the server when the backup is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineModel(String engineModel);

        /**
         * <p>
         * The engine version that is obtained from the server when the backup is created.
         * </p>
         * 
         * @param engineVersion
         *        The engine version that is obtained from the server when the backup is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The EC2 instance profile ARN that is obtained from the server when the backup is created. Because this value
         * is stored, you are not required to provide the InstanceProfileArn again if you restore a backup.
         * </p>
         * 
         * @param instanceProfileArn
         *        The EC2 instance profile ARN that is obtained from the server when the backup is created. Because this
         *        value is stored, you are not required to provide the InstanceProfileArn again if you restore a backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceProfileArn(String instanceProfileArn);

        /**
         * <p>
         * The instance type that is obtained from the server when the backup is created.
         * </p>
         * 
         * @param instanceType
         *        The instance type that is obtained from the server when the backup is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The key pair that is obtained from the server when the backup is created.
         * </p>
         * 
         * @param keyPair
         *        The key pair that is obtained from the server when the backup is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPair(String keyPair);

        /**
         * <p>
         * The preferred backup period that is obtained from the server when the backup is created.
         * </p>
         * 
         * @param preferredBackupWindow
         *        The preferred backup period that is obtained from the server when the backup is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredBackupWindow(String preferredBackupWindow);

        /**
         * <p>
         * The preferred maintenance period that is obtained from the server when the backup is created.
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        The preferred maintenance period that is obtained from the server when the backup is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * This field is deprecated and is no longer used.
         * </p>
         * 
         * @param s3DataSize
         *        This field is deprecated and is no longer used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3DataSize(Integer s3DataSize);

        /**
         * <p>
         * This field is deprecated and is no longer used.
         * </p>
         * 
         * @param s3DataUrl
         *        This field is deprecated and is no longer used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3DataUrl(String s3DataUrl);

        /**
         * <p>
         * The Amazon S3 URL of the backup's log file.
         * </p>
         * 
         * @param s3LogUrl
         *        The Amazon S3 URL of the backup's log file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3LogUrl(String s3LogUrl);

        /**
         * <p>
         * The security group IDs that are obtained from the server when the backup is created.
         * </p>
         * 
         * @param securityGroupIds
         *        The security group IDs that are obtained from the server when the backup is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The security group IDs that are obtained from the server when the backup is created.
         * </p>
         * 
         * @param securityGroupIds
         *        The security group IDs that are obtained from the server when the backup is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The name of the server from which the backup was made.
         * </p>
         * 
         * @param serverName
         *        The name of the server from which the backup was made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverName(String serverName);

        /**
         * <p>
         * The service role ARN that is obtained from the server when the backup is created.
         * </p>
         * 
         * @param serviceRoleArn
         *        The service role ARN that is obtained from the server when the backup is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRoleArn(String serviceRoleArn);

        /**
         * <p>
         * The status of a backup while in progress.
         * </p>
         * 
         * @param status
         *        The status of a backup while in progress.
         * @see BackupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BackupStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of a backup while in progress.
         * </p>
         * 
         * @param status
         *        The status of a backup while in progress.
         * @see BackupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BackupStatus
         */
        Builder status(BackupStatus status);

        /**
         * <p>
         * An informational message about backup status.
         * </p>
         * 
         * @param statusDescription
         *        An informational message about backup status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDescription(String statusDescription);

        /**
         * <p>
         * The subnet IDs that are obtained from the server when the backup is created.
         * </p>
         * 
         * @param subnetIds
         *        The subnet IDs that are obtained from the server when the backup is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The subnet IDs that are obtained from the server when the backup is created.
         * </p>
         * 
         * @param subnetIds
         *        The subnet IDs that are obtained from the server when the backup is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * The version of AWS OpsWorks CM-specific tools that is obtained from the server when the backup is created.
         * </p>
         * 
         * @param toolsVersion
         *        The version of AWS OpsWorks CM-specific tools that is obtained from the server when the backup is
         *        created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toolsVersion(String toolsVersion);

        /**
         * <p>
         * The IAM user ARN of the requester for manual backups. This field is empty for automated backups.
         * </p>
         * 
         * @param userArn
         *        The IAM user ARN of the requester for manual backups. This field is empty for automated backups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userArn(String userArn);
    }

    static final class BuilderImpl implements Builder {
        private String backupArn;

        private String backupId;

        private String backupType;

        private Instant createdAt;

        private String description;

        private String engine;

        private String engineModel;

        private String engineVersion;

        private String instanceProfileArn;

        private String instanceType;

        private String keyPair;

        private String preferredBackupWindow;

        private String preferredMaintenanceWindow;

        private Integer s3DataSize;

        private String s3DataUrl;

        private String s3LogUrl;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String serverName;

        private String serviceRoleArn;

        private String status;

        private String statusDescription;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private String toolsVersion;

        private String userArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Backup model) {
            backupArn(model.backupArn);
            backupId(model.backupId);
            backupType(model.backupType);
            createdAt(model.createdAt);
            description(model.description);
            engine(model.engine);
            engineModel(model.engineModel);
            engineVersion(model.engineVersion);
            instanceProfileArn(model.instanceProfileArn);
            instanceType(model.instanceType);
            keyPair(model.keyPair);
            preferredBackupWindow(model.preferredBackupWindow);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            s3DataSize(model.s3DataSize);
            s3DataUrl(model.s3DataUrl);
            s3LogUrl(model.s3LogUrl);
            securityGroupIds(model.securityGroupIds);
            serverName(model.serverName);
            serviceRoleArn(model.serviceRoleArn);
            status(model.status);
            statusDescription(model.statusDescription);
            subnetIds(model.subnetIds);
            toolsVersion(model.toolsVersion);
            userArn(model.userArn);
        }

        public final String getBackupArn() {
            return backupArn;
        }

        @Override
        public final Builder backupArn(String backupArn) {
            this.backupArn = backupArn;
            return this;
        }

        public final void setBackupArn(String backupArn) {
            this.backupArn = backupArn;
        }

        public final String getBackupId() {
            return backupId;
        }

        @Override
        public final Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        public final void setBackupId(String backupId) {
            this.backupId = backupId;
        }

        public final String getBackupTypeAsString() {
            return backupType;
        }

        @Override
        public final Builder backupType(String backupType) {
            this.backupType = backupType;
            return this;
        }

        @Override
        public final Builder backupType(BackupType backupType) {
            this.backupType(backupType == null ? null : backupType.toString());
            return this;
        }

        public final void setBackupType(String backupType) {
            this.backupType = backupType;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getEngine() {
            return engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineModel() {
            return engineModel;
        }

        @Override
        public final Builder engineModel(String engineModel) {
            this.engineModel = engineModel;
            return this;
        }

        public final void setEngineModel(String engineModel) {
            this.engineModel = engineModel;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getInstanceProfileArn() {
            return instanceProfileArn;
        }

        @Override
        public final Builder instanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
            return this;
        }

        public final void setInstanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKeyPair() {
            return keyPair;
        }

        @Override
        public final Builder keyPair(String keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public final void setKeyPair(String keyPair) {
            this.keyPair = keyPair;
        }

        public final String getPreferredBackupWindow() {
            return preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final Integer getS3DataSize() {
            return s3DataSize;
        }

        @Override
        public final Builder s3DataSize(Integer s3DataSize) {
            this.s3DataSize = s3DataSize;
            return this;
        }

        public final void setS3DataSize(Integer s3DataSize) {
            this.s3DataSize = s3DataSize;
        }

        public final String getS3DataUrl() {
            return s3DataUrl;
        }

        @Override
        public final Builder s3DataUrl(String s3DataUrl) {
            this.s3DataUrl = s3DataUrl;
            return this;
        }

        public final void setS3DataUrl(String s3DataUrl) {
            this.s3DataUrl = s3DataUrl;
        }

        public final String getS3LogUrl() {
            return s3LogUrl;
        }

        @Override
        public final Builder s3LogUrl(String s3LogUrl) {
            this.s3LogUrl = s3LogUrl;
            return this;
        }

        public final void setS3LogUrl(String s3LogUrl) {
            this.s3LogUrl = s3LogUrl;
        }

        public final Collection<String> getSecurityGroupIds() {
            return securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringsCopier.copy(securityGroupIds);
        }

        public final String getServerName() {
            return serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final String getServiceRoleArn() {
            return serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BackupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusDescription() {
            return statusDescription;
        }

        @Override
        public final Builder statusDescription(String statusDescription) {
            this.statusDescription = statusDescription;
            return this;
        }

        public final void setStatusDescription(String statusDescription) {
            this.statusDescription = statusDescription;
        }

        public final Collection<String> getSubnetIds() {
            return subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringsCopier.copy(subnetIds);
        }

        public final String getToolsVersion() {
            return toolsVersion;
        }

        @Override
        public final Builder toolsVersion(String toolsVersion) {
            this.toolsVersion = toolsVersion;
            return this;
        }

        public final void setToolsVersion(String toolsVersion) {
            this.toolsVersion = toolsVersion;
        }

        public final String getUserArn() {
            return userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        @Override
        public Backup build() {
            return new Backup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
