/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworkscm;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.opsworkscm.model.AssociateNodeRequest;
import software.amazon.awssdk.services.opsworkscm.model.AssociateNodeResponse;
import software.amazon.awssdk.services.opsworkscm.model.CreateBackupRequest;
import software.amazon.awssdk.services.opsworkscm.model.CreateBackupResponse;
import software.amazon.awssdk.services.opsworkscm.model.CreateServerRequest;
import software.amazon.awssdk.services.opsworkscm.model.CreateServerResponse;
import software.amazon.awssdk.services.opsworkscm.model.DeleteBackupRequest;
import software.amazon.awssdk.services.opsworkscm.model.DeleteBackupResponse;
import software.amazon.awssdk.services.opsworkscm.model.DeleteServerRequest;
import software.amazon.awssdk.services.opsworkscm.model.DeleteServerResponse;
import software.amazon.awssdk.services.opsworkscm.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.opsworkscm.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.opsworkscm.model.DescribeBackupsRequest;
import software.amazon.awssdk.services.opsworkscm.model.DescribeBackupsResponse;
import software.amazon.awssdk.services.opsworkscm.model.DescribeEventsRequest;
import software.amazon.awssdk.services.opsworkscm.model.DescribeEventsResponse;
import software.amazon.awssdk.services.opsworkscm.model.DescribeNodeAssociationStatusRequest;
import software.amazon.awssdk.services.opsworkscm.model.DescribeNodeAssociationStatusResponse;
import software.amazon.awssdk.services.opsworkscm.model.DescribeServersRequest;
import software.amazon.awssdk.services.opsworkscm.model.DescribeServersResponse;
import software.amazon.awssdk.services.opsworkscm.model.DisassociateNodeRequest;
import software.amazon.awssdk.services.opsworkscm.model.DisassociateNodeResponse;
import software.amazon.awssdk.services.opsworkscm.model.ExportServerEngineAttributeRequest;
import software.amazon.awssdk.services.opsworkscm.model.ExportServerEngineAttributeResponse;
import software.amazon.awssdk.services.opsworkscm.model.InvalidNextTokenException;
import software.amazon.awssdk.services.opsworkscm.model.InvalidStateException;
import software.amazon.awssdk.services.opsworkscm.model.LimitExceededException;
import software.amazon.awssdk.services.opsworkscm.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.opsworkscm.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.opsworkscm.model.OpsWorksCmException;
import software.amazon.awssdk.services.opsworkscm.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.opsworkscm.model.ResourceNotFoundException;
import software.amazon.awssdk.services.opsworkscm.model.RestoreServerRequest;
import software.amazon.awssdk.services.opsworkscm.model.RestoreServerResponse;
import software.amazon.awssdk.services.opsworkscm.model.StartMaintenanceRequest;
import software.amazon.awssdk.services.opsworkscm.model.StartMaintenanceResponse;
import software.amazon.awssdk.services.opsworkscm.model.TagResourceRequest;
import software.amazon.awssdk.services.opsworkscm.model.TagResourceResponse;
import software.amazon.awssdk.services.opsworkscm.model.UntagResourceRequest;
import software.amazon.awssdk.services.opsworkscm.model.UntagResourceResponse;
import software.amazon.awssdk.services.opsworkscm.model.UpdateServerEngineAttributesRequest;
import software.amazon.awssdk.services.opsworkscm.model.UpdateServerEngineAttributesResponse;
import software.amazon.awssdk.services.opsworkscm.model.UpdateServerRequest;
import software.amazon.awssdk.services.opsworkscm.model.UpdateServerResponse;
import software.amazon.awssdk.services.opsworkscm.model.ValidationException;

/**
 * Service client for accessing OpsWorksCM. This can be created using the static {@link #builder()} method.
 *
 * <fullname>AWS OpsWorks CM</fullname>
 * <p>
 * AWS OpsWorks for configuration management (CM) is a service that runs and manages configuration management servers.
 * You can use AWS OpsWorks CM to create and manage AWS OpsWorks for Chef Automate and AWS OpsWorks for Puppet
 * Enterprise servers, and add or remove nodes for the servers to manage.
 * </p>
 * <p>
 * <b>Glossary of terms</b>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <b>Server</b>: A configuration management server that can be highly-available. The configuration management server
 * runs on an Amazon Elastic Compute Cloud (EC2) instance, and may use various other AWS services, such as Amazon
 * Relational Database Service (RDS) and Elastic Load Balancing. A server is a generic abstraction over the
 * configuration manager that you want to use, much like Amazon RDS. In AWS OpsWorks CM, you do not start or stop
 * servers. After you create servers, they continue to run until they are deleted.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Engine</b>: The engine is the specific configuration manager that you want to use. Valid values in this release
 * include <code>ChefAutomate</code> and <code>Puppet</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Backup</b>: This is an application-level backup of the data that the configuration manager stores. AWS OpsWorks CM
 * creates an S3 bucket for backups when you launch the first server. A backup maintains a snapshot of a server's
 * configuration-related attributes at the time the backup starts.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Events</b>: Events are always related to a server. Events are written during server creation, when health checks
 * run, when backups are created, when system maintenance is performed, etc. When you delete a server, the server's
 * events are also deleted.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Account attributes</b>: Every account has attributes that are assigned in the AWS OpsWorks CM database. These
 * attributes store information about configuration limits (servers, backups, etc.) and your customer account.
 * </p>
 * </li>
 * </ul>
 * <p>
 * <b>Endpoints</b>
 * </p>
 * <p>
 * AWS OpsWorks CM supports the following endpoints, all HTTPS. You must connect to one of the following endpoints. Your
 * servers can only be accessed or managed within the endpoint in which they are created.
 * </p>
 * <ul>
 * <li>
 * <p>
 * opsworks-cm.us-east-1.amazonaws.com
 * </p>
 * </li>
 * <li>
 * <p>
 * opsworks-cm.us-east-2.amazonaws.com
 * </p>
 * </li>
 * <li>
 * <p>
 * opsworks-cm.us-west-1.amazonaws.com
 * </p>
 * </li>
 * <li>
 * <p>
 * opsworks-cm.us-west-2.amazonaws.com
 * </p>
 * </li>
 * <li>
 * <p>
 * opsworks-cm.ap-northeast-1.amazonaws.com
 * </p>
 * </li>
 * <li>
 * <p>
 * opsworks-cm.ap-southeast-1.amazonaws.com
 * </p>
 * </li>
 * <li>
 * <p>
 * opsworks-cm.ap-southeast-2.amazonaws.com
 * </p>
 * </li>
 * <li>
 * <p>
 * opsworks-cm.eu-central-1.amazonaws.com
 * </p>
 * </li>
 * <li>
 * <p>
 * opsworks-cm.eu-west-1.amazonaws.com
 * </p>
 * </li>
 * </ul>
 * <p>
 * <b>Throttling limits</b>
 * </p>
 * <p>
 * All API operations allow for five requests per second with a burst of 10 requests per second.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface OpsWorksCmClient extends SdkClient {
    String SERVICE_NAME = "opsworks-cm";

    /**
     * Create a {@link OpsWorksCmClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static OpsWorksCmClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link OpsWorksCmClient}.
     */
    static OpsWorksCmClientBuilder builder() {
        return new DefaultOpsWorksCmClientBuilder();
    }

    /**
     * <p>
     * Associates a new node with the server. For more information about how to disassociate a node, see
     * <a>DisassociateNode</a>.
     * </p>
     * <p>
     * On a Chef server: This command is an alternative to <code>knife bootstrap</code>.
     * </p>
     * <p>
     * Example (Chef):
     * <code>aws opsworks-cm associate-node --server-name <i>MyServer</i> --node-name <i>MyManagedNode</i> --engine-attributes "Name=<i>CHEF_ORGANIZATION</i>,Value=default" "Name=<i>CHEF_NODE_PUBLIC_KEY</i>,Value=<i>public-key-pem</i>"</code>
     * </p>
     * <p>
     * On a Puppet server, this command is an alternative to the <code>puppet cert sign</code> command that signs a
     * Puppet node CSR.
     * </p>
     * <p>
     * Example (Chef):
     * <code>aws opsworks-cm associate-node --server-name <i>MyServer</i> --node-name <i>MyManagedNode</i> --engine-attributes "Name=<i>PUPPET_NODE_CSR</i>,Value=<i>csr-pem</i>"</code>
     * </p>
     * <p>
     * A node can can only be associated with servers that are in a <code>HEALTHY</code> state. Otherwise, an
     * <code>InvalidStateException</code> is thrown. A <code>ResourceNotFoundException</code> is thrown when the server
     * does not exist. A <code>ValidationException</code> is raised when parameters of the request are not valid. The
     * AssociateNode API call can be integrated into Auto Scaling configurations, AWS Cloudformation templates, or the
     * user data of a server's instance.
     * </p>
     *
     * @param associateNodeRequest
     * @return Result of the AssociateNode operation returned by the service.
     * @throws InvalidStateException
     *         The resource is in a state that does not allow you to perform a specified action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.AssociateNode
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/AssociateNode" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateNodeResponse associateNode(AssociateNodeRequest associateNodeRequest) throws InvalidStateException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpsWorksCmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a new node with the server. For more information about how to disassociate a node, see
     * <a>DisassociateNode</a>.
     * </p>
     * <p>
     * On a Chef server: This command is an alternative to <code>knife bootstrap</code>.
     * </p>
     * <p>
     * Example (Chef):
     * <code>aws opsworks-cm associate-node --server-name <i>MyServer</i> --node-name <i>MyManagedNode</i> --engine-attributes "Name=<i>CHEF_ORGANIZATION</i>,Value=default" "Name=<i>CHEF_NODE_PUBLIC_KEY</i>,Value=<i>public-key-pem</i>"</code>
     * </p>
     * <p>
     * On a Puppet server, this command is an alternative to the <code>puppet cert sign</code> command that signs a
     * Puppet node CSR.
     * </p>
     * <p>
     * Example (Chef):
     * <code>aws opsworks-cm associate-node --server-name <i>MyServer</i> --node-name <i>MyManagedNode</i> --engine-attributes "Name=<i>PUPPET_NODE_CSR</i>,Value=<i>csr-pem</i>"</code>
     * </p>
     * <p>
     * A node can can only be associated with servers that are in a <code>HEALTHY</code> state. Otherwise, an
     * <code>InvalidStateException</code> is thrown. A <code>ResourceNotFoundException</code> is thrown when the server
     * does not exist. A <code>ValidationException</code> is raised when parameters of the request are not valid. The
     * AssociateNode API call can be integrated into Auto Scaling configurations, AWS Cloudformation templates, or the
     * user data of a server's instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateNodeRequest.Builder} avoiding the need to
     * create one manually via {@link AssociateNodeRequest#builder()}
     * </p>
     *
     * @param associateNodeRequest
     *        A {@link Consumer} that will call methods on {@link AssociateNodeRequest.Builder} to create a request.
     * @return Result of the AssociateNode operation returned by the service.
     * @throws InvalidStateException
     *         The resource is in a state that does not allow you to perform a specified action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.AssociateNode
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/AssociateNode" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateNodeResponse associateNode(Consumer<AssociateNodeRequest.Builder> associateNodeRequest)
            throws InvalidStateException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, OpsWorksCmException {
        return associateNode(AssociateNodeRequest.builder().applyMutation(associateNodeRequest).build());
    }

    /**
     * <p>
     * Creates an application-level backup of a server. While the server is in the <code>BACKING_UP</code> state, the
     * server cannot be changed, and no additional backup can be created.
     * </p>
     * <p>
     * Backups can be created for servers in <code>RUNNING</code>, <code>HEALTHY</code>, and <code>UNHEALTHY</code>
     * states. By default, you can create a maximum of 50 manual backups.
     * </p>
     * <p>
     * This operation is asynchronous.
     * </p>
     * <p>
     * A <code>LimitExceededException</code> is thrown when the maximum number of manual backups is reached. An
     * <code>InvalidStateException</code> is thrown when the server is not in any of the following states: RUNNING,
     * HEALTHY, or UNHEALTHY. A <code>ResourceNotFoundException</code> is thrown when the server is not found. A
     * <code>ValidationException</code> is thrown when parameters of the request are not valid.
     * </p>
     *
     * @param createBackupRequest
     * @return Result of the CreateBackup operation returned by the service.
     * @throws InvalidStateException
     *         The resource is in a state that does not allow you to perform a specified action.
     * @throws LimitExceededException
     *         The limit of servers or backups has been reached.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.CreateBackup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/CreateBackup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateBackupResponse createBackup(CreateBackupRequest createBackupRequest) throws InvalidStateException,
            LimitExceededException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            OpsWorksCmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an application-level backup of a server. While the server is in the <code>BACKING_UP</code> state, the
     * server cannot be changed, and no additional backup can be created.
     * </p>
     * <p>
     * Backups can be created for servers in <code>RUNNING</code>, <code>HEALTHY</code>, and <code>UNHEALTHY</code>
     * states. By default, you can create a maximum of 50 manual backups.
     * </p>
     * <p>
     * This operation is asynchronous.
     * </p>
     * <p>
     * A <code>LimitExceededException</code> is thrown when the maximum number of manual backups is reached. An
     * <code>InvalidStateException</code> is thrown when the server is not in any of the following states: RUNNING,
     * HEALTHY, or UNHEALTHY. A <code>ResourceNotFoundException</code> is thrown when the server is not found. A
     * <code>ValidationException</code> is thrown when parameters of the request are not valid.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBackupRequest.Builder} avoiding the need to
     * create one manually via {@link CreateBackupRequest#builder()}
     * </p>
     *
     * @param createBackupRequest
     *        A {@link Consumer} that will call methods on {@link CreateBackupRequest.Builder} to create a request.
     * @return Result of the CreateBackup operation returned by the service.
     * @throws InvalidStateException
     *         The resource is in a state that does not allow you to perform a specified action.
     * @throws LimitExceededException
     *         The limit of servers or backups has been reached.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.CreateBackup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/CreateBackup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateBackupResponse createBackup(Consumer<CreateBackupRequest.Builder> createBackupRequest)
            throws InvalidStateException, LimitExceededException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, OpsWorksCmException {
        return createBackup(CreateBackupRequest.builder().applyMutation(createBackupRequest).build());
    }

    /**
     * <p>
     * Creates and immedately starts a new server. The server is ready to use when it is in the <code>HEALTHY</code>
     * state. By default, you can create a maximum of 10 servers.
     * </p>
     * <p>
     * This operation is asynchronous.
     * </p>
     * <p>
     * A <code>LimitExceededException</code> is thrown when you have created the maximum number of servers (10). A
     * <code>ResourceAlreadyExistsException</code> is thrown when a server with the same name already exists in the
     * account. A <code>ResourceNotFoundException</code> is thrown when you specify a backup ID that is not valid or is
     * for a backup that does not exist. A <code>ValidationException</code> is thrown when parameters of the request are
     * not valid.
     * </p>
     * <p>
     * If you do not specify a security group by adding the <code>SecurityGroupIds</code> parameter, AWS OpsWorks
     * creates a new security group.
     * </p>
     * <p>
     * <i>Chef Automate:</i> The default security group opens the Chef server to the world on TCP port 443. If a KeyName
     * is present, AWS OpsWorks enables SSH access. SSH is also open to the world on TCP port 22.
     * </p>
     * <p>
     * <i>Puppet Enterprise:</i> The default security group opens TCP ports 22, 443, 4433, 8140, 8142, 8143, and 8170.
     * If a KeyName is present, AWS OpsWorks enables SSH access. SSH is also open to the world on TCP port 22.
     * </p>
     * <p>
     * By default, your server is accessible from any IP address. We recommend that you update your security group rules
     * to allow access from known IP addresses and address ranges only. To edit security group rules, open Security
     * Groups in the navigation pane of the EC2 management console.
     * </p>
     * <p>
     * To specify your own domain for a server, and provide your own self-signed or CA-signed certificate and private
     * key, specify values for <code>CustomDomain</code>, <code>CustomCertificate</code>, and
     * <code>CustomPrivateKey</code>.
     * </p>
     *
     * @param createServerRequest
     * @return Result of the CreateServer operation returned by the service.
     * @throws LimitExceededException
     *         The limit of servers or backups has been reached.
     * @throws ResourceAlreadyExistsException
     *         The requested resource cannot be created because it already exists.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.CreateServer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/CreateServer" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateServerResponse createServer(CreateServerRequest createServerRequest) throws LimitExceededException,
            ResourceAlreadyExistsException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, OpsWorksCmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates and immedately starts a new server. The server is ready to use when it is in the <code>HEALTHY</code>
     * state. By default, you can create a maximum of 10 servers.
     * </p>
     * <p>
     * This operation is asynchronous.
     * </p>
     * <p>
     * A <code>LimitExceededException</code> is thrown when you have created the maximum number of servers (10). A
     * <code>ResourceAlreadyExistsException</code> is thrown when a server with the same name already exists in the
     * account. A <code>ResourceNotFoundException</code> is thrown when you specify a backup ID that is not valid or is
     * for a backup that does not exist. A <code>ValidationException</code> is thrown when parameters of the request are
     * not valid.
     * </p>
     * <p>
     * If you do not specify a security group by adding the <code>SecurityGroupIds</code> parameter, AWS OpsWorks
     * creates a new security group.
     * </p>
     * <p>
     * <i>Chef Automate:</i> The default security group opens the Chef server to the world on TCP port 443. If a KeyName
     * is present, AWS OpsWorks enables SSH access. SSH is also open to the world on TCP port 22.
     * </p>
     * <p>
     * <i>Puppet Enterprise:</i> The default security group opens TCP ports 22, 443, 4433, 8140, 8142, 8143, and 8170.
     * If a KeyName is present, AWS OpsWorks enables SSH access. SSH is also open to the world on TCP port 22.
     * </p>
     * <p>
     * By default, your server is accessible from any IP address. We recommend that you update your security group rules
     * to allow access from known IP addresses and address ranges only. To edit security group rules, open Security
     * Groups in the navigation pane of the EC2 management console.
     * </p>
     * <p>
     * To specify your own domain for a server, and provide your own self-signed or CA-signed certificate and private
     * key, specify values for <code>CustomDomain</code>, <code>CustomCertificate</code>, and
     * <code>CustomPrivateKey</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateServerRequest.Builder} avoiding the need to
     * create one manually via {@link CreateServerRequest#builder()}
     * </p>
     *
     * @param createServerRequest
     *        A {@link Consumer} that will call methods on {@link CreateServerRequest.Builder} to create a request.
     * @return Result of the CreateServer operation returned by the service.
     * @throws LimitExceededException
     *         The limit of servers or backups has been reached.
     * @throws ResourceAlreadyExistsException
     *         The requested resource cannot be created because it already exists.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.CreateServer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/CreateServer" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateServerResponse createServer(Consumer<CreateServerRequest.Builder> createServerRequest)
            throws LimitExceededException, ResourceAlreadyExistsException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, OpsWorksCmException {
        return createServer(CreateServerRequest.builder().applyMutation(createServerRequest).build());
    }

    /**
     * <p>
     * Deletes a backup. You can delete both manual and automated backups. This operation is asynchronous.
     * </p>
     * <p>
     * An <code>InvalidStateException</code> is thrown when a backup deletion is already in progress. A
     * <code>ResourceNotFoundException</code> is thrown when the backup does not exist. A
     * <code>ValidationException</code> is thrown when parameters of the request are not valid.
     * </p>
     *
     * @param deleteBackupRequest
     * @return Result of the DeleteBackup operation returned by the service.
     * @throws InvalidStateException
     *         The resource is in a state that does not allow you to perform a specified action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.DeleteBackup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DeleteBackup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteBackupResponse deleteBackup(DeleteBackupRequest deleteBackupRequest) throws InvalidStateException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpsWorksCmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a backup. You can delete both manual and automated backups. This operation is asynchronous.
     * </p>
     * <p>
     * An <code>InvalidStateException</code> is thrown when a backup deletion is already in progress. A
     * <code>ResourceNotFoundException</code> is thrown when the backup does not exist. A
     * <code>ValidationException</code> is thrown when parameters of the request are not valid.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBackupRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteBackupRequest#builder()}
     * </p>
     *
     * @param deleteBackupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBackupRequest.Builder} to create a request.
     * @return Result of the DeleteBackup operation returned by the service.
     * @throws InvalidStateException
     *         The resource is in a state that does not allow you to perform a specified action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.DeleteBackup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DeleteBackup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteBackupResponse deleteBackup(Consumer<DeleteBackupRequest.Builder> deleteBackupRequest)
            throws InvalidStateException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, OpsWorksCmException {
        return deleteBackup(DeleteBackupRequest.builder().applyMutation(deleteBackupRequest).build());
    }

    /**
     * <p>
     * Deletes the server and the underlying AWS CloudFormation stacks (including the server's EC2 instance). When you
     * run this command, the server state is updated to <code>DELETING</code>. After the server is deleted, it is no
     * longer returned by <code>DescribeServer</code> requests. If the AWS CloudFormation stack cannot be deleted, the
     * server cannot be deleted.
     * </p>
     * <p>
     * This operation is asynchronous.
     * </p>
     * <p>
     * An <code>InvalidStateException</code> is thrown when a server deletion is already in progress. A
     * <code>ResourceNotFoundException</code> is thrown when the server does not exist. A
     * <code>ValidationException</code> is raised when parameters of the request are not valid.
     * </p>
     * <p>
     * </p>
     *
     * @param deleteServerRequest
     * @return Result of the DeleteServer operation returned by the service.
     * @throws InvalidStateException
     *         The resource is in a state that does not allow you to perform a specified action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.DeleteServer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DeleteServer" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteServerResponse deleteServer(DeleteServerRequest deleteServerRequest) throws InvalidStateException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpsWorksCmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the server and the underlying AWS CloudFormation stacks (including the server's EC2 instance). When you
     * run this command, the server state is updated to <code>DELETING</code>. After the server is deleted, it is no
     * longer returned by <code>DescribeServer</code> requests. If the AWS CloudFormation stack cannot be deleted, the
     * server cannot be deleted.
     * </p>
     * <p>
     * This operation is asynchronous.
     * </p>
     * <p>
     * An <code>InvalidStateException</code> is thrown when a server deletion is already in progress. A
     * <code>ResourceNotFoundException</code> is thrown when the server does not exist. A
     * <code>ValidationException</code> is raised when parameters of the request are not valid.
     * </p>
     * <p>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteServerRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteServerRequest#builder()}
     * </p>
     *
     * @param deleteServerRequest
     *        A {@link Consumer} that will call methods on {@link DeleteServerRequest.Builder} to create a request.
     * @return Result of the DeleteServer operation returned by the service.
     * @throws InvalidStateException
     *         The resource is in a state that does not allow you to perform a specified action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.DeleteServer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DeleteServer" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteServerResponse deleteServer(Consumer<DeleteServerRequest.Builder> deleteServerRequest)
            throws InvalidStateException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, OpsWorksCmException {
        return deleteServer(DeleteServerRequest.builder().applyMutation(deleteServerRequest).build());
    }

    /**
     * <p>
     * Describes your OpsWorks-CM account attributes.
     * </p>
     * <p>
     * This operation is synchronous.
     * </p>
     *
     * @return Result of the DescribeAccountAttributes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.DescribeAccountAttributes
     * @see #describeAccountAttributes(DescribeAccountAttributesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DescribeAccountAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountAttributesResponse describeAccountAttributes() throws AwsServiceException, SdkClientException,
            OpsWorksCmException {
        return describeAccountAttributes(DescribeAccountAttributesRequest.builder().build());
    }

    /**
     * <p>
     * Describes your OpsWorks-CM account attributes.
     * </p>
     * <p>
     * This operation is synchronous.
     * </p>
     *
     * @param describeAccountAttributesRequest
     * @return Result of the DescribeAccountAttributes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.DescribeAccountAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DescribeAccountAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountAttributesResponse describeAccountAttributes(
            DescribeAccountAttributesRequest describeAccountAttributesRequest) throws AwsServiceException, SdkClientException,
            OpsWorksCmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes your OpsWorks-CM account attributes.
     * </p>
     * <p>
     * This operation is synchronous.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAccountAttributesRequest#builder()}
     * </p>
     *
     * @param describeAccountAttributesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAccountAttributesRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeAccountAttributes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.DescribeAccountAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DescribeAccountAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountAttributesResponse describeAccountAttributes(
            Consumer<DescribeAccountAttributesRequest.Builder> describeAccountAttributesRequest) throws AwsServiceException,
            SdkClientException, OpsWorksCmException {
        return describeAccountAttributes(DescribeAccountAttributesRequest.builder()
                .applyMutation(describeAccountAttributesRequest).build());
    }

    /**
     * <p>
     * Describes backups. The results are ordered by time, with newest backups first. If you do not specify a BackupId
     * or ServerName, the command returns all backups.
     * </p>
     * <p>
     * This operation is synchronous.
     * </p>
     * <p>
     * A <code>ResourceNotFoundException</code> is thrown when the backup does not exist. A
     * <code>ValidationException</code> is raised when parameters of the request are not valid.
     * </p>
     *
     * @return Result of the DescribeBackups operation returned by the service.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws InvalidNextTokenException
     *         This occurs when the provided nextToken is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.DescribeBackups
     * @see #describeBackups(DescribeBackupsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DescribeBackups" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeBackupsResponse describeBackups() throws ValidationException, ResourceNotFoundException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, OpsWorksCmException {
        return describeBackups(DescribeBackupsRequest.builder().build());
    }

    /**
     * <p>
     * Describes backups. The results are ordered by time, with newest backups first. If you do not specify a BackupId
     * or ServerName, the command returns all backups.
     * </p>
     * <p>
     * This operation is synchronous.
     * </p>
     * <p>
     * A <code>ResourceNotFoundException</code> is thrown when the backup does not exist. A
     * <code>ValidationException</code> is raised when parameters of the request are not valid.
     * </p>
     *
     * @param describeBackupsRequest
     * @return Result of the DescribeBackups operation returned by the service.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws InvalidNextTokenException
     *         This occurs when the provided nextToken is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.DescribeBackups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DescribeBackups" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeBackupsResponse describeBackups(DescribeBackupsRequest describeBackupsRequest) throws ValidationException,
            ResourceNotFoundException, InvalidNextTokenException, AwsServiceException, SdkClientException, OpsWorksCmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes backups. The results are ordered by time, with newest backups first. If you do not specify a BackupId
     * or ServerName, the command returns all backups.
     * </p>
     * <p>
     * This operation is synchronous.
     * </p>
     * <p>
     * A <code>ResourceNotFoundException</code> is thrown when the backup does not exist. A
     * <code>ValidationException</code> is raised when parameters of the request are not valid.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBackupsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeBackupsRequest#builder()}
     * </p>
     *
     * @param describeBackupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBackupsRequest.Builder} to create a request.
     * @return Result of the DescribeBackups operation returned by the service.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws InvalidNextTokenException
     *         This occurs when the provided nextToken is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.DescribeBackups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DescribeBackups" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeBackupsResponse describeBackups(Consumer<DescribeBackupsRequest.Builder> describeBackupsRequest)
            throws ValidationException, ResourceNotFoundException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, OpsWorksCmException {
        return describeBackups(DescribeBackupsRequest.builder().applyMutation(describeBackupsRequest).build());
    }

    /**
     * <p>
     * Describes events for a specified server. Results are ordered by time, with newest events first.
     * </p>
     * <p>
     * This operation is synchronous.
     * </p>
     * <p>
     * A <code>ResourceNotFoundException</code> is thrown when the server does not exist. A
     * <code>ValidationException</code> is raised when parameters of the request are not valid.
     * </p>
     *
     * @param describeEventsRequest
     * @return Result of the DescribeEvents operation returned by the service.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws InvalidNextTokenException
     *         This occurs when the provided nextToken is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.DescribeEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsResponse describeEvents(DescribeEventsRequest describeEventsRequest) throws ValidationException,
            InvalidNextTokenException, ResourceNotFoundException, AwsServiceException, SdkClientException, OpsWorksCmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes events for a specified server. Results are ordered by time, with newest events first.
     * </p>
     * <p>
     * This operation is synchronous.
     * </p>
     * <p>
     * A <code>ResourceNotFoundException</code> is thrown when the server does not exist. A
     * <code>ValidationException</code> is raised when parameters of the request are not valid.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventsRequest.Builder} to create a request.
     * @return Result of the DescribeEvents operation returned by the service.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws InvalidNextTokenException
     *         This occurs when the provided nextToken is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.DescribeEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsResponse describeEvents(Consumer<DescribeEventsRequest.Builder> describeEventsRequest)
            throws ValidationException, InvalidNextTokenException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OpsWorksCmException {
        return describeEvents(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * Returns the current status of an existing association or disassociation request.
     * </p>
     * <p>
     * A <code>ResourceNotFoundException</code> is thrown when no recent association or disassociation request with the
     * specified token is found, or when the server does not exist. A <code>ValidationException</code> is raised when
     * parameters of the request are not valid.
     * </p>
     *
     * @param describeNodeAssociationStatusRequest
     * @return Result of the DescribeNodeAssociationStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.DescribeNodeAssociationStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DescribeNodeAssociationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNodeAssociationStatusResponse describeNodeAssociationStatus(
            DescribeNodeAssociationStatusRequest describeNodeAssociationStatusRequest) throws ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, OpsWorksCmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the current status of an existing association or disassociation request.
     * </p>
     * <p>
     * A <code>ResourceNotFoundException</code> is thrown when no recent association or disassociation request with the
     * specified token is found, or when the server does not exist. A <code>ValidationException</code> is raised when
     * parameters of the request are not valid.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeNodeAssociationStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeNodeAssociationStatusRequest#builder()}
     * </p>
     *
     * @param describeNodeAssociationStatusRequest
     *        A {@link Consumer} that will call methods on {@link DescribeNodeAssociationStatusRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeNodeAssociationStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.DescribeNodeAssociationStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DescribeNodeAssociationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNodeAssociationStatusResponse describeNodeAssociationStatus(
            Consumer<DescribeNodeAssociationStatusRequest.Builder> describeNodeAssociationStatusRequest)
            throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpsWorksCmException {
        return describeNodeAssociationStatus(DescribeNodeAssociationStatusRequest.builder()
                .applyMutation(describeNodeAssociationStatusRequest).build());
    }

    /**
     * <p>
     * Lists all configuration management servers that are identified with your account. Only the stored results from
     * Amazon DynamoDB are returned. AWS OpsWorks CM does not query other services.
     * </p>
     * <p>
     * This operation is synchronous.
     * </p>
     * <p>
     * A <code>ResourceNotFoundException</code> is thrown when the server does not exist. A
     * <code>ValidationException</code> is raised when parameters of the request are not valid.
     * </p>
     *
     * @return Result of the DescribeServers operation returned by the service.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws InvalidNextTokenException
     *         This occurs when the provided nextToken is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.DescribeServers
     * @see #describeServers(DescribeServersRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DescribeServers" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeServersResponse describeServers() throws ValidationException, ResourceNotFoundException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, OpsWorksCmException {
        return describeServers(DescribeServersRequest.builder().build());
    }

    /**
     * <p>
     * Lists all configuration management servers that are identified with your account. Only the stored results from
     * Amazon DynamoDB are returned. AWS OpsWorks CM does not query other services.
     * </p>
     * <p>
     * This operation is synchronous.
     * </p>
     * <p>
     * A <code>ResourceNotFoundException</code> is thrown when the server does not exist. A
     * <code>ValidationException</code> is raised when parameters of the request are not valid.
     * </p>
     *
     * @param describeServersRequest
     * @return Result of the DescribeServers operation returned by the service.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws InvalidNextTokenException
     *         This occurs when the provided nextToken is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.DescribeServers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DescribeServers" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeServersResponse describeServers(DescribeServersRequest describeServersRequest) throws ValidationException,
            ResourceNotFoundException, InvalidNextTokenException, AwsServiceException, SdkClientException, OpsWorksCmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all configuration management servers that are identified with your account. Only the stored results from
     * Amazon DynamoDB are returned. AWS OpsWorks CM does not query other services.
     * </p>
     * <p>
     * This operation is synchronous.
     * </p>
     * <p>
     * A <code>ResourceNotFoundException</code> is thrown when the server does not exist. A
     * <code>ValidationException</code> is raised when parameters of the request are not valid.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeServersRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeServersRequest#builder()}
     * </p>
     *
     * @param describeServersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeServersRequest.Builder} to create a request.
     * @return Result of the DescribeServers operation returned by the service.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws InvalidNextTokenException
     *         This occurs when the provided nextToken is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.DescribeServers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DescribeServers" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeServersResponse describeServers(Consumer<DescribeServersRequest.Builder> describeServersRequest)
            throws ValidationException, ResourceNotFoundException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, OpsWorksCmException {
        return describeServers(DescribeServersRequest.builder().applyMutation(describeServersRequest).build());
    }

    /**
     * <p>
     * Disassociates a node from an AWS OpsWorks CM server, and removes the node from the server's managed nodes. After
     * a node is disassociated, the node key pair is no longer valid for accessing the configuration manager's API. For
     * more information about how to associate a node, see <a>AssociateNode</a>.
     * </p>
     * <p>
     * A node can can only be disassociated from a server that is in a <code>HEALTHY</code> state. Otherwise, an
     * <code>InvalidStateException</code> is thrown. A <code>ResourceNotFoundException</code> is thrown when the server
     * does not exist. A <code>ValidationException</code> is raised when parameters of the request are not valid.
     * </p>
     *
     * @param disassociateNodeRequest
     * @return Result of the DisassociateNode operation returned by the service.
     * @throws InvalidStateException
     *         The resource is in a state that does not allow you to perform a specified action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.DisassociateNode
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DisassociateNode" target="_top">AWS
     *      API Documentation</a>
     */
    default DisassociateNodeResponse disassociateNode(DisassociateNodeRequest disassociateNodeRequest)
            throws InvalidStateException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, OpsWorksCmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a node from an AWS OpsWorks CM server, and removes the node from the server's managed nodes. After
     * a node is disassociated, the node key pair is no longer valid for accessing the configuration manager's API. For
     * more information about how to associate a node, see <a>AssociateNode</a>.
     * </p>
     * <p>
     * A node can can only be disassociated from a server that is in a <code>HEALTHY</code> state. Otherwise, an
     * <code>InvalidStateException</code> is thrown. A <code>ResourceNotFoundException</code> is thrown when the server
     * does not exist. A <code>ValidationException</code> is raised when parameters of the request are not valid.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateNodeRequest.Builder} avoiding the need
     * to create one manually via {@link DisassociateNodeRequest#builder()}
     * </p>
     *
     * @param disassociateNodeRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateNodeRequest.Builder} to create a request.
     * @return Result of the DisassociateNode operation returned by the service.
     * @throws InvalidStateException
     *         The resource is in a state that does not allow you to perform a specified action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.DisassociateNode
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DisassociateNode" target="_top">AWS
     *      API Documentation</a>
     */
    default DisassociateNodeResponse disassociateNode(Consumer<DisassociateNodeRequest.Builder> disassociateNodeRequest)
            throws InvalidStateException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, OpsWorksCmException {
        return disassociateNode(DisassociateNodeRequest.builder().applyMutation(disassociateNodeRequest).build());
    }

    /**
     * <p>
     * Exports a specified server engine attribute as a base64-encoded string. For example, you can export user data
     * that you can use in EC2 to associate nodes with a server.
     * </p>
     * <p>
     * This operation is synchronous.
     * </p>
     * <p>
     * A <code>ValidationException</code> is raised when parameters of the request are not valid. A
     * <code>ResourceNotFoundException</code> is thrown when the server does not exist. An
     * <code>InvalidStateException</code> is thrown when the server is in any of the following states: CREATING,
     * TERMINATED, FAILED or DELETING.
     * </p>
     *
     * @param exportServerEngineAttributeRequest
     * @return Result of the ExportServerEngineAttribute operation returned by the service.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws InvalidStateException
     *         The resource is in a state that does not allow you to perform a specified action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.ExportServerEngineAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/ExportServerEngineAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default ExportServerEngineAttributeResponse exportServerEngineAttribute(
            ExportServerEngineAttributeRequest exportServerEngineAttributeRequest) throws ValidationException,
            ResourceNotFoundException, InvalidStateException, AwsServiceException, SdkClientException, OpsWorksCmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports a specified server engine attribute as a base64-encoded string. For example, you can export user data
     * that you can use in EC2 to associate nodes with a server.
     * </p>
     * <p>
     * This operation is synchronous.
     * </p>
     * <p>
     * A <code>ValidationException</code> is raised when parameters of the request are not valid. A
     * <code>ResourceNotFoundException</code> is thrown when the server does not exist. An
     * <code>InvalidStateException</code> is thrown when the server is in any of the following states: CREATING,
     * TERMINATED, FAILED or DELETING.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportServerEngineAttributeRequest.Builder}
     * avoiding the need to create one manually via {@link ExportServerEngineAttributeRequest#builder()}
     * </p>
     *
     * @param exportServerEngineAttributeRequest
     *        A {@link Consumer} that will call methods on {@link ExportServerEngineAttributeRequest.Builder} to create
     *        a request.
     * @return Result of the ExportServerEngineAttribute operation returned by the service.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws InvalidStateException
     *         The resource is in a state that does not allow you to perform a specified action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.ExportServerEngineAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/ExportServerEngineAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default ExportServerEngineAttributeResponse exportServerEngineAttribute(
            Consumer<ExportServerEngineAttributeRequest.Builder> exportServerEngineAttributeRequest) throws ValidationException,
            ResourceNotFoundException, InvalidStateException, AwsServiceException, SdkClientException, OpsWorksCmException {
        return exportServerEngineAttribute(ExportServerEngineAttributeRequest.builder()
                .applyMutation(exportServerEngineAttributeRequest).build());
    }

    /**
     * <p>
     * Returns a list of tags that are applied to the specified AWS OpsWorks for Chef Automate or AWS OpsWorks for
     * Puppet Enterprise servers or backups.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpsWorksCmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags that are applied to the specified AWS OpsWorks for Chef Automate or AWS OpsWorks for
     * Puppet Enterprise servers or backups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, OpsWorksCmException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Restores a backup to a server that is in a <code>CONNECTION_LOST</code>, <code>HEALTHY</code>,
     * <code>RUNNING</code>, <code>UNHEALTHY</code>, or <code>TERMINATED</code> state. When you run RestoreServer, the
     * server's EC2 instance is deleted, and a new EC2 instance is configured. RestoreServer maintains the existing
     * server endpoint, so configuration management of the server's client devices (nodes) should continue to work.
     * </p>
     * <p>
     * Restoring from a backup is performed by creating a new EC2 instance. If restoration is successful, and the server
     * is in a <code>HEALTHY</code> state, AWS OpsWorks CM switches traffic over to the new instance. After restoration
     * is finished, the old EC2 instance is maintained in a <code>Running</code> or <code>Stopped</code> state, but is
     * eventually terminated.
     * </p>
     * <p>
     * This operation is asynchronous.
     * </p>
     * <p>
     * An <code>InvalidStateException</code> is thrown when the server is not in a valid state. A
     * <code>ResourceNotFoundException</code> is thrown when the server does not exist. A
     * <code>ValidationException</code> is raised when parameters of the request are not valid.
     * </p>
     *
     * @param restoreServerRequest
     * @return Result of the RestoreServer operation returned by the service.
     * @throws InvalidStateException
     *         The resource is in a state that does not allow you to perform a specified action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.RestoreServer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/RestoreServer" target="_top">AWS API
     *      Documentation</a>
     */
    default RestoreServerResponse restoreServer(RestoreServerRequest restoreServerRequest) throws InvalidStateException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpsWorksCmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restores a backup to a server that is in a <code>CONNECTION_LOST</code>, <code>HEALTHY</code>,
     * <code>RUNNING</code>, <code>UNHEALTHY</code>, or <code>TERMINATED</code> state. When you run RestoreServer, the
     * server's EC2 instance is deleted, and a new EC2 instance is configured. RestoreServer maintains the existing
     * server endpoint, so configuration management of the server's client devices (nodes) should continue to work.
     * </p>
     * <p>
     * Restoring from a backup is performed by creating a new EC2 instance. If restoration is successful, and the server
     * is in a <code>HEALTHY</code> state, AWS OpsWorks CM switches traffic over to the new instance. After restoration
     * is finished, the old EC2 instance is maintained in a <code>Running</code> or <code>Stopped</code> state, but is
     * eventually terminated.
     * </p>
     * <p>
     * This operation is asynchronous.
     * </p>
     * <p>
     * An <code>InvalidStateException</code> is thrown when the server is not in a valid state. A
     * <code>ResourceNotFoundException</code> is thrown when the server does not exist. A
     * <code>ValidationException</code> is raised when parameters of the request are not valid.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreServerRequest.Builder} avoiding the need to
     * create one manually via {@link RestoreServerRequest#builder()}
     * </p>
     *
     * @param restoreServerRequest
     *        A {@link Consumer} that will call methods on {@link RestoreServerRequest.Builder} to create a request.
     * @return Result of the RestoreServer operation returned by the service.
     * @throws InvalidStateException
     *         The resource is in a state that does not allow you to perform a specified action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.RestoreServer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/RestoreServer" target="_top">AWS API
     *      Documentation</a>
     */
    default RestoreServerResponse restoreServer(Consumer<RestoreServerRequest.Builder> restoreServerRequest)
            throws InvalidStateException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, OpsWorksCmException {
        return restoreServer(RestoreServerRequest.builder().applyMutation(restoreServerRequest).build());
    }

    /**
     * <p>
     * Manually starts server maintenance. This command can be useful if an earlier maintenance attempt failed, and the
     * underlying cause of maintenance failure has been resolved. The server is in an <code>UNDER_MAINTENANCE</code>
     * state while maintenance is in progress.
     * </p>
     * <p>
     * Maintenance can only be started on servers in <code>HEALTHY</code> and <code>UNHEALTHY</code> states. Otherwise,
     * an <code>InvalidStateException</code> is thrown. A <code>ResourceNotFoundException</code> is thrown when the
     * server does not exist. A <code>ValidationException</code> is raised when parameters of the request are not valid.
     * </p>
     *
     * @param startMaintenanceRequest
     * @return Result of the StartMaintenance operation returned by the service.
     * @throws InvalidStateException
     *         The resource is in a state that does not allow you to perform a specified action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.StartMaintenance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/StartMaintenance" target="_top">AWS
     *      API Documentation</a>
     */
    default StartMaintenanceResponse startMaintenance(StartMaintenanceRequest startMaintenanceRequest)
            throws InvalidStateException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, OpsWorksCmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Manually starts server maintenance. This command can be useful if an earlier maintenance attempt failed, and the
     * underlying cause of maintenance failure has been resolved. The server is in an <code>UNDER_MAINTENANCE</code>
     * state while maintenance is in progress.
     * </p>
     * <p>
     * Maintenance can only be started on servers in <code>HEALTHY</code> and <code>UNHEALTHY</code> states. Otherwise,
     * an <code>InvalidStateException</code> is thrown. A <code>ResourceNotFoundException</code> is thrown when the
     * server does not exist. A <code>ValidationException</code> is raised when parameters of the request are not valid.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMaintenanceRequest.Builder} avoiding the need
     * to create one manually via {@link StartMaintenanceRequest#builder()}
     * </p>
     *
     * @param startMaintenanceRequest
     *        A {@link Consumer} that will call methods on {@link StartMaintenanceRequest.Builder} to create a request.
     * @return Result of the StartMaintenance operation returned by the service.
     * @throws InvalidStateException
     *         The resource is in a state that does not allow you to perform a specified action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.StartMaintenance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/StartMaintenance" target="_top">AWS
     *      API Documentation</a>
     */
    default StartMaintenanceResponse startMaintenance(Consumer<StartMaintenanceRequest.Builder> startMaintenanceRequest)
            throws InvalidStateException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, OpsWorksCmException {
        return startMaintenance(StartMaintenanceRequest.builder().applyMutation(startMaintenanceRequest).build());
    }

    /**
     * <p>
     * Applies tags to an AWS OpsWorks for Chef Automate or AWS OpsWorks for Puppet Enterprise server, or to server
     * backups.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws InvalidStateException
     *         The resource is in a state that does not allow you to perform a specified action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            ValidationException, InvalidStateException, AwsServiceException, SdkClientException, OpsWorksCmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies tags to an AWS OpsWorks for Chef Automate or AWS OpsWorks for Puppet Enterprise server, or to server
     * backups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws InvalidStateException
     *         The resource is in a state that does not allow you to perform a specified action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, ValidationException, InvalidStateException, AwsServiceException,
            SdkClientException, OpsWorksCmException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes specified tags from an AWS OpsWorks-CM server or backup.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws InvalidStateException
     *         The resource is in a state that does not allow you to perform a specified action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            ValidationException, InvalidStateException, AwsServiceException, SdkClientException, OpsWorksCmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes specified tags from an AWS OpsWorks-CM server or backup.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws InvalidStateException
     *         The resource is in a state that does not allow you to perform a specified action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, ValidationException, InvalidStateException, AwsServiceException,
            SdkClientException, OpsWorksCmException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates settings for a server.
     * </p>
     * <p>
     * This operation is synchronous.
     * </p>
     *
     * @param updateServerRequest
     * @return Result of the UpdateServer operation returned by the service.
     * @throws InvalidStateException
     *         The resource is in a state that does not allow you to perform a specified action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.UpdateServer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/UpdateServer" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateServerResponse updateServer(UpdateServerRequest updateServerRequest) throws InvalidStateException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpsWorksCmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates settings for a server.
     * </p>
     * <p>
     * This operation is synchronous.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServerRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateServerRequest#builder()}
     * </p>
     *
     * @param updateServerRequest
     *        A {@link Consumer} that will call methods on {@link UpdateServerRequest.Builder} to create a request.
     * @return Result of the UpdateServer operation returned by the service.
     * @throws InvalidStateException
     *         The resource is in a state that does not allow you to perform a specified action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.UpdateServer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/UpdateServer" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateServerResponse updateServer(Consumer<UpdateServerRequest.Builder> updateServerRequest)
            throws InvalidStateException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, OpsWorksCmException {
        return updateServer(UpdateServerRequest.builder().applyMutation(updateServerRequest).build());
    }

    /**
     * <p>
     * Updates engine-specific attributes on a specified server. The server enters the <code>MODIFYING</code> state when
     * this operation is in progress. Only one update can occur at a time. You can use this command to reset a Chef
     * server's public key (<code>CHEF_PIVOTAL_KEY</code>) or a Puppet server's admin password (
     * <code>PUPPET_ADMIN_PASSWORD</code>).
     * </p>
     * <p>
     * This operation is asynchronous.
     * </p>
     * <p>
     * This operation can only be called for servers in <code>HEALTHY</code> or <code>UNHEALTHY</code> states.
     * Otherwise, an <code>InvalidStateException</code> is raised. A <code>ResourceNotFoundException</code> is thrown
     * when the server does not exist. A <code>ValidationException</code> is raised when parameters of the request are
     * not valid.
     * </p>
     *
     * @param updateServerEngineAttributesRequest
     * @return Result of the UpdateServerEngineAttributes operation returned by the service.
     * @throws InvalidStateException
     *         The resource is in a state that does not allow you to perform a specified action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.UpdateServerEngineAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/UpdateServerEngineAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateServerEngineAttributesResponse updateServerEngineAttributes(
            UpdateServerEngineAttributesRequest updateServerEngineAttributesRequest) throws InvalidStateException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpsWorksCmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates engine-specific attributes on a specified server. The server enters the <code>MODIFYING</code> state when
     * this operation is in progress. Only one update can occur at a time. You can use this command to reset a Chef
     * server's public key (<code>CHEF_PIVOTAL_KEY</code>) or a Puppet server's admin password (
     * <code>PUPPET_ADMIN_PASSWORD</code>).
     * </p>
     * <p>
     * This operation is asynchronous.
     * </p>
     * <p>
     * This operation can only be called for servers in <code>HEALTHY</code> or <code>UNHEALTHY</code> states.
     * Otherwise, an <code>InvalidStateException</code> is raised. A <code>ResourceNotFoundException</code> is thrown
     * when the server does not exist. A <code>ValidationException</code> is raised when parameters of the request are
     * not valid.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServerEngineAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateServerEngineAttributesRequest#builder()}
     * </p>
     *
     * @param updateServerEngineAttributesRequest
     *        A {@link Consumer} that will call methods on {@link UpdateServerEngineAttributesRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateServerEngineAttributes operation returned by the service.
     * @throws InvalidStateException
     *         The resource is in a state that does not allow you to perform a specified action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ValidationException
     *         One or more of the provided request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpsWorksCmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpsWorksCmClient.UpdateServerEngineAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/UpdateServerEngineAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateServerEngineAttributesResponse updateServerEngineAttributes(
            Consumer<UpdateServerEngineAttributesRequest.Builder> updateServerEngineAttributesRequest)
            throws InvalidStateException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, OpsWorksCmException {
        return updateServerEngineAttributes(UpdateServerEngineAttributesRequest.builder()
                .applyMutation(updateServerEngineAttributesRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("opsworks-cm");
    }
}
