/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.client.ClientHandler;
import software.amazon.awssdk.core.client.SdkClientHandler;
import software.amazon.awssdk.core.config.ClientConfiguration;
import software.amazon.awssdk.core.config.SyncClientConfiguration;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.core.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.opsworkscm.OpsWorksCMClient;
import software.amazon.awssdk.services.opsworkscm.model.AssociateNodeRequest;
import software.amazon.awssdk.services.opsworkscm.model.AssociateNodeResponse;
import software.amazon.awssdk.services.opsworkscm.model.CreateBackupRequest;
import software.amazon.awssdk.services.opsworkscm.model.CreateBackupResponse;
import software.amazon.awssdk.services.opsworkscm.model.CreateServerRequest;
import software.amazon.awssdk.services.opsworkscm.model.CreateServerResponse;
import software.amazon.awssdk.services.opsworkscm.model.DeleteBackupRequest;
import software.amazon.awssdk.services.opsworkscm.model.DeleteBackupResponse;
import software.amazon.awssdk.services.opsworkscm.model.DeleteServerRequest;
import software.amazon.awssdk.services.opsworkscm.model.DeleteServerResponse;
import software.amazon.awssdk.services.opsworkscm.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.opsworkscm.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.opsworkscm.model.DescribeBackupsRequest;
import software.amazon.awssdk.services.opsworkscm.model.DescribeBackupsResponse;
import software.amazon.awssdk.services.opsworkscm.model.DescribeEventsRequest;
import software.amazon.awssdk.services.opsworkscm.model.DescribeEventsResponse;
import software.amazon.awssdk.services.opsworkscm.model.DescribeNodeAssociationStatusRequest;
import software.amazon.awssdk.services.opsworkscm.model.DescribeNodeAssociationStatusResponse;
import software.amazon.awssdk.services.opsworkscm.model.DescribeServersRequest;
import software.amazon.awssdk.services.opsworkscm.model.DescribeServersResponse;
import software.amazon.awssdk.services.opsworkscm.model.DisassociateNodeRequest;
import software.amazon.awssdk.services.opsworkscm.model.DisassociateNodeResponse;
import software.amazon.awssdk.services.opsworkscm.model.InvalidNextTokenException;
import software.amazon.awssdk.services.opsworkscm.model.InvalidStateException;
import software.amazon.awssdk.services.opsworkscm.model.LimitExceededException;
import software.amazon.awssdk.services.opsworkscm.model.OpsWorksCMException;
import software.amazon.awssdk.services.opsworkscm.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.opsworkscm.model.ResourceNotFoundException;
import software.amazon.awssdk.services.opsworkscm.model.RestoreServerRequest;
import software.amazon.awssdk.services.opsworkscm.model.RestoreServerResponse;
import software.amazon.awssdk.services.opsworkscm.model.StartMaintenanceRequest;
import software.amazon.awssdk.services.opsworkscm.model.StartMaintenanceResponse;
import software.amazon.awssdk.services.opsworkscm.model.UpdateServerEngineAttributesRequest;
import software.amazon.awssdk.services.opsworkscm.model.UpdateServerEngineAttributesResponse;
import software.amazon.awssdk.services.opsworkscm.model.UpdateServerRequest;
import software.amazon.awssdk.services.opsworkscm.model.UpdateServerResponse;
import software.amazon.awssdk.services.opsworkscm.model.ValidationException;
import software.amazon.awssdk.services.opsworkscm.transform.AssociateNodeRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.AssociateNodeResponseUnmarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.CreateBackupRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.CreateBackupResponseUnmarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.CreateServerRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.CreateServerResponseUnmarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DeleteBackupRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DeleteBackupResponseUnmarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DeleteServerRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DeleteServerResponseUnmarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DescribeAccountAttributesRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DescribeAccountAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DescribeBackupsRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DescribeBackupsResponseUnmarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DescribeEventsResponseUnmarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DescribeNodeAssociationStatusRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DescribeNodeAssociationStatusResponseUnmarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DescribeServersRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DescribeServersResponseUnmarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DisassociateNodeRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DisassociateNodeResponseUnmarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.RestoreServerRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.RestoreServerResponseUnmarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.StartMaintenanceRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.StartMaintenanceResponseUnmarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.UpdateServerEngineAttributesRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.UpdateServerEngineAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.UpdateServerRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.UpdateServerResponseUnmarshaller;

@SdkInternalApi
final class DefaultOpsWorksCMClient
implements OpsWorksCMClient {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final ClientConfiguration clientConfiguration;

    protected DefaultOpsWorksCMClient(SyncClientConfiguration clientConfiguration) {
        this.clientHandler = new SdkClientHandler(clientConfiguration, null);
        this.protocolFactory = this.init();
        this.clientConfiguration = clientConfiguration;
    }

    @Override
    public AssociateNodeResponse associateNode(AssociateNodeRequest associateNodeRequest) throws InvalidStateException, ResourceNotFoundException, ValidationException, SdkServiceException, SdkClientException, OpsWorksCMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AssociateNodeResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (AssociateNodeResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateNodeRequest).withMarshaller((Marshaller)new AssociateNodeRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateBackupResponse createBackup(CreateBackupRequest createBackupRequest) throws InvalidStateException, LimitExceededException, ResourceNotFoundException, ValidationException, SdkServiceException, SdkClientException, OpsWorksCMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateBackupResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateBackupResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createBackupRequest).withMarshaller((Marshaller)new CreateBackupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateServerResponse createServer(CreateServerRequest createServerRequest) throws LimitExceededException, ResourceAlreadyExistsException, ResourceNotFoundException, ValidationException, SdkServiceException, SdkClientException, OpsWorksCMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateServerResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateServerResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createServerRequest).withMarshaller((Marshaller)new CreateServerRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteBackupResponse deleteBackup(DeleteBackupRequest deleteBackupRequest) throws InvalidStateException, ResourceNotFoundException, ValidationException, SdkServiceException, SdkClientException, OpsWorksCMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteBackupResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteBackupResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteBackupRequest).withMarshaller((Marshaller)new DeleteBackupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteServerResponse deleteServer(DeleteServerRequest deleteServerRequest) throws InvalidStateException, ResourceNotFoundException, ValidationException, SdkServiceException, SdkClientException, OpsWorksCMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteServerResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteServerResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteServerRequest).withMarshaller((Marshaller)new DeleteServerRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeAccountAttributesResponse describeAccountAttributes(DescribeAccountAttributesRequest describeAccountAttributesRequest) throws SdkServiceException, SdkClientException, OpsWorksCMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAccountAttributesResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeAccountAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAccountAttributesRequest).withMarshaller((Marshaller)new DescribeAccountAttributesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeBackupsResponse describeBackups(DescribeBackupsRequest describeBackupsRequest) throws ValidationException, ResourceNotFoundException, InvalidNextTokenException, SdkServiceException, SdkClientException, OpsWorksCMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeBackupsResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeBackupsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeBackupsRequest).withMarshaller((Marshaller)new DescribeBackupsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeEventsResponse describeEvents(DescribeEventsRequest describeEventsRequest) throws ValidationException, InvalidNextTokenException, ResourceNotFoundException, SdkServiceException, SdkClientException, OpsWorksCMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEventsResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventsRequest).withMarshaller((Marshaller)new DescribeEventsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeNodeAssociationStatusResponse describeNodeAssociationStatus(DescribeNodeAssociationStatusRequest describeNodeAssociationStatusRequest) throws ResourceNotFoundException, ValidationException, SdkServiceException, SdkClientException, OpsWorksCMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeNodeAssociationStatusResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeNodeAssociationStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeNodeAssociationStatusRequest).withMarshaller((Marshaller)new DescribeNodeAssociationStatusRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeServersResponse describeServers(DescribeServersRequest describeServersRequest) throws ValidationException, ResourceNotFoundException, InvalidNextTokenException, SdkServiceException, SdkClientException, OpsWorksCMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeServersResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeServersResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeServersRequest).withMarshaller((Marshaller)new DescribeServersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DisassociateNodeResponse disassociateNode(DisassociateNodeRequest disassociateNodeRequest) throws InvalidStateException, ResourceNotFoundException, ValidationException, SdkServiceException, SdkClientException, OpsWorksCMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateNodeResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DisassociateNodeResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateNodeRequest).withMarshaller((Marshaller)new DisassociateNodeRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RestoreServerResponse restoreServer(RestoreServerRequest restoreServerRequest) throws InvalidStateException, ResourceNotFoundException, ValidationException, SdkServiceException, SdkClientException, OpsWorksCMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RestoreServerResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (RestoreServerResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)restoreServerRequest).withMarshaller((Marshaller)new RestoreServerRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public StartMaintenanceResponse startMaintenance(StartMaintenanceRequest startMaintenanceRequest) throws InvalidStateException, ResourceNotFoundException, ValidationException, SdkServiceException, SdkClientException, OpsWorksCMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartMaintenanceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (StartMaintenanceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startMaintenanceRequest).withMarshaller((Marshaller)new StartMaintenanceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateServerResponse updateServer(UpdateServerRequest updateServerRequest) throws InvalidStateException, ResourceNotFoundException, ValidationException, SdkServiceException, SdkClientException, OpsWorksCMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateServerResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateServerResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateServerRequest).withMarshaller((Marshaller)new UpdateServerRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateServerEngineAttributesResponse updateServerEngineAttributes(UpdateServerEngineAttributesRequest updateServerEngineAttributesRequest) throws InvalidStateException, ResourceNotFoundException, ValidationException, SdkServiceException, SdkClientException, OpsWorksCMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateServerEngineAttributesResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateServerEngineAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateServerEngineAttributesRequest).withMarshaller((Marshaller)new UpdateServerEngineAttributesRequestMarshaller(this.protocolFactory)));
    }

    private HttpResponseHandler<SdkServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(OpsWorksCMException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withModeledClass(ValidationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceAlreadyExistsException").withModeledClass(ResourceAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidStateException").withModeledClass(InvalidStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withModeledClass(InvalidNextTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)));
    }

    public void close() {
        this.clientHandler.close();
    }
}

